/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.jdbc.proto.event;

import org.apache.ignite.internal.client.proto.ClientMessagePacker;
import org.apache.ignite.internal.client.proto.ClientMessageUnpacker;
import org.apache.ignite.internal.jdbc.proto.ClientMessage;
import org.apache.ignite.internal.jdbc.proto.event.ClientMessageUtils;
import org.apache.ignite.internal.tostring.S;

public class JdbcMetaTablesRequest
implements ClientMessage {
    private String schemaName;
    private String tblName;
    private String[] tblTypes;

    public JdbcMetaTablesRequest() {
    }

    public JdbcMetaTablesRequest(String schemaName, String tblName, String[] tblTypes) {
        this.schemaName = schemaName;
        this.tblName = tblName;
        this.tblTypes = tblTypes;
    }

    public String schemaName() {
        return this.schemaName;
    }

    public String tableName() {
        return this.tblName;
    }

    public String[] tableTypes() {
        return this.tblTypes;
    }

    @Override
    public void writeBinary(ClientMessagePacker packer) {
        ClientMessageUtils.writeStringNullable(packer, this.schemaName);
        ClientMessageUtils.writeStringNullable(packer, this.tblName);
        if (this.tblTypes == null) {
            packer.packNil();
            return;
        }
        packer.packInt(this.tblTypes.length);
        for (String type : this.tblTypes) {
            packer.packString(type);
        }
    }

    @Override
    public void readBinary(ClientMessageUnpacker unpacker) {
        this.schemaName = ClientMessageUtils.readStringNullable(unpacker);
        this.tblName = ClientMessageUtils.readStringNullable(unpacker);
        if (unpacker.tryUnpackNil()) {
            return;
        }
        int size = unpacker.unpackInt();
        this.tblTypes = new String[size];
        for (int i = 0; i < size; ++i) {
            this.tblTypes[i] = unpacker.unpackString();
        }
    }

    public String toString() {
        return S.toString(JdbcMetaTablesRequest.class, this);
    }
}

