/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.configuration.notifications;

import org.apache.ignite.configuration.notifications.ConfigurationNotificationEvent;
import org.apache.ignite.internal.configuration.notifications.ConfigurationContainer;
import org.jetbrains.annotations.Nullable;

class ConfigurationNotificationEventImpl<VIEWT>
implements ConfigurationNotificationEvent<VIEWT> {
    @Nullable
    private final VIEWT oldValue;
    @Nullable
    private final VIEWT newValue;
    private final long storageRevision;
    private final ConfigurationContainer tail;

    ConfigurationNotificationEventImpl(@Nullable VIEWT oldValue, @Nullable VIEWT newValue, long storageRevision, ConfigurationContainer tail) {
        this.oldValue = oldValue;
        this.newValue = newValue;
        this.storageRevision = storageRevision;
        this.tail = tail;
    }

    @Override
    @Nullable
    public VIEWT oldValue() {
        return this.oldValue;
    }

    @Override
    @Nullable
    public <T> T oldValue(Class<T> viewClass) {
        return this.tail.find(viewClass, true);
    }

    @Override
    @Nullable
    public VIEWT newValue() {
        return this.newValue;
    }

    @Override
    @Nullable
    public <T> T newValue(Class<T> viewClass) {
        return this.tail.find(viewClass, false);
    }

    @Override
    public long storageRevision() {
        return this.storageRevision;
    }

    @Override
    @Nullable
    public String oldName(Class<?> viewClass) {
        return this.tail.name(viewClass, true);
    }

    @Override
    @Nullable
    public String newName(Class<?> viewClass) {
        return this.tail.name(viewClass, false);
    }
}

