/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.configuration.asm;

import com.facebook.presto.bytecode.BytecodeBlock;
import com.facebook.presto.bytecode.BytecodeNode;
import com.facebook.presto.bytecode.BytecodeUtils;
import com.facebook.presto.bytecode.Scope;
import com.facebook.presto.bytecode.Variable;
import com.facebook.presto.bytecode.control.IfStatement;
import com.facebook.presto.bytecode.control.SwitchStatement;
import com.facebook.presto.bytecode.expression.BytecodeExpression;
import com.facebook.presto.bytecode.expression.BytecodeExpressions;
import java.lang.reflect.Method;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

class StringSwitchBuilder {
    private static final Method EQUALS;
    private static final Method HASH_CODE;
    private BytecodeExpression expression;
    private final Set<CaseStatement> cases = new LinkedHashSet<CaseStatement>();
    private BytecodeNode defaultBody;
    private final Scope scope;

    StringSwitchBuilder(Scope scope) {
        this.scope = scope;
    }

    public StringSwitchBuilder expression(BytecodeExpression expression) {
        this.expression = expression;
        return this;
    }

    public StringSwitchBuilder addCase(String key, BytecodeNode body) {
        CaseStatement statement = new CaseStatement(key, body);
        BytecodeUtils.checkState(this.cases.add(statement), "case already exists for value [%s]", key);
        return this;
    }

    public StringSwitchBuilder defaultCase(BytecodeNode body) {
        BytecodeUtils.checkState(this.defaultBody == null, "default case already set");
        this.defaultBody = Objects.requireNonNull(body, "body is null");
        return this;
    }

    public BytecodeBlock build() {
        BytecodeUtils.checkState(this.expression != null, "expression is not set");
        Variable expVar = this.scope.createTempVariable(String.class);
        Variable idxVar = this.scope.createTempVariable(Integer.TYPE);
        BytecodeBlock res = new BytecodeBlock().append(expVar.set(this.expression)).append(idxVar.set(BytecodeExpressions.constantInt(-1)));
        BytecodeNode[] caseBodies = new BytecodeNode[this.cases.size()];
        SwitchStatement.SwitchBuilder hashSwitch = SwitchStatement.switchBuilder().expression(expVar.invoke(HASH_CODE, new BytecodeExpression[0]));
        Map<Integer, List<CaseStatement>> groupedCases = this.cases.stream().collect(Collectors.groupingBy(statement -> statement.key.hashCode()));
        int idx = 0;
        for (Map.Entry<Integer, List<CaseStatement>> entry : groupedCases.entrySet()) {
            BytecodeBlock caseBody = new BytecodeBlock();
            for (CaseStatement caseStmt : entry.getValue()) {
                caseBody.append(new IfStatement().condition(expVar.invoke(EQUALS, BytecodeExpressions.constantString(caseStmt.key))).ifTrue(idxVar.set(BytecodeExpressions.constantInt(idx))));
                caseBodies[idx++] = caseStmt.body;
            }
            hashSwitch.addCase(entry.getKey(), caseBody);
        }
        res.append(hashSwitch.build());
        res.append(IntStream.range(0, caseBodies.length).boxed().reduce(SwitchStatement.switchBuilder().expression(idxVar), (builder, i) -> builder.addCase((int)i, caseBodies[i]), (b0, b1) -> b0).defaultCase(this.defaultBody).build());
        return res;
    }

    static {
        try {
            EQUALS = Object.class.getDeclaredMethod("equals", Object.class);
            HASH_CODE = Object.class.getDeclaredMethod("hashCode", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    private static class CaseStatement {
        private final String key;
        private final BytecodeNode body;

        CaseStatement(String key, BytecodeNode body) {
            this.key = key;
            this.body = Objects.requireNonNull(body, "body is null");
        }

        public int hashCode() {
            return this.key.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            CaseStatement other = (CaseStatement)obj;
            return Objects.equals(this.key, other.key);
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[key=" + this.key + "]";
        }
    }
}

