/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.sql;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.apache.ignite.catalog.ColumnSorted;
import org.apache.ignite.catalog.IndexType;
import org.apache.ignite.catalog.SortOrder;
import org.apache.ignite.catalog.definitions.ColumnDefinition;
import org.apache.ignite.internal.catalog.sql.SelectFromView;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.sql.ColumnType;
import org.apache.ignite.sql.IgniteSql;
import org.apache.ignite.sql.SqlRow;
import org.apache.ignite.table.QualifiedName;

class DefinitionCollector<T> {
    private final QualifiedName objectName;
    private final IgniteSql sql;
    private final DefinitionBuilder<T> builder;
    private final String isCacheCondition;

    DefinitionCollector(QualifiedName objectName, IgniteSql sql, DefinitionBuilder<T> builder, String isCacheCondition) {
        Objects.requireNonNull(objectName, "objectName must not be null.");
        Objects.requireNonNull(sql, "sql must not be null.");
        Objects.requireNonNull(builder, "builder must not be null.");
        Objects.requireNonNull(isCacheCondition, "isCacheCondition must not be null.");
        this.objectName = objectName;
        this.sql = sql;
        this.builder = builder;
        this.isCacheCondition = isCacheCondition;
    }

    CompletableFuture<T> collectDefinition() {
        return this.collectTableInfo().thenCompose(builder -> {
            if (builder == null) {
                return CompletableFutures.nullCompletedFuture();
            }
            return this.collectIndexes((BuilderWithIndex<T>)builder).thenApply(DefinitionBuilder::build);
        });
    }

    private CompletableFuture<BuilderWithIndex<T>> collectTableInfo() {
        String query = "SELECT pk_index_id, zone_name, column_name, column_type, column_precision, column_scale, column_length, is_nullable_column, colocation_column_ordinal FROM system.tables t JOIN system.table_columns USING (table_id) WHERE t.schema_name=? AND t.table_name=? AND t.is_cache " + this.isCacheCondition + " ORDER BY column_ordinal";
        return SelectFromView.collectResults(this.sql, query, Function.identity(), this.objectName.schemaName(), this.objectName.objectName()).thenApply(list -> {
            if (list.isEmpty()) {
                return null;
            }
            ArrayList<ColumnDefinition> columns = new ArrayList<ColumnDefinition>();
            int indexId = ((SqlRow)list.get(0)).intValue("PK_INDEX_ID");
            String zoneName = ((SqlRow)list.get(0)).stringValue("ZONE_NAME");
            TreeMap<Integer, String> colocationColumns = new TreeMap<Integer, String>();
            for (SqlRow row : list) {
                String columnName = row.stringValue("COLUMN_NAME");
                String type = row.stringValue("COLUMN_TYPE");
                int length = row.intValue("COLUMN_LENGTH");
                int precision = row.intValue("COLUMN_PRECISION");
                int scale = row.intValue("COLUMN_SCALE");
                boolean nullable = row.booleanValue("IS_NULLABLE_COLUMN");
                Integer colocationOrd = (Integer)row.value("COLOCATION_COLUMN_ORDINAL");
                if (colocationOrd != null) {
                    colocationColumns.put(colocationOrd, columnName);
                }
                Class<?> typeClass = ColumnType.valueOf(type).javaClass();
                org.apache.ignite.catalog.ColumnType<?> columnType = org.apache.ignite.catalog.ColumnType.of(typeClass, length, precision, scale, nullable);
                ColumnDefinition column = ColumnDefinition.column(columnName, columnType);
                columns.add(column);
            }
            ArrayList<String> colocationColumnList = new ArrayList<String>(colocationColumns.values());
            DefinitionBuilder<T> builder = this.builder.newBuilder(this.objectName).zone(zoneName).columns(columns).colocateBy(colocationColumnList);
            return new BuilderWithIndex<T>(builder, indexId);
        });
    }

    private CompletableFuture<DefinitionBuilder<T>> collectIndexes(BuilderWithIndex<T> definition) {
        String query = "SELECT i.index_id, i.index_type, i.index_name, column_name, column_ordinal, column_collation FROM system.indexes i JOIN system.tables t USING (table_id) JOIN system.index_columns ic USING (index_id) WHERE t.schema_name=? AND t.table_name=? AND t.is_cache " + this.isCacheCondition + " ORDER BY index_id, column_ordinal";
        return SelectFromView.collectResults(this.sql, query, Function.identity(), this.objectName.schemaName(), this.objectName.objectName()).thenApply(list -> {
            LinkedHashMap<Integer, List> indexIdColumns = new LinkedHashMap<Integer, List>();
            HashMap<Integer, String> indexNames = new HashMap<Integer, String>();
            HashMap<Integer, IndexType> indexTypes = new HashMap<Integer, IndexType>();
            for (SqlRow sqlRow : list) {
                int indexId = sqlRow.intValue("INDEX_ID");
                String indexName = sqlRow.stringValue("INDEX_NAME");
                String indexType = sqlRow.stringValue("INDEX_TYPE");
                String columnName = sqlRow.stringValue("COLUMN_NAME");
                String columnCollation = sqlRow.stringValue("COLUMN_COLLATION");
                List columns = indexIdColumns.computeIfAbsent(indexId, key -> new ArrayList());
                indexNames.put(indexId, indexName);
                indexTypes.put(indexId, IndexType.valueOf(indexType));
                if (columnCollation == null) {
                    columns.add(ColumnSorted.column(columnName));
                    continue;
                }
                columns.add(ColumnSorted.column(columnName, SortOrder.valueOf(columnCollation)));
            }
            for (Map.Entry entry : indexIdColumns.entrySet()) {
                String name = (String)indexNames.get(entry.getKey());
                IndexType indexType = (IndexType)((Object)((Object)indexTypes.get(entry.getKey())));
                if (Objects.equals(entry.getKey(), definition.indexId)) {
                    definition.builder.primaryKey(indexType, (List)entry.getValue());
                    continue;
                }
                definition.builder.index(name, indexType, (List)entry.getValue());
            }
            return definition.builder;
        });
    }

    static interface DefinitionBuilder<T> {
        public DefinitionBuilder<T> newBuilder(QualifiedName var1);

        public DefinitionBuilder<T> zone(String var1);

        public DefinitionBuilder<T> primaryKey(IndexType var1, List<ColumnSorted> var2);

        public DefinitionBuilder<T> index(String var1, IndexType var2, List<ColumnSorted> var3);

        public DefinitionBuilder<T> colocateBy(List<String> var1);

        public DefinitionBuilder<T> columns(List<ColumnDefinition> var1);

        public T build();
    }

    private static class BuilderWithIndex<T> {
        private final DefinitionBuilder<T> builder;
        private final int indexId;

        private BuilderWithIndex(DefinitionBuilder<T> builder, int indexId) {
            this.builder = builder;
            this.indexId = indexId;
        }
    }
}

