/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.cluster.metadata;

import io.scalecube.cluster.metadata.MetadataCodec;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.ByteBuffer;
import reactor.core.Exceptions;

public class JdkMetadataCodec
implements MetadataCodec {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object deserialize(ByteBuffer buffer) {
        byte[] bytes = buffer.array();
        try (ObjectInputStream is = new ObjectInputStream(new ByteArrayInputStream(bytes));){
            Object object = is.readObject();
            return object;
        }
        catch (Exception e) {
            throw Exceptions.propagate(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ByteBuffer serialize(Object metadata) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (ObjectOutputStream os = new ObjectOutputStream(baos);){
            os.writeObject(metadata);
            os.flush();
            ByteBuffer byteBuffer = ByteBuffer.wrap(baos.toByteArray());
            return byteBuffer;
        }
        catch (Exception e) {
            throw Exceptions.propagate(e);
        }
    }
}

