/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.dr.metrics;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.JMException;
import javax.management.ObjectName;
import org.apache.ignite.internal.lang.IgniteInternalException;
import org.apache.ignite.internal.lang.IgniteStringFormatter;
import org.apache.ignite.internal.lang.NodeStoppingException;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.util.IgniteSpinBusyLock;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.lang.ErrorGroups;
import org.gridgain.dr.configuration.DrReceiverServerView;
import org.gridgain.internal.dr.metrics.AnnotationAwareStandardMxBean;
import org.gridgain.internal.dr.metrics.DrBatchEventListener;
import org.gridgain.internal.dr.metrics.DrReceiverCacheMetricsMxBean;
import org.gridgain.internal.dr.metrics.DrReceiverCacheMetricsMxBeanImpl;
import org.gridgain.internal.dr.metrics.DrReceiverMxBean;
import org.gridgain.internal.dr.metrics.DrReceiverMxBeanImpl;

public class DrReceiverMetricsManager {
    public static final String GROUP_NAME = "Data center replication";
    public static final String DR_RECEIVER_REG_NAME_FORMAT = "receiver.dc{}.{}";
    private static final IgniteLogger LOG = Loggers.forClass(DrReceiverMetricsManager.class);
    private final boolean enabled;
    private final List<ObjectName> registeredBeans = new ArrayList<ObjectName>();
    private final IgniteSpinBusyLock busyLock = new IgniteSpinBusyLock();
    private final Object mux = new Object();
    private final DrReceiverMxBeanImpl aggregatedMetrics;
    private final ConcurrentHashMap<CacheMetricsMapKey, DrBatchEventListener> cacheMetricsMap = new ConcurrentHashMap();

    public DrReceiverMetricsManager(DrReceiverServerView cfg) {
        this.enabled = cfg.drReceiverMetricsEnabled();
        this.aggregatedMetrics = new DrReceiverMxBeanImpl(cfg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DrBatchEventListener getOrCreateCacheMetrics(byte dataCenterId, String cacheName) {
        if (!this.enabled) {
            return DrBatchEventListener.NOOP_LISTENER;
        }
        if (!this.busyLock.enterBusy()) {
            throw new IgniteInternalException(ErrorGroups.Common.NODE_STOPPING_ERR, (Throwable)new NodeStoppingException());
        }
        try {
            CacheMetricsMapKey key = new CacheMetricsMapKey(dataCenterId, cacheName);
            DrReceiverCacheMetricsMxBeanImpl newMetrics = new DrReceiverCacheMetricsMxBeanImpl(this.aggregatedMetrics);
            DrBatchEventListener existingMetrics = this.cacheMetricsMap.putIfAbsent(key, newMetrics);
            if (existingMetrics != null) {
                DrBatchEventListener drBatchEventListener = existingMetrics;
                return drBatchEventListener;
            }
            this.registerMxBean(newMetrics, DrReceiverCacheMetricsMxBean.class, key.name());
            DrReceiverCacheMetricsMxBeanImpl drReceiverCacheMetricsMxBeanImpl = newMetrics;
            return drReceiverCacheMetricsMxBeanImpl;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    public void start() {
        if (this.enabled) {
            this.registerMxBean(this.aggregatedMetrics, DrReceiverMxBean.class, "receiver");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.busyLock.block();
        if (!this.enabled) {
            return;
        }
        try {
            Object object = this.mux;
            synchronized (object) {
                this.registeredBeans.forEach(this::unregisterMxBean);
            }
        }
        catch (Exception e) {
            LOG.warn("Unable to stop metric manager", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void registerMxBean(T implementation, Class<T> mbeanInterface, String name) {
        try {
            Object object = this.mux;
            synchronized (object) {
                ObjectName objectName = ManagementFactory.getPlatformMBeanServer().registerMBean(new AnnotationAwareStandardMxBean(implementation, mbeanInterface), IgniteUtils.makeMbeanName(null, (String)GROUP_NAME, (String)name)).getObjectName();
                this.registeredBeans.add(objectName);
            }
        }
        catch (JMException e) {
            LOG.error("MBean for metric set {} can't be created.", (Throwable)e, new Object[]{name});
        }
    }

    private void unregisterMxBean(ObjectName objectName) {
        try {
            ManagementFactory.getPlatformMBeanServer().unregisterMBean(objectName);
        }
        catch (JMException e) {
            LOG.error("Failed to unregister MBean: {}", (Throwable)e, new Object[]{objectName});
        }
    }

    static class CacheMetricsMapKey {
        final byte dataCenterId;
        final String cacheName;

        CacheMetricsMapKey(byte dataCenterId, String cacheName) {
            this.dataCenterId = dataCenterId;
            this.cacheName = cacheName;
        }

        String name() {
            return IgniteStringFormatter.format((String)DrReceiverMetricsManager.DR_RECEIVER_REG_NAME_FORMAT, (Object[])new Object[]{this.dataCenterId, this.cacheName});
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheMetricsMapKey that = (CacheMetricsMapKey)o;
            return this.dataCenterId == that.dataCenterId && Objects.equals(this.cacheName, that.cacheName);
        }

        public int hashCode() {
            return Objects.hash(this.dataCenterId, this.cacheName);
        }
    }
}

