/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.dr.mapping;

import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.ZoneId;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ignite.table.QualifiedName;
import org.apache.ignite.table.QualifiedNameHelper;
import org.apache.ignite.table.Tuple;
import org.gridgain.internal.dr.mapping.CacheMapping;
import org.gridgain.internal.dr.mapping.TupleColumnWriter;
import org.gridgain.internal.dr.mapping.TupleColumnWriterFactory;
import org.jetbrains.annotations.Nullable;

public class TupleColumnWriterFactoryImpl
implements TupleColumnWriterFactory {
    private final ZoneId zoneId;
    private final ConcurrentHashMap<String, TupleColumnWriter> writers;

    public TupleColumnWriterFactoryImpl(ZoneId zoneId, Map<String, CacheMapping> cacheMappings) {
        ConcurrentHashMap<String, TupleFieldWriterImpl> writers = new ConcurrentHashMap<String, TupleFieldWriterImpl>(cacheMappings.size());
        for (Map.Entry<String, CacheMapping> entry : cacheMappings.entrySet()) {
            CacheMapping cacheMapping = entry.getValue();
            writers.put(cacheMapping.cacheName(), new TupleFieldWriterImpl(cacheMapping, zoneId));
        }
        this.zoneId = zoneId;
        this.writers = writers;
    }

    @Override
    public TupleColumnWriter getWriter(String cacheName) {
        return this.writers.computeIfAbsent(cacheName, key -> {
            CacheMapping mapping = new CacheMapping.Builder((String)key).tableName(QualifiedNameHelper.fromNormalized(null, (String)cacheName)).build();
            return new TupleFieldWriterImpl(mapping, this.zoneId);
        });
    }

    @Nullable
    private static Object convertValue(@Nullable Object value, ZoneId zoneId) {
        if (value == null) {
            return null;
        }
        if (value instanceof Time) {
            return Instant.ofEpochMilli(((Time)value).getTime()).atZone(zoneId).toLocalTime();
        }
        if (value instanceof Timestamp) {
            return ((Timestamp)value).toInstant().atZone(zoneId).toLocalDateTime();
        }
        if (value instanceof java.sql.Date) {
            return Instant.ofEpochMilli(((java.sql.Date)value).getTime()).atZone(zoneId).toLocalDate();
        }
        if (value instanceof Date) {
            return ((Date)value).toInstant();
        }
        return value;
    }

    private static class TupleFieldWriterImpl
    implements TupleColumnWriter {
        private final CacheMapping cacheMapping;
        private final ZoneId zoneId;

        TupleFieldWriterImpl(CacheMapping cacheMapping, ZoneId zoneId) {
            this.cacheMapping = cacheMapping;
            this.zoneId = zoneId;
        }

        @Override
        public QualifiedName tableName() {
            return this.cacheMapping.tableName();
        }

        @Override
        public void writeKeyField(Tuple tuple, String fieldName, @Nullable Object value) {
            this.writeValue(fieldName, true, tuple, value);
        }

        @Override
        public void writeValueField(Tuple tuple, String fieldName, @Nullable Object value) {
            if (this.cacheMapping.ignoreFields().contains(fieldName)) {
                return;
            }
            this.writeValue(fieldName, false, tuple, value);
        }

        private void writeValue(String fieldName, boolean key, Tuple tuple, @Nullable Object value) {
            String columnName = this.cacheMapping.columnName(fieldName, key);
            if (columnName == null) {
                columnName = fieldName;
            }
            tuple.set(columnName, TupleColumnWriterFactoryImpl.convertValue(value, this.zoneId));
        }
    }
}

