/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.structure.map;

import java.util.AbstractMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.ignite.internal.lang.IgniteExceptionMapperUtil;
import org.apache.ignite.internal.util.CollectionUtils;
import org.apache.ignite.internal.util.ExceptionUtils;
import org.apache.ignite.lang.AsyncCursor;
import org.apache.ignite.marshalling.Marshaller;
import org.apache.ignite.sql.IgniteSql;
import org.apache.ignite.sql.SqlRow;
import org.apache.ignite.sql.async.AsyncResultSet;
import org.apache.ignite.table.KeyValueView;
import org.gridgain.structure.IgniteMap;
import org.gridgain.structure.StructureUtils;
import org.jetbrains.annotations.Nullable;

public class IgniteMapImpl<K, V>
implements IgniteMap<K, V> {
    private final String tableName;
    private final IgniteSql sql;
    private final Marshaller<K, ?> km;
    private final Marshaller<V, ?> vm;
    private final KeyValueView<?, ?> kvView;

    public IgniteMapImpl(String tableName, KeyValueView<?, ?> kvView, IgniteSql sql, Marshaller<K, ?> km, Marshaller<V, ?> vm) {
        this.tableName = tableName;
        this.kvView = kvView;
        this.sql = sql;
        this.km = km;
        this.vm = vm;
    }

    @Override
    public CompletableFuture<@Nullable V> putAsync(K key, V value) {
        Objects.requireNonNull(key, "key is null");
        return this.kvView.getAndPutAsync(null, StructureUtils.cast(this.km.marshal(key)), StructureUtils.cast(this.vm.marshal(value))).thenApply(v -> this.vm.unmarshal(StructureUtils.cast(v)));
    }

    @Override
    public CompletableFuture<@Nullable V> removeAsync(K key) {
        Objects.requireNonNull(key, "key is null");
        return this.kvView.getAndRemoveAsync(null, StructureUtils.cast(this.km.marshal(key))).thenApply(v -> this.vm.unmarshal(StructureUtils.cast(v)));
    }

    @Override
    public CompletableFuture<Void> putAllAsync(Map<? extends K, ? extends V> m) {
        Objects.requireNonNull(m, "map is null");
        Map<Object, Object> collect = m.entrySet().stream().collect(Collectors.toMap(e -> this.km.marshal(e.getKey()), e -> this.vm.marshal(e.getValue())));
        return this.kvView.putAllAsync(null, StructureUtils.cast(collect));
    }

    @Override
    public CompletableFuture<V> getAsync(K key) {
        Objects.requireNonNull(key, "key is null");
        return this.kvView.getAsync(null, StructureUtils.cast(this.km.marshal(key))).thenApply(v -> this.vm.unmarshal(StructureUtils.cast(v)));
    }

    @Override
    public CompletableFuture<Boolean> containsKeyAsync(K key) {
        Objects.requireNonNull(key, "key is null");
        return this.kvView.containsAsync(null, StructureUtils.cast(this.km.marshal(key)));
    }

    @Override
    public CompletableFuture<Long> sizeAsync() {
        return this.sql.executeAsync(null, String.format("select count(*) from %s", this.tableName), new Object[0]).thenCompose(resultSet -> {
            AtomicLong size = new AtomicLong(0L);
            Iterator iterator = resultSet.currentPage().iterator();
            if (iterator.hasNext()) {
                size.set(((SqlRow)iterator.next()).longValue(0));
            }
            return resultSet.closeAsync().thenApply(unused -> size.get());
        });
    }

    @Override
    public CompletableFuture<Void> clearAsync() {
        return this.sql.executeAsync(null, String.format("DELETE * FROM %s", this.tableName), new Object[0]).thenCompose(AsyncResultSet::closeAsync);
    }

    @Override
    public CompletableFuture<AsyncCursor<Map.Entry<K, V>>> getAllAsync() {
        return this.kvView.queryAsync(null, null).thenApply(cursor -> new MapAsyncCursor<Map.Entry, Map.Entry>((AsyncCursor<Map.Entry>)cursor, e -> new AbstractMap.SimpleEntry<K, V>(this.km.unmarshal(StructureUtils.cast(e.getKey())), this.vm.unmarshal(StructureUtils.cast(e.getValue())))));
    }

    @Override
    public CompletableFuture<Boolean> isEmptyAsync() {
        return this.sql.executeAsync(null, String.format("SELECT 1 FROM %s limit 1", this.tableName), new Object[0]).thenCompose(result -> {
            boolean hasItem = result.hasRowSet() && result.currentPageSize() > 0;
            return result.closeAsync().thenApply(unused -> !hasItem);
        });
    }

    @Override
    public V put(K key, V value) {
        return IgniteMapImpl.sync(this.putAsync(key, value));
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        IgniteMapImpl.sync(this.putAllAsync(m));
    }

    @Override
    public boolean containsKey(K key) {
        return IgniteMapImpl.sync(this.containsKeyAsync(key));
    }

    @Override
    public boolean isEmpty() {
        return IgniteMapImpl.sync(this.isEmptyAsync());
    }

    @Override
    public V remove(K key) {
        return IgniteMapImpl.sync(this.removeAsync(key));
    }

    @Override
    public V get(K key) {
        return IgniteMapImpl.sync(this.getAsync(key));
    }

    @Override
    public long size() {
        return IgniteMapImpl.sync(this.sizeAsync());
    }

    @Override
    public AsyncCursor<Map.Entry<K, V>> getAll() {
        return IgniteMapImpl.sync(this.getAllAsync());
    }

    @Override
    public void clear() {
        IgniteMapImpl.sync(this.clearAsync());
    }

    private static <R> R sync(CompletableFuture<R> future) {
        try {
            return future.join();
        }
        catch (CompletionException e) {
            throw (RuntimeException)ExceptionUtils.sneakyThrow(IgniteExceptionMapperUtil.mapToPublicException(ExceptionUtils.unwrapCause(e)));
        }
    }

    private static class MapAsyncCursor<T, U>
    implements AsyncCursor<U> {
        private final AsyncCursor<T> cursor;
        private final Function<T, U> mapper;

        private MapAsyncCursor(AsyncCursor<T> cursor, Function<T, U> mapper) {
            this.cursor = cursor;
            this.mapper = mapper;
        }

        @Override
        public Iterable<U> currentPage() {
            return CollectionUtils.mapIterable(this.cursor.currentPage(), this.mapper, null);
        }

        @Override
        public int currentPageSize() {
            return this.cursor.currentPageSize();
        }

        @Override
        public CompletableFuture<? extends AsyncCursor<U>> fetchNextPage() {
            return this.cursor.fetchNextPage().thenApply(cursor -> new MapAsyncCursor<T, U>(cursor, this.mapper));
        }

        @Override
        public boolean hasMorePages() {
            return this.cursor.hasMorePages();
        }

        @Override
        public CompletableFuture<Void> closeAsync() {
            return this.cursor.closeAsync();
        }
    }
}

