/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.dr;

import org.apache.ignite.table.Tuple;
import org.gridgain.internal.dr.DrUpdate;
import org.gridgain.internal.dr.binary.BinaryContext;
import org.gridgain.internal.dr.binary.BinaryMetadata;
import org.gridgain.internal.dr.binary.BinaryObject;
import org.gridgain.internal.dr.binary.BinarySchema;
import org.gridgain.internal.dr.common.GridCacheRawVersionedEntry;
import org.gridgain.internal.dr.mapping.TupleColumnWriter;
import org.jetbrains.annotations.Nullable;

public class DrEntryConverter {
    private final BinaryContext binaryContext;
    private final TupleColumnWriter tupleColumnWriter;

    DrEntryConverter(BinaryContext binaryContext, TupleColumnWriter tupleColumnWriter) {
        this.binaryContext = binaryContext;
        this.tupleColumnWriter = tupleColumnWriter;
    }

    public DrUpdate convert(GridCacheRawVersionedEntry e) {
        Tuple key = Tuple.create();
        this.convertKeyToTuple(key, e.key(), "_key");
        if (e.value() != null) {
            Tuple val = Tuple.create();
            this.convertValueToTuple(val, e.value(), "_val");
            return DrUpdate.row(key, e.keyBytes(), val, e.version());
        }
        return DrUpdate.tombstone(key, e.keyBytes(), e.version());
    }

    private void convertKeyToTuple(Tuple tuple, @Nullable Object obj, String defaultFieldName) {
        this.convertToTuple(this.tupleColumnWriter, tuple, true, obj, defaultFieldName);
    }

    private void convertValueToTuple(Tuple tuple, @Nullable Object obj, String defaultFieldName) {
        this.convertToTuple(this.tupleColumnWriter, tuple, false, obj, defaultFieldName);
    }

    private void convertToTuple(TupleColumnWriter writer, Tuple tuple, boolean key, @Nullable Object obj, String defaultFieldName) {
        if (obj instanceof BinaryObject) {
            this.readBinaryObject(writer, (BinaryObject)obj, tuple, key);
        } else if (key) {
            writer.writeKeyField(tuple, defaultFieldName, obj);
        } else {
            writer.writeValueField(tuple, defaultFieldName, obj);
        }
    }

    private void readBinaryObject(TupleColumnWriter columnWriter, BinaryObject binObj, Tuple tuple, boolean key) {
        int schemaId = binObj.schemaId();
        int typeId = binObj.typeId();
        BinaryMetadata metadata = this.binaryContext.binaryMetadata(typeId);
        if (metadata == null) {
            throw new IllegalStateException("Binary metadata not found for type: typeId=" + typeId);
        }
        BinarySchema schema = metadata.schema(schemaId);
        if (schema == null) {
            throw new IllegalStateException("Binary schema not found for type: typeId=" + typeId + ", schemaId=" + schemaId);
        }
        for (int fieldId : schema.fieldIds()) {
            String fieldName = metadata.fieldName(fieldId);
            if (fieldName == null) {
                throw new IllegalStateException("No field in binary metadata: typeId=" + typeId + ", schemaId=" + schemaId + ", fieldId=" + fieldId);
            }
            int orderById = schema.orderById(fieldId);
            Object value = binObj.fieldByOrder(orderById);
            if (key) {
                columnWriter.writeKeyField(tuple, fieldName, value);
                continue;
            }
            columnWriter.writeValueField(tuple, fieldName, value);
        }
    }
}

