/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.dr;

import java.io.FileNotFoundException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.apache.ignite.client.BasicAuthenticator;
import org.apache.ignite.client.IgniteClient;
import org.apache.ignite.client.SslConfiguration;
import org.apache.ignite.internal.configuration.ConfigurationManager;
import org.apache.ignite.internal.configuration.ConfigurationRegistry;
import org.apache.ignite.internal.configuration.ConfigurationTreeGenerator;
import org.apache.ignite.internal.configuration.presentation.HoconPresentation;
import org.apache.ignite.internal.configuration.storage.LocalFileConfigurationStorage;
import org.apache.ignite.internal.configuration.validation.ConfigurationValidatorImpl;
import org.apache.ignite.internal.lang.IgniteStringFormatter;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.manager.ComponentContext;
import org.apache.ignite.internal.network.configuration.IgniteClientAuthenticatorView;
import org.apache.ignite.internal.network.configuration.SslView;
import org.apache.ignite.internal.util.StringUtils;
import org.apache.ignite.security.AuthenticationType;
import org.gridgain.dr.configuration.DrReceiverConfiguration;
import org.gridgain.dr.configuration.DrReceiverView;
import org.gridgain.internal.dr.DrReceiver;
import org.gridgain.internal.dr.DrUpdateHandlerImpl;
import org.gridgain.internal.dr.mapping.CacheMapping;
import org.gridgain.internal.dr.mapping.TupleColumnWriterFactoryImpl;
import org.gridgain.internal.dr.util.DrReceiverSystemInfoPrinter;

public class DrReceiverRunner {
    private static final IgniteLogger LOG = Loggers.forClass(DrReceiverRunner.class);
    public static final String DEFAULT_CLI_CONFIG_NAME = "dr-receiver-config.conf";
    private final DrReceiverView drConfigView;
    private DrReceiver receiverService;
    private IgniteClient client;

    public static DrReceiverRunner create(String configPath) {
        ConfigurationManager configManager = DrReceiverRunner.createConfigurationManager(configPath);
        DrReceiverConfiguration cfg = DrReceiverRunner.readDrReceiverConfiguration(configManager);
        if (LOG.isInfoEnabled()) {
            String renderedConfig = new HoconPresentation(configManager.configurationRegistry()).represent();
            LOG.info("DR connector configuration: {}", renderedConfig);
        }
        return new DrReceiverRunner(cfg);
    }

    private static DrReceiverConfiguration readDrReceiverConfiguration(ConfigurationManager configurationManager) {
        DrReceiverConfiguration receiverConf;
        try {
            configurationManager.startAsync(new ComponentContext()).get();
            ConfigurationRegistry registry = configurationManager.configurationRegistry();
            receiverConf = registry.getConfiguration(DrReceiverConfiguration.KEY);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        return receiverConf;
    }

    private static ConfigurationManager createConfigurationManager(String hoconConfig) {
        Path configPath = StringUtils.nullOrEmpty(hoconConfig) ? Paths.get(DEFAULT_CLI_CONFIG_NAME, new String[0]) : Paths.get(hoconConfig, new String[0]).toAbsolutePath();
        ConfigurationTreeGenerator generator = new ConfigurationTreeGenerator(List.of(DrReceiverConfiguration.KEY), Set.of(), Set.of());
        ConfigurationValidatorImpl defaultValidator = ConfigurationValidatorImpl.withDefaultValidators(generator, Set.of());
        return new ConfigurationManager(List.of(DrReceiverConfiguration.KEY), new LocalFileConfigurationStorage("gg8-compatible-dcr-receiver", configPath, generator, null), generator, defaultValidator, superRoot -> {}, s -> false);
    }

    private DrReceiverRunner(DrReceiverConfiguration receiverConf) {
        this.drConfigView = (DrReceiverView)receiverConf.value();
    }

    public void start() {
        SslView cliSsl = this.drConfigView.clientConfiguration().ssl();
        SslConfiguration sslConf = SslConfiguration.builder().enabled(cliSsl.enabled()).ciphers(Arrays.asList(cliSsl.ciphers().split(","))).keyStorePath(cliSsl.keyStore().path()).keyStorePassword(cliSsl.keyStore().password()).trustStorePath(cliSsl.trustStore().path()).trustStorePassword(cliSsl.trustStore().password()).build();
        IgniteClientAuthenticatorView authConfig = this.drConfigView.clientConfiguration().authenticator();
        BasicAuthenticator auth = null;
        if (authConfig != null && !StringUtils.nullOrEmpty(authConfig.type())) {
            if (AuthenticationType.BASIC != AuthenticationType.parse(authConfig.type())) {
                throw new IllegalArgumentException(IgniteStringFormatter.format("Unsupported authentication type: {}", authConfig.type()));
            }
            auth = BasicAuthenticator.builder().username(authConfig.identity()).password(authConfig.secret()).build();
        }
        LOG.info("Starting IgniteClient node.", new Object[0]);
        this.client = IgniteClient.builder().addresses(this.drConfigView.clientConfiguration().serverEndpoints()).ssl(sslConf).authenticator(auth).build();
        ZoneId timeZone = ZoneId.of(this.drConfigView.timeZone());
        Duration tombstoneTtl = Duration.ofMillis(this.drConfigView.drReceiverConfiguration().tombstoneTtl());
        DrUpdateHandlerImpl drUpdateHandler = new DrUpdateHandlerImpl(this.client, tombstoneTtl);
        Map<String, CacheMapping> cacheMappingMap = CacheMapping.fromConfig(this.drConfigView.cacheMapping());
        TupleColumnWriterFactoryImpl writerFactory = new TupleColumnWriterFactoryImpl(timeZone, cacheMappingMap);
        this.receiverService = new DrReceiver(this.drConfigView.drReceiverConfiguration(), drUpdateHandler, writerFactory);
        LOG.info("Starting DR receiver hub.", new Object[0]);
        this.receiverService.start();
    }

    public void stop() throws Exception {
        if (this.receiverService != null) {
            LOG.info("Stopping DR receiver hub.", new Object[0]);
            this.receiverService.stop();
        }
        if (this.client != null) {
            LOG.info("Stopping IgniteClient node.", new Object[0]);
            this.client.close();
        }
    }

    public static void main(String[] args) throws FileNotFoundException {
        try {
            DrReceiverSystemInfoPrinter.print(LOG);
            String configPath = DrReceiverRunner.readConfigPath(args);
            if (Files.notExists(Path.of(configPath, new String[0]), new LinkOption[0])) {
                throw new FileNotFoundException(IgniteStringFormatter.format("File not found: {}", configPath));
            }
            DrReceiverRunner runner = DrReceiverRunner.create(configPath);
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                try {
                    runner.stop();
                }
                catch (Exception e) {
                    LOG.error("Unable to stop receiver", (Throwable)e);
                }
            }));
            runner.start();
        }
        catch (Throwable t) {
            LOG.error(t.getMessage(), t);
            throw t;
        }
    }

    private static String readConfigPath(String[] args) {
        String cfgOption = "--config-path";
        if (args.length != 2) {
            throw new IllegalArgumentException(IgniteStringFormatter.format("Unexpected number of command line arguments. Expected 2, but was {}.", args.length));
        }
        if (!cfgOption.equals(args[0])) {
            throw new IllegalStateException(IgniteStringFormatter.format("Unrecognized option: {}", args[0]));
        }
        return args[1];
    }
}

