/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util;

import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.lang.IgniteBiTuple;
import org.apache.ignite.internal.lang.IgniteInternalException;
import org.apache.ignite.internal.util.PendingComparableValuesTracker;
import org.apache.ignite.internal.util.TrackerClosedException;
import org.apache.ignite.lang.ErrorGroups;
import org.jetbrains.annotations.Nullable;

public class SafeTimeValuesTracker
extends PendingComparableValuesTracker<HybridTimestamp, Void> {
    private long commandIndex;
    private long commandTerm;
    private String commandClassName;

    public SafeTimeValuesTracker(HybridTimestamp initialValue) {
        super(initialValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Issues handling annotations - annotations may be inaccurate
     */
    public void update(HybridTimestamp safeTs, long commandIndex, long commandTerm, Object command) {
        if (!this.enterBusy()) {
            throw new TrackerClosedException();
        }
        try {
             @Nullable Map.Entry current = this.current;
            IgniteBiTuple<HybridTimestamp, @Nullable Object> newEntry = new IgniteBiTuple<HybridTimestamp, Object>(safeTs, null);
            if (this.comparator.compare(newEntry, current) < 0) {
                throw new IgniteInternalException(ErrorGroups.Common.INTERNAL_ERR, "Reordering detected: [old=" + current.getKey() + ", new=" + newEntry.get1() + ", oldIndex=" + this.commandIndex + ", oldTerm=" + this.commandTerm + ", oldCommandClassName=" + this.commandClassName + "]");
            }
            CURRENT.set(this, newEntry);
            this.commandIndex = commandIndex;
            this.commandTerm = commandTerm;
            this.commandClassName = command.getClass().getName();
            this.completeWaitersOnUpdate(safeTs, null);
        }
        finally {
            this.leaveBusy();
        }
    }
}

