/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.ignite.internal.lang.IgniteInternalException;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.network.NodeFinder;
import org.apache.ignite.internal.util.ArrayUtils;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.network.NetworkAddress;

public class StaticNodeFinder
implements NodeFinder {
    private static final IgniteLogger LOG = Loggers.forClass(StaticNodeFinder.class);
    private static final long RETRY_WAIT_BASE_MILLIS = 500L;
    private static final int MAX_TRIES = 3;
    private final List<NetworkAddress> addresses;

    public StaticNodeFinder(List<NetworkAddress> addresses) {
        this.addresses = addresses;
    }

    @Override
    public Collection<NetworkAddress> findNodes() {
        if (this.addresses.isEmpty()) {
            return Set.of();
        }
        Collection networkAddresses = this.addresses.parallelStream().flatMap(originalAddress -> Arrays.stream(StaticNodeFinder.resolveAll(originalAddress.host())).map(ip -> new NetworkAddress((String)ip, originalAddress.port()))).collect(Collectors.toSet());
        if (networkAddresses.isEmpty()) {
            throw new IgniteInternalException(ErrorGroups.Network.ADDRESS_UNRESOLVED_ERR, "No network addresses resolved through any provided names");
        }
        return networkAddresses;
    }

    @Override
    public void start() {
    }

    private static String[] resolveAll(String host) {
        InetAddress[] inetAddresses = null;
        int tryCount = 0;
        boolean resolved = false;
        do {
            ++tryCount;
            try {
                inetAddresses = InetAddress.getAllByName(host);
                resolved = true;
            }
            catch (UnknownHostException e) {
                if (tryCount == 3) {
                    LOG.warn("Cannot resolve {}", host);
                    return ArrayUtils.STRING_EMPTY_ARRAY;
                }
                try {
                    Thread.sleep((long)tryCount * 500L);
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                    return ArrayUtils.STRING_EMPTY_ARRAY;
                }
            }
        } while (!resolved);
        assert (inetAddresses != null);
        String[] addresses = new String[inetAddresses.length];
        for (int i = 0; i < inetAddresses.length; ++i) {
            InetAddress inetAddress = inetAddresses[i];
            if (inetAddress.isLoopbackAddress()) {
                return new String[]{inetAddress.getHostAddress()};
            }
            addresses[i] = inetAddress.getHostAddress();
        }
        return addresses;
    }
}

