/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network;

import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.ignite.internal.network.ClusterIdSupplier;
import org.apache.ignite.internal.network.InternalClusterNode;
import org.apache.ignite.internal.network.TopologyService;
import org.apache.ignite.network.ClusterNode;
import org.apache.ignite.network.IgniteCluster;
import org.jetbrains.annotations.Nullable;

public class IgniteClusterImpl
implements IgniteCluster {
    public final TopologyService topologyService;
    public final ClusterIdSupplier clusterIdSupplier;

    public IgniteClusterImpl(TopologyService topologyService, ClusterIdSupplier clusterIdSupplier) {
        this.topologyService = topologyService;
        this.clusterIdSupplier = clusterIdSupplier;
    }

    @Override
    public UUID id() {
        @Nullable UUID ret = this.clusterIdSupplier.clusterId();
        assert (ret != null) : "clusterId not available";
        return ret;
    }

    @Override
    public Collection<ClusterNode> nodes() {
        return IgniteClusterImpl.toPublicClusterNodes(this.topologyService.logicalTopologyMembers());
    }

    private static List<ClusterNode> toPublicClusterNodes(Collection<InternalClusterNode> nodes) {
        return nodes.stream().map(InternalClusterNode::toPublicNode).collect(Collectors.toList());
    }

    @Override
    public CompletableFuture<Collection<ClusterNode>> nodesAsync() {
        return CompletableFuture.completedFuture(IgniteClusterImpl.toPublicClusterNodes(this.topologyService.allMembers()));
    }

    @Override
    @Nullable
    public ClusterNode localNode() {
        return this.topologyService.localMember().toPublicNode();
    }
}

