/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.metrics;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.ignite.configuration.notifications.ConfigurationNamedListListener;
import org.apache.ignite.configuration.notifications.ConfigurationNotificationEvent;
import org.apache.ignite.internal.lang.IgniteInternalException;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.manager.ComponentContext;
import org.apache.ignite.internal.metrics.MetricManager;
import org.apache.ignite.internal.metrics.MetricRegistry;
import org.apache.ignite.internal.metrics.MetricSet;
import org.apache.ignite.internal.metrics.MetricSnapshot;
import org.apache.ignite.internal.metrics.MetricSource;
import org.apache.ignite.internal.metrics.configuration.MetricConfiguration;
import org.apache.ignite.internal.metrics.configuration.MetricView;
import org.apache.ignite.internal.metrics.exporters.MetricExporter;
import org.apache.ignite.internal.metrics.exporters.configuration.ExporterView;
import org.apache.ignite.internal.metrics.exporters.configuration.LogPushExporterConfigurationSchema;
import org.apache.ignite.internal.metrics.exporters.configuration.LogPushExporterView;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.internal.util.IgniteBusyLock;
import org.apache.ignite.internal.util.IgniteSpinBusyLock;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.lang.ErrorGroups;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public class MetricManagerImpl
implements MetricManager {
    private final IgniteLogger log;
    private final MetricRegistry registry;
    private final Map<String, MetricExporter> enabledMetricExporters = new ConcurrentHashMap<String, MetricExporter>();
    private final IgniteSpinBusyLock busyLock = new IgniteSpinBusyLock();
    private final AtomicBoolean stopGuard = new AtomicBoolean();
    private volatile Map<String, MetricExporter> availableExporters;
    private volatile MetricConfiguration metricConfiguration;
    private volatile Supplier<UUID> clusterIdSupplier;
    @Nullable
    private volatile String nodeName;

    public MetricManagerImpl() {
        this(Loggers.forClass(MetricManagerImpl.class), null);
    }

    public MetricManagerImpl(IgniteLogger log, @Nullable String nodeName) {
        this.registry = new MetricRegistry();
        this.log = log;
        this.nodeName = nodeName;
    }

    @Override
    public void configure(MetricConfiguration metricConfiguration, Supplier<UUID> clusterIdSupplier, String nodeName) {
        assert (this.metricConfiguration == null) : "Metric manager must be configured only once, on the start of the node";
        assert (this.clusterIdSupplier == null) : "Metric manager must be configured only once, on the start of the node";
        assert (this.nodeName == null) : "Metric manager must be configured only once, on the start of the node";
        this.metricConfiguration = metricConfiguration;
        this.clusterIdSupplier = clusterIdSupplier;
        this.nodeName = nodeName;
    }

    @Override
    public CompletableFuture<Void> startAsync(ComponentContext componentContext) {
        return IgniteUtils.inBusyLockAsync(this.busyLock, () -> {
            this.start(MetricManagerImpl.loadExporters());
            return CompletableFutures.nullCompletedFuture();
        });
    }

    @Override
    @VisibleForTesting
    public void start(Map<String, MetricExporter> availableExporters) {
        this.availableExporters = Map.copyOf(availableExporters);
        MetricView conf = (MetricView)this.metricConfiguration.value();
        List exporters = conf.exporters().stream().collect(Collectors.toList());
        exporters.addAll(MetricManagerImpl.defaultExporters(exporters));
        for (ExporterView exporter : exporters) {
            this.checkAndStartExporter(exporter.exporterName(), exporter);
        }
        this.metricConfiguration.exporters().listenElements(new ExporterConfigurationListener());
    }

    @Override
    public void start(Iterable<MetricExporter> exporters) {
        IgniteUtils.inBusyLock((IgniteBusyLock)this.busyLock, () -> {
            HashMap<String, MetricExporter> availableExporters = new HashMap<String, MetricExporter>();
            for (MetricExporter exporter : exporters) {
                exporter.start(this.registry, null, this.clusterIdSupplier, this.nodeName);
                availableExporters.put(exporter.name(), exporter);
                this.enabledMetricExporters.put(exporter.name(), exporter);
            }
            this.availableExporters = Map.copyOf(availableExporters);
        });
    }

    @Override
    public void beforeNodeStop() {
        if (!this.stopGuard.compareAndSet(false, true)) {
            return;
        }
        this.busyLock.block();
        try {
            IgniteUtils.closeAllManually(Stream.concat(this.enabledMetricExporters.values().stream().map(metricExporter -> metricExporter::stop), Stream.of(this.registry)));
        }
        catch (Exception e) {
            throw new IgniteInternalException(ErrorGroups.Common.RESOURCE_CLOSING_ERR, (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<Void> stopAsync(ComponentContext componentContext) {
        this.enabledMetricExporters.clear();
        return CompletableFutures.nullCompletedFuture();
    }

    @Override
    public void registerSource(MetricSource src) {
        IgniteUtils.inBusyLock((IgniteBusyLock)this.busyLock, () -> this.registry.registerSource(src));
    }

    @Override
    public void unregisterSource(MetricSource src) {
        IgniteUtils.inBusyLockSafe(this.busyLock, () -> {
            this.disable(src);
            this.registry.unregisterSource(src);
        });
    }

    @Override
    public void unregisterSource(String srcName) {
        IgniteUtils.inBusyLockSafe(this.busyLock, () -> {
            this.disable(srcName);
            this.registry.unregisterSource(srcName);
        });
    }

    @Override
    public MetricSet enable(MetricSource src) {
        return IgniteUtils.inBusyLock((IgniteBusyLock)this.busyLock, () -> {
            MetricSet enabled = this.registry.enable(src);
            if (enabled != null) {
                this.enabledMetricExporters.values().forEach(e -> e.addMetricSet(enabled));
            }
            return enabled;
        });
    }

    @Override
    public MetricSet enable(String srcName) {
        return IgniteUtils.inBusyLock((IgniteBusyLock)this.busyLock, () -> {
            MetricSet enabled = this.registry.enable(srcName);
            if (enabled != null) {
                this.enabledMetricExporters.values().forEach(e -> e.addMetricSet(enabled));
            }
            return enabled;
        });
    }

    @Override
    public void disable(MetricSource src) {
        IgniteUtils.inBusyLockSafe(this.busyLock, () -> {
            MetricSet metricSet = this.registry.snapshot().metrics().get(src.name());
            this.registry.disable(src);
            this.enabledMetricExporters.values().forEach(e -> e.removeMetricSet(metricSet));
        });
    }

    @Override
    public void disable(String srcName) {
        IgniteUtils.inBusyLockSafe(this.busyLock, () -> {
            MetricSet metricSet = this.registry.snapshot().metrics().get(srcName);
            this.registry.disable(srcName);
            this.enabledMetricExporters.values().forEach(e -> e.removeMetricSet(metricSet));
        });
    }

    @Override
    public MetricSnapshot metricSnapshot() {
        return IgniteUtils.inBusyLock((IgniteBusyLock)this.busyLock, this.registry::snapshot);
    }

    @Override
    public Collection<MetricSource> metricSources() {
        return IgniteUtils.inBusyLock((IgniteBusyLock)this.busyLock, this.registry::metricSources);
    }

    @Override
    public Collection<MetricExporter> enabledExporters() {
        return IgniteUtils.inBusyLock((IgniteBusyLock)this.busyLock, this.enabledMetricExporters::values);
    }

    private static List<ExporterView> defaultExporters(List<? extends ExporterView> configuredExporters) {
        if (configuredExporters.stream().map(ExporterView::exporterName).anyMatch(n -> n.equals("logPush"))) {
            return Collections.emptyList();
        }
        LogPushExporterView logExporterView = new LogPushExporterView(){
            private final LogPushExporterConfigurationSchema schema = new LogPushExporterConfigurationSchema();

            @Override
            public long periodMillis() {
                return this.schema.periodMillis;
            }

            @Override
            public boolean oneLinePerMetricSource() {
                return this.schema.oneLinePerMetricSource;
            }

            @Override
            public String[] enabledMetrics() {
                return this.schema.enabledMetrics;
            }

            @Override
            public String exporterName() {
                return "logPush";
            }

            @Override
            public String name() {
                return "log";
            }
        };
        return List.of(logExporterView);
    }

    private void checkAndStartExporter(String exporterName, ExporterView exporterConfiguration) {
        MetricExporter exporter = this.availableExporters.get(exporterName);
        if (exporter != null) {
            this.enabledMetricExporters.computeIfAbsent(exporter.name(), name -> {
                try {
                    exporter.start(this.registry, exporterConfiguration, this.clusterIdSupplier, this.nodeName);
                    return exporter;
                }
                catch (Exception e) {
                    this.log.warn("Unable to start metrics exporter name=[" + exporterName + "].", (Throwable)e);
                    return null;
                }
            });
        } else {
            this.log.warn("Received configuration for unknown metric exporter with the name '" + exporterName + "'", new Object[0]);
        }
    }

    private static Map<String, MetricExporter> loadExporters() {
        ClassLoader clsLdr = Thread.currentThread().getContextClassLoader();
        return ServiceLoader.load(MetricExporter.class, clsLdr).stream().map(ServiceLoader.Provider::get).collect(Collectors.toUnmodifiableMap(MetricExporter::name, Function.identity()));
    }

    private class ExporterConfigurationListener
    implements ConfigurationNamedListListener<ExporterView> {
        private ExporterConfigurationListener() {
        }

        @Override
        public CompletableFuture<?> onCreate(ConfigurationNotificationEvent<ExporterView> ctx) {
            IgniteUtils.inBusyLockSafe(MetricManagerImpl.this.busyLock, () -> {
                ExporterView newValue = (ExporterView)ctx.newValue();
                assert (newValue != null);
                MetricManagerImpl.this.checkAndStartExporter(newValue.exporterName(), newValue);
            });
            return CompletableFutures.nullCompletedFuture();
        }

        @Override
        public CompletableFuture<?> onDelete(ConfigurationNotificationEvent<ExporterView> ctx) {
            IgniteUtils.inBusyLockSafe(MetricManagerImpl.this.busyLock, () -> {
                ExporterView oldValue = (ExporterView)ctx.oldValue();
                assert (oldValue != null);
                MetricExporter removed = MetricManagerImpl.this.enabledMetricExporters.remove(oldValue.exporterName());
                if (removed != null) {
                    removed.stop();
                }
            });
            return CompletableFutures.nullCompletedFuture();
        }

        @Override
        public CompletableFuture<?> onUpdate(ConfigurationNotificationEvent<ExporterView> ctx) {
            IgniteUtils.inBusyLockSafe(MetricManagerImpl.this.busyLock, () -> {
                ExporterView newValue = (ExporterView)ctx.newValue();
                assert (newValue != null);
                MetricExporter exporter = MetricManagerImpl.this.enabledMetricExporters.get(newValue.exporterName());
                if (exporter != null) {
                    exporter.reconfigure(newValue);
                }
            });
            return CompletableFutures.nullCompletedFuture();
        }
    }
}

