/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.configuration.validation;

import java.util.regex.Pattern;
import org.apache.ignite.configuration.validation.StorageStringSize;
import org.apache.ignite.configuration.validation.ValidationContext;
import org.apache.ignite.configuration.validation.ValidationIssue;
import org.apache.ignite.configuration.validation.Validator;

public class StorageStringSizeValidator
implements Validator<StorageStringSize, String> {
    private static final Pattern ALLOWED_REGEX = Pattern.compile("^(\\d+[kKmMgG]{1}|((100)|(\\d{1,2}))%)$");

    @Override
    public void validate(StorageStringSize annotation, ValidationContext<String> ctx) {
        String newLimit = ctx.getNewValue();
        if (newLimit.isEmpty()) {
            return;
        }
        if (!ALLOWED_REGEX.matcher(newLimit).matches()) {
            ctx.addIssue(new ValidationIssue(ctx.currentKey(), String.format("Incorrect format: '%s'. It is expected to be a natural number followed by one of the symbols: 'k', 'm', 'g', '%%'. ", newLimit)));
        }
    }
}

