/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.configuration.presentation;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigRenderOptions;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.configuration.ConfigurationChangeException;
import org.apache.ignite.configuration.validation.ConfigurationValidationException;
import org.apache.ignite.internal.configuration.ConfigurationRegistry;
import org.apache.ignite.internal.configuration.exception.ConfigurationApplyException;
import org.apache.ignite.internal.configuration.exception.ConfigurationParseException;
import org.apache.ignite.internal.configuration.exception.ConfigurationValidationIgniteException;
import org.apache.ignite.internal.configuration.hocon.HoconConverter;
import org.apache.ignite.internal.configuration.presentation.ConfigurationPresentation;
import org.apache.ignite.internal.configuration.util.ConfigurationUtil;
import org.apache.ignite.internal.util.ExceptionUtils;
import org.jetbrains.annotations.Nullable;

public class HoconPresentation
implements ConfigurationPresentation<String> {
    private final ConfigurationRegistry registry;

    public HoconPresentation(ConfigurationRegistry registry) {
        this.registry = registry;
    }

    @Override
    public String represent() {
        return this.representByPath(null);
    }

    @Override
    public String representByPath(@Nullable String path) {
        return HoconConverter.represent(this.registry.superRoot(), path == null ? List.of() : ConfigurationUtil.split(path)).render(ConfigRenderOptions.concise());
    }

    @Override
    public CompletableFuture<Void> update(String cfgUpdate) {
        Config config;
        if (cfgUpdate.isBlank()) {
            return CompletableFuture.failedFuture(new ConfigurationParseException("Empty configuration."));
        }
        try {
            config = ConfigFactory.parseString(cfgUpdate);
        }
        catch (ConfigException.Parse e2) {
            return CompletableFuture.failedFuture(new ConfigurationParseException("Failed to parse configuration.", (Throwable)e2));
        }
        return this.registry.change(HoconConverter.hoconSource(config.root(), this.registry.keyIgnorer())).exceptionally(e -> {
            if ((e = ExceptionUtils.unwrapCause(e)) instanceof ConfigurationChangeException) {
                e = e.getCause();
            }
            if (e instanceof ConfigurationValidationException) {
                throw new ConfigurationValidationIgniteException((ConfigurationValidationException)e);
            }
            throw new ConfigurationApplyException("Failed to apply configuration.", (Throwable)e);
        });
    }
}

