/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.compute;

import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.compute.JobExecution;
import org.apache.ignite.compute.JobState;
import org.apache.ignite.compute.JobStatus;
import org.apache.ignite.compute.TaskState;
import org.apache.ignite.compute.TaskStatus;
import org.apache.ignite.internal.client.PayloadInputChannel;
import org.apache.ignite.internal.client.ReliableChannel;
import org.apache.ignite.internal.client.compute.SubmitResult;
import org.apache.ignite.internal.client.proto.ClientComputeJobUnpacker;
import org.apache.ignite.internal.client.proto.ClientMessageUnpacker;
import org.apache.ignite.internal.compute.JobStateImpl;
import org.apache.ignite.internal.compute.TaskStateImpl;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.lang.IgniteException;
import org.apache.ignite.marshalling.Marshaller;
import org.apache.ignite.network.ClusterNode;
import org.jetbrains.annotations.Nullable;

class ClientJobExecution<R>
implements JobExecution<R> {
    private static final JobStatus[] JOB_STATUSES = JobStatus.values();
    private static final TaskStatus[] TASK_STATUSES = TaskStatus.values();
    private final ReliableChannel ch;
    private final UUID jobId;
    private final ClusterNode node;
    private final CompletableFuture<R> resultAsync;
    private final CompletableFuture<@Nullable JobState> stateFuture = new CompletableFuture();

    ClientJobExecution(ReliableChannel ch, SubmitResult submitResult, @Nullable Marshaller<R, byte[]> marshaller, @Nullable Class<R> resultClass) {
        this.ch = ch;
        this.jobId = submitResult.jobId();
        this.node = submitResult.clusterNode();
        this.resultAsync = submitResult.notificationFuture().thenApply(r -> {
            try (PayloadInputChannel payloadInputChannel = r;){
                Object result = ClientComputeJobUnpacker.unpackJobResult(r.in(), marshaller, resultClass);
                this.stateFuture.complete(ClientJobExecution.unpackJobState(r));
                Object object = result;
                return object;
            }
        });
    }

    @Override
    public CompletableFuture<R> resultAsync() {
        return this.resultAsync;
    }

    @Override
    public CompletableFuture<@Nullable JobState> stateAsync() {
        if (this.stateFuture.isDone()) {
            return this.stateFuture;
        }
        return ClientJobExecution.getJobState(this.ch, this.jobId);
    }

    public CompletableFuture<@Nullable Boolean> cancelAsync() {
        if (this.stateFuture.isDone()) {
            return CompletableFutures.falseCompletedFuture();
        }
        return ClientJobExecution.cancelJob(this.ch, this.jobId);
    }

    @Override
    public CompletableFuture<@Nullable Boolean> changePriorityAsync(int newPriority) {
        if (this.stateFuture.isDone()) {
            return CompletableFutures.falseCompletedFuture();
        }
        return ClientJobExecution.changePriority(this.ch, this.jobId, newPriority);
    }

    @Override
    public ClusterNode node() {
        return this.node;
    }

    static CompletableFuture<@Nullable JobState> getJobState(ReliableChannel ch, UUID jobId) {
        return ch.serviceAsync(59, w -> w.out().packUuid(jobId), ClientJobExecution::unpackJobState, (String)null, null, false);
    }

    static CompletableFuture<@Nullable TaskState> getTaskState(ReliableChannel ch, UUID taskId) {
        return ch.serviceAsync(59, w -> w.out().packUuid(taskId), ClientJobExecution::unpackTaskState, (String)null, null, false);
    }

    static CompletableFuture<@Nullable Boolean> cancelJob(ReliableChannel ch, UUID jobId) {
        return ch.serviceAsync(60, w -> w.out().packUuid(jobId), ClientJobExecution::unpackBooleanResult, (String)null, null, false);
    }

    static CompletableFuture<@Nullable Boolean> changePriority(ReliableChannel ch, UUID jobId, int newPriority) {
        return ch.serviceAsync(61, w -> {
            w.out().packUuid(jobId);
            w.out().packInt(newPriority);
        }, ClientJobExecution::unpackBooleanResult, (String)null, null, false);
    }

    @Nullable
    static JobState unpackJobState(PayloadInputChannel payloadInputChannel) {
        ClientMessageUnpacker unpacker = payloadInputChannel.in();
        if (unpacker.tryUnpackNil()) {
            return null;
        }
        return JobStateImpl.builder().id(unpacker.unpackUuid()).status(ClientJobExecution.unpackJobStatus(unpacker)).createTime(unpacker.unpackInstant()).startTime(unpacker.unpackInstantNullable()).finishTime(unpacker.unpackInstantNullable()).build();
    }

    @Nullable
    static TaskState unpackTaskState(PayloadInputChannel payloadInputChannel) {
        ClientMessageUnpacker unpacker = payloadInputChannel.in();
        if (unpacker.tryUnpackNil()) {
            return null;
        }
        return TaskStateImpl.builder().id(unpacker.unpackUuid()).status(ClientJobExecution.unpackTaskStatus(unpacker)).createTime(unpacker.unpackInstant()).startTime(unpacker.unpackInstantNullable()).finishTime(unpacker.unpackInstantNullable()).build();
    }

    @Nullable
    private static Boolean unpackBooleanResult(PayloadInputChannel payloadInputChannel) {
        ClientMessageUnpacker unpacker = payloadInputChannel.in();
        if (unpacker.tryUnpackNil()) {
            return null;
        }
        return unpacker.unpackBoolean();
    }

    private static JobStatus unpackJobStatus(ClientMessageUnpacker unpacker) {
        int id = unpacker.unpackInt();
        if (id >= 0 && id < JOB_STATUSES.length) {
            return JOB_STATUSES[id];
        }
        throw new IgniteException(ErrorGroups.Client.PROTOCOL_ERR, "Invalid job status id: " + id);
    }

    private static TaskStatus unpackTaskStatus(ClientMessageUnpacker unpacker) {
        int id = unpacker.unpackInt();
        if (id >= 0 && id < TASK_STATUSES.length) {
            return TASK_STATUSES[id];
        }
        throw new IgniteException(ErrorGroups.Client.PROTOCOL_ERR, "Invalid task status id: " + id);
    }
}

