/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.lang;

import org.apache.ignite.error.code.annotations.ErrorCodeGroup;
import org.apache.ignite.lang.ErrorGroup;
import org.apache.ignite.lang.ErrorGroups;

public class GridgainErrorGroups {
    private static final int GRIDGAIN_ERROR_GROUP_OFFSET = 1000;
    public static final short MAX_TWO_BYTES_MSG_VALUE = 16382;

    public static synchronized void initialize() {
        for (Class<?> cls : GridgainErrorGroups.class.getDeclaredClasses()) {
            try {
                cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to initialize error groups", e);
            }
        }
    }

    private static ErrorGroup registerGgErrorGroup(String groupName, int code) {
        assert (code > 0 && code < 15382);
        return ErrorGroups.registerGroup("GG", groupName, (short)(1000 + code));
    }

    @ErrorCodeGroup
    public static class RollingUpgrade {
        static final ErrorGroup UPGRADE_ERR_GROUP = GridgainErrorGroups.registerGgErrorGroup("UPGRADE", 17);
        public static final int COMMIT_UPGRADE_ERR = UPGRADE_ERR_GROUP.registerErrorCode((short)1);
        public static final int VERSION_FORMAT_ERR = UPGRADE_ERR_GROUP.registerErrorCode((short)2);
        public static final int CANCEL_UPGRADE_ERR = UPGRADE_ERR_GROUP.registerErrorCode((short)3);
    }

    @ErrorCodeGroup
    public static class Cdc {
        static final ErrorGroup CDC_ERR_GROUP = GridgainErrorGroups.registerGgErrorGroup("CDC", 16);
        public static final int COMMON_CDC_ERR = CDC_ERR_GROUP.registerErrorCode((short)1);
        public static final int CDC_INTERNAL_ERR = CDC_ERR_GROUP.registerErrorCode((short)2);
        public static final int CDC_VALIDATION_ERR = CDC_ERR_GROUP.registerErrorCode((short)3);
        public static final int CDC_SINK_INIT_ERR = CDC_ERR_GROUP.registerErrorCode((short)4);
        public static final int CDC_SINK_ALREADY_EXISTS_ERR = CDC_ERR_GROUP.registerErrorCode((short)7);
        public static final int CDC_SINK_NOT_FOUND_ERR = CDC_ERR_GROUP.registerErrorCode((short)10);
        public static final int CDC_REPLICATION_START_ERR = CDC_ERR_GROUP.registerErrorCode((short)5);
        public static final int CDC_REPLICATION_STOP_ERR = CDC_ERR_GROUP.registerErrorCode((short)6);
        public static final int CDC_REPLICATION_ALREADY_EXISTS_ERR = CDC_ERR_GROUP.registerErrorCode((short)12);
        public static final int CDC_REPLICATION_NOT_FOUND_ERR = CDC_ERR_GROUP.registerErrorCode((short)11);
        public static final int CDC_SOURCE_ALREADY_EXISTS_ERR = CDC_ERR_GROUP.registerErrorCode((short)8);
        public static final int CDC_SOURCE_NOT_FOUND_ERR = CDC_ERR_GROUP.registerErrorCode((short)9);
        public static final int CDC_DISABLED_ERR = CDC_ERR_GROUP.registerErrorCode((short)13);
    }

    @ErrorCodeGroup
    public static class ContinuousQuery {
        static final ErrorGroup CONTINUOUS_QUERY_ERR_GROUP = GridgainErrorGroups.registerGgErrorGroup("CONTINUOUSQUERY", 15);
        public static final int WATERMARK_TOO_OLD_ERR = CONTINUOUS_QUERY_ERR_GROUP.registerErrorCode((short)1);
        public static final int WATERMARK_TOO_OLD_TABLE_DOES_NOT_EXIST_ERR = CONTINUOUS_QUERY_ERR_GROUP.registerErrorCode((short)2);
    }

    @ErrorCodeGroup
    public static class SecondaryStorage {
        static final ErrorGroup SECONDARY_STORAGE_ERR_GROUP = GridgainErrorGroups.registerGgErrorGroup("SECONDARY_STORAGE", 14);
        public static final int SECONDARY_STORAGE_REPLICATION_FAILURE_ERR = SECONDARY_STORAGE_ERR_GROUP.registerErrorCode((short)1);
        public static final int SECONDARY_STORAGE_REPLICATION_MANAGER_STARTUP_ERR = SECONDARY_STORAGE_ERR_GROUP.registerErrorCode((short)2);
        public static final int SECONDARY_STORAGE_BRIDGE_STARTUP_ERR = SECONDARY_STORAGE_ERR_GROUP.registerErrorCode((short)3);
        public static final int SECONDARY_STORAGE_NOT_INITIALIZED_ERR = SECONDARY_STORAGE_ERR_GROUP.registerErrorCode((short)4);
        public static final int SECONDARY_STORAGE_WRITE_ERR = SECONDARY_STORAGE_ERR_GROUP.registerErrorCode((short)5);
        public static final int SECONDARY_STORAGE_READ_ERR = SECONDARY_STORAGE_ERR_GROUP.registerErrorCode((short)6);
    }

    @ErrorCodeGroup
    public static class Cache {
        static final ErrorGroup CACHE_ERR_GROUP = GridgainErrorGroups.registerGgErrorGroup("CACHE", 13);
        public static final int TX_INCOMPATIBLE_OPERATION_ERR = CACHE_ERR_GROUP.registerErrorCode((short)1);
    }

    @ErrorCodeGroup
    public static class PointInTimeRecovery {
        static final ErrorGroup PITR_ERR_GROUP = GridgainErrorGroups.registerGgErrorGroup("PITR", 12);
        public static final int PITR_ERR = PITR_ERR_GROUP.registerErrorCode((short)1);
        public static final int PITR_CANCELED_ERR = PITR_ERR_GROUP.registerErrorCode((short)2);
    }

    @ErrorCodeGroup
    public static class MemoryQuota {
        static final ErrorGroup MEMORY_QUOTA = GridgainErrorGroups.registerGgErrorGroup("MEMQUOTA", 11);
        public static final int SPILLING_ERR = MEMORY_QUOTA.registerErrorCode((short)1);
        public static final int DISK_QUOTA_EXCEEDED_ERR = MEMORY_QUOTA.registerErrorCode((short)2);
        public static final int STATEMENT_MEMORY_QUOTA_EXCEEDED_ERR = MEMORY_QUOTA.registerErrorCode((short)3);
        public static final int SQL_OUT_OF_MEMORY_ERR = MEMORY_QUOTA.registerErrorCode((short)4);
    }

    @ErrorCodeGroup
    public static class CacheStore {
        static final ErrorGroup CACHE_STORE_ERR_GROUP = GridgainErrorGroups.registerGgErrorGroup("CACHESTORE", 10);
        public static final int CACHE_STORE_CONFIG_ERR = CACHE_STORE_ERR_GROUP.registerErrorCode((short)1);
        public static final int CACHE_STORE_ACCESS_ERR = CACHE_STORE_ERR_GROUP.registerErrorCode((short)2);
    }

    @ErrorCodeGroup
    public static class License {
        static final ErrorGroup LICENSE_ERR_GROUP = GridgainErrorGroups.registerGgErrorGroup("LICENSE", 9);
        public static final int COMMON_LICENSE_ERR = LICENSE_ERR_GROUP.registerErrorCode((short)1);
        public static final int MISSING_LICENSE = LICENSE_ERR_GROUP.registerErrorCode((short)2);
        public static final int INVALID_SIGNATURE = LICENSE_ERR_GROUP.registerErrorCode((short)3);
        public static final int MISSING_REQUIRED_FEATURES = LICENSE_ERR_GROUP.registerErrorCode((short)4);
        public static final int INVALID_BLOCKED_LICENSES_LIST = LICENSE_ERR_GROUP.registerErrorCode((short)5);
    }

    @ErrorCodeGroup
    public static class Encryption {
        static final ErrorGroup ENCRYPTION_ERR_GROUP = GridgainErrorGroups.registerGgErrorGroup("ENCRYPTION", 8);
        public static final int KEY_PROVIDER_NOT_FOUND_ERR = ENCRYPTION_ERR_GROUP.registerErrorCode((short)1);
        public static final int INVALID_KEY_PROVIDER_CONFIGURATION_ERR = ENCRYPTION_ERR_GROUP.registerErrorCode((short)2);
        public static final int CANNOT_INIT_KEY_PROVIDER_ERR = ENCRYPTION_ERR_GROUP.registerErrorCode((short)3);
        public static final int DATA_ENCRYPTION_KEY_NOT_FOUND_ERR = ENCRYPTION_ERR_GROUP.registerErrorCode((short)4);
        public static final int AWS_KMS_COMMON_ERR = ENCRYPTION_ERR_GROUP.registerErrorCode((short)5);
        public static final int AWS_KMS_KEY_NOT_FOUND_ERR = ENCRYPTION_ERR_GROUP.registerErrorCode((short)6);
        public static final int AWS_KMS_KEY_DISABLED_ERR = ENCRYPTION_ERR_GROUP.registerErrorCode((short)7);
    }

    @ErrorCodeGroup
    public static class DataCenterReplication {
        static final ErrorGroup DCR_ERR_GROUP = GridgainErrorGroups.registerGgErrorGroup("DCR", 7);
        public static final int DCR_ERR = DCR_ERR_GROUP.registerErrorCode((short)1);
        public static final int REPLICATION_CREATE_ERR = DCR_ERR_GROUP.registerErrorCode((short)2);
        public static final int REPLICATION_STARTUP_ERR = DCR_ERR_GROUP.registerErrorCode((short)3);
        public static final int RUNNING_REPLICATION_REMOVE_ERR = DCR_ERR_GROUP.registerErrorCode((short)4);
        public static final int INCOMPATIBLE_SCHEMAS_ERR = DCR_ERR_GROUP.registerErrorCode((short)5);
        public static final int REPLICATION_STOP_ERR = DCR_ERR_GROUP.registerErrorCode((short)6);
        public static final int SOURCE_TABLE_NOT_EXIST_ERR = DCR_ERR_GROUP.registerErrorCode((short)7);
        public static final int REPLICATION_STARTUP_SAME_TABLE_ERR = DCR_ERR_GROUP.registerErrorCode((short)8);
        public static final int REPLICATION_NOT_FOUND_ERR = DCR_ERR_GROUP.registerErrorCode((short)9);
        public static final int REPLICATION_ALREADY_EXISTS_ERR = DCR_ERR_GROUP.registerErrorCode((short)10);
        public static final int SOURCE_TABLES_NOT_DEFINED_ERR = DCR_ERR_GROUP.registerErrorCode((short)11);
        public static final int REPLICATION_TO_SELF_ERR = DCR_ERR_GROUP.registerErrorCode((short)12);
    }

    @ErrorCodeGroup
    public static class Snapshots {
        static final ErrorGroup SNAPSHOTS_ERR_GROUP = GridgainErrorGroups.registerGgErrorGroup("SNAPSHOTS", 6);
        public static final int SNAPSHOT_ERR = SNAPSHOTS_ERR_GROUP.registerErrorCode((short)1);
        public static final int SNAPSHOT_CANCELED_ERR = SNAPSHOTS_ERR_GROUP.registerErrorCode((short)2);
        public static final int SNAPSHOT_ILLEGAL_ARGUMENT_ERR = SNAPSHOTS_ERR_GROUP.registerErrorCode((short)3);
        public static final int SNAPSHOT_NOT_FOUND_ERR = SNAPSHOTS_ERR_GROUP.registerErrorCode((short)4);
        public static final int SNAPSHOT_META_NOT_FOUND_ERR = SNAPSHOTS_ERR_GROUP.registerErrorCode((short)5);
        public static final int SNAPSHOT_OPERATION_NOT_FOUND_ERR = SNAPSHOTS_ERR_GROUP.registerErrorCode((short)6);
        public static final int SNAPSHOT_TABLES_NOT_FOUND_ERR = SNAPSHOTS_ERR_GROUP.registerErrorCode((short)7);
        public static final int SNAPSHOT_URI_NOT_FOUND_ERR = SNAPSHOTS_ERR_GROUP.registerErrorCode((short)8);
        public static final int SNAPSHOT_ENCRYPTION_PROVIDER_NOT_FOUND_ERR = SNAPSHOTS_ERR_GROUP.registerErrorCode((short)9);
        public static final int SNAPSHOT_REPLICA_TIMEOUT_ERR = SNAPSHOTS_ERR_GROUP.registerErrorCode((short)10);
        public static final int SNAPSHOT_STRUCTURES_NOT_FOUND_ERR = SNAPSHOTS_ERR_GROUP.registerErrorCode((short)11);
    }

    @ErrorCodeGroup
    public static class Jwt {
        static final ErrorGroup JWT_ERR_GROUP = GridgainErrorGroups.registerGgErrorGroup("JWT", 5);
        public static final int JWT_VALIDATION_ERR = JWT_ERR_GROUP.registerErrorCode((short)1);
        public static final int JWT_SER_DE_ERR = JWT_ERR_GROUP.registerErrorCode((short)2);
    }

    @ErrorCodeGroup
    public static class NodeKeyManagement {
        static final ErrorGroup NODE_KEY_MANAGEMENT_ERR_GROUP = GridgainErrorGroups.registerGgErrorGroup("NODEKEYMGMT", 4);
        public static final int KEY_DECODING_ERR = NODE_KEY_MANAGEMENT_ERR_GROUP.registerErrorCode((short)1);
        public static final int KEY_EXPIRED_ERR = NODE_KEY_MANAGEMENT_ERR_GROUP.registerErrorCode((short)2);
        public static final int KEY_GENERATION_ERR = NODE_KEY_MANAGEMENT_ERR_GROUP.registerErrorCode((short)3);
        public static final int KEY_STORE_ERR = NODE_KEY_MANAGEMENT_ERR_GROUP.registerErrorCode((short)4);
        public static final int KEY_SER_DE_ERR = NODE_KEY_MANAGEMENT_ERR_GROUP.registerErrorCode((short)5);
        public static final int KEY_VALIDATION_ERR = NODE_KEY_MANAGEMENT_ERR_GROUP.registerErrorCode((short)6);
    }

    @ErrorCodeGroup
    public static class Ldap {
        static final ErrorGroup LDAP_ERR_GROUP = GridgainErrorGroups.registerGgErrorGroup("LDAP", 3);
        public static final int COMMON_LDAP_ERR = LDAP_ERR_GROUP.registerErrorCode((short)1);
        public static final int LDAP_CLIENT_INIT_ERR = LDAP_ERR_GROUP.registerErrorCode((short)2);
        public static final int LDAP_SEARCH_REQUEST_ERR = LDAP_ERR_GROUP.registerErrorCode((short)3);
        public static final int LDAP_USER_NOT_FOUND_ERR = LDAP_ERR_GROUP.registerErrorCode((short)4);
    }

    @ErrorCodeGroup
    public static class Security {
        static final ErrorGroup SECURITY_ERR_GROUP = GridgainErrorGroups.registerGgErrorGroup("SECURITY", 2);
        public static final int COMMON_SECURITY_ERR = SECURITY_ERR_GROUP.registerErrorCode((short)1);
        public static final int SECURITY_CONTEXT_NOT_SET_ERR = SECURITY_ERR_GROUP.registerErrorCode((short)2);
        public static final int FAIL_TO_GET_JOB_OWNER_ERR = SECURITY_ERR_GROUP.registerErrorCode((short)3);
    }

    @ErrorCodeGroup
    public static class Rbac {
        static final ErrorGroup RBAC_ERR_GROUP = GridgainErrorGroups.registerGgErrorGroup("RBAC", 1);
        public static final int COMMON_RBAC_ERR = RBAC_ERR_GROUP.registerErrorCode((short)1);
        public static final int USER_NOT_FOUND_ERR = RBAC_ERR_GROUP.registerErrorCode((short)2);
        public static final int USER_VALIDATION_ERR = RBAC_ERR_GROUP.registerErrorCode((short)3);
        public static final int USER_ALREADY_EXISTS_ERR = RBAC_ERR_GROUP.registerErrorCode((short)4);
        public static final int USER_UPDATE_ERR = RBAC_ERR_GROUP.registerErrorCode((short)5);
        public static final int USER_ASSIGNMENT_EXISTS_ERR = RBAC_ERR_GROUP.registerErrorCode((short)6);
        public static final int ROLE_NOT_FOUND_ERR = RBAC_ERR_GROUP.registerErrorCode((short)7);
        public static final int ROLE_ALREADY_EXISTS_ERR = RBAC_ERR_GROUP.registerErrorCode((short)8);
        public static final int ROLE_VALIDATION_ERR = RBAC_ERR_GROUP.registerErrorCode((short)9);
        public static final int ROLE_ASSIGNMENT_NOT_FOUND_ERR = RBAC_ERR_GROUP.registerErrorCode((short)10);
        public static final int ROLE_ASSIGNMENT_EXISTS_ERR = RBAC_ERR_GROUP.registerErrorCode((short)11);
        public static final int ROLE_GRANTED_ERR = RBAC_ERR_GROUP.registerErrorCode((short)12);
        public static final int ILLEGAL_PRIVILEGE_ERR = RBAC_ERR_GROUP.registerErrorCode((short)13);
        public static final int ILLEGAL_PRIVILEGE_SELECTOR_ERR = RBAC_ERR_GROUP.registerErrorCode((short)14);
        public static final int AUTHORIZATION_FAILED_ERR = RBAC_ERR_GROUP.registerErrorCode((short)15);
        public static final int SYSTEM_USER_MODIFICATION_ERR = RBAC_ERR_GROUP.registerErrorCode((short)16);
    }
}

