/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network.serialization.marshal;

import org.apache.ignite.internal.network.serialization.ClassDescriptor;
import org.apache.ignite.internal.network.serialization.SpecialMethodInvocationException;
import org.apache.ignite.internal.network.serialization.marshal.SchemaMismatchHandlers;
import org.apache.ignite.internal.network.serialization.marshal.UnmarshalException;

class ReadResolver {
    private final SchemaMismatchHandlers schemaMismatchHandlers;

    ReadResolver(SchemaMismatchHandlers schemaMismatchHandlers) {
        this.schemaMismatchHandlers = schemaMismatchHandlers;
    }

    Object applyReadResolveIfNeeded(Object object, ClassDescriptor remoteDescriptor) throws UnmarshalException {
        ClassDescriptor localDescriptor = remoteDescriptor.local();
        if (remoteDescriptor.hasReadResolve() && localDescriptor.hasReadResolve()) {
            return this.applyReadResolve(object, localDescriptor);
        }
        if (!remoteDescriptor.hasReadResolve() && localDescriptor.hasReadResolve()) {
            return this.applyReadResolveIfSchemaMismatchHandlerAllows(object, localDescriptor);
        }
        if (remoteDescriptor.hasReadResolve() && !localDescriptor.hasReadResolve()) {
            this.schemaMismatchHandlers.onReadResolveDisappeared(object);
            return object;
        }
        return object;
    }

    private Object applyReadResolve(Object objectToResolve, ClassDescriptor descriptor) throws UnmarshalException {
        try {
            return descriptor.serializationMethods().readResolve(objectToResolve);
        }
        catch (SpecialMethodInvocationException e) {
            throw new UnmarshalException("Cannot apply readResolve()", (Throwable)e);
        }
    }

    private Object applyReadResolveIfSchemaMismatchHandlerAllows(Object object, ClassDescriptor localDescriptor) throws UnmarshalException {
        boolean shouldInvokeReadResolve = this.schemaMismatchHandlers.onReadResolveAppeared(object);
        if (shouldInvokeReadResolve) {
            return this.applyReadResolve(object, localDescriptor);
        }
        return object;
    }
}

