/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network.netty;

import io.netty.channel.Channel;
import java.nio.channels.ClosedChannelException;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.network.NettyBootstrapFactory;
import org.apache.ignite.internal.network.OutNetworkObject;
import org.apache.ignite.internal.network.netty.NettyUtils;
import org.apache.ignite.internal.network.recovery.RecoveryDescriptor;
import org.apache.ignite.internal.tostring.IgniteToStringExclude;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.internal.util.CompletableFutures;
import org.jetbrains.annotations.TestOnly;

public class NettySender {
    private static final IgniteLogger LOG = Loggers.forClass(NettySender.class);
    private final Channel channel;
    private final UUID launchId;
    private final String consistentId;
    private final short channelId;
    @IgniteToStringExclude
    private final RecoveryDescriptor recoveryDescriptor;

    public NettySender(Channel channel, UUID launchId, String consistentId, short channelId, RecoveryDescriptor recoveryDescriptor) {
        this.channel = channel;
        this.launchId = launchId;
        this.consistentId = consistentId;
        this.channelId = channelId;
        this.recoveryDescriptor = recoveryDescriptor;
    }

    @TestOnly
    public CompletableFuture<Void> send(OutNetworkObject obj) {
        return this.send(obj, () -> {});
    }

    public CompletableFuture<Void> send(OutNetworkObject obj, Runnable triggerChannelRecreation) {
        if (!obj.networkMessage().needAck()) {
            return NettyUtils.toCompletableFuture(this.channel.writeAndFlush(obj));
        }
        return NettyUtils.toCompletableFuture(this.channel.eventLoop().submit(() -> this.writeWithRecovery(obj, this.channel, triggerChannelRecreation), (Object)null));
    }

    private void chainRecoverSendAfterChannelClosure(CompletableFuture<Void> writeFuture, OutNetworkObject obj, Channel currentChannel, Runnable triggerChannelRecreation) {
        if (!CompletableFutures.isCompletedSuccessfully(writeFuture)) {
            writeFuture.whenComplete((res, ex) -> {
                if (ex instanceof ClosedChannelException) {
                    try {
                        this.recoverSendAfterChannelClosure(obj, currentChannel, triggerChannelRecreation);
                    }
                    catch (AssertionError | RuntimeException e) {
                        LOG.error("An error while sending a message {}", (Throwable)e, obj.networkMessage());
                    }
                }
            });
        }
    }

    private void recoverSendAfterChannelClosure(OutNetworkObject obj, Channel currentChannel, Runnable triggerChannelRecreation) {
        assert (NettyBootstrapFactory.isInNetworkThread()) : "In a non-netty thread " + Thread.currentThread();
        Channel holderChannel = this.recoveryDescriptor.holderChannel();
        if (holderChannel == null || holderChannel == currentChannel) {
            if (obj.shouldBeSavedForRecovery()) {
                this.recoveryDescriptor.add(obj);
            }
            triggerChannelRecreation.run();
        } else {
            this.writeWithRecovery(obj, holderChannel, triggerChannelRecreation);
        }
    }

    private void writeWithRecovery(OutNetworkObject obj, Channel channel, Runnable triggerChannelRecreation) {
        CompletableFuture<Void> writeFuture = NettyUtils.toCompletableFuture(channel.writeAndFlush(obj));
        this.chainRecoverSendAfterChannelClosure(writeFuture, obj, channel, triggerChannelRecreation);
    }

    public UUID launchId() {
        return this.launchId;
    }

    public String consistentId() {
        return this.consistentId;
    }

    public short channelId() {
        return this.channelId;
    }

    public CompletableFuture<Void> closeAsync() {
        return NettyUtils.toCompletableFuture(this.channel.close());
    }

    public boolean isOpen() {
        return this.channel.isOpen();
    }

    @TestOnly
    public Channel channel() {
        return this.channel;
    }

    @TestOnly
    public RecoveryDescriptor recoveryDescriptor() {
        return this.recoveryDescriptor;
    }

    public String toString() {
        return S.toString(this);
    }
}

