/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network;

import java.util.concurrent.TimeUnit;
import org.apache.ignite.internal.lang.IgniteSystemProperties;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.network.IgniteMessageServiceThread;
import org.apache.ignite.internal.network.InternalClusterNode;
import org.apache.ignite.internal.network.NetworkMessage;
import org.apache.ignite.internal.network.NetworkMessageHandler;
import org.apache.ignite.internal.tostring.IgniteToStringBuilder;
import org.jetbrains.annotations.Nullable;

public class TrackableNetworkMessageHandler
implements NetworkMessageHandler {
    private static final IgniteLogger LOG = Loggers.forClass(TrackableNetworkMessageHandler.class);
    private static final int MESSAGING_PROCESSING_LOG_THRESHOLD_MILLIS = 5;
    private final boolean longHandlingLoggingEnabled = IgniteSystemProperties.getBoolean("IGNITE_LONG_HANDLING_LOGGING_ENABLED", false);
    private final NetworkMessageHandler targetHandler;

    TrackableNetworkMessageHandler(NetworkMessageHandler targetHandler) {
        this.targetHandler = targetHandler;
    }

    @Override
    public void onReceived(NetworkMessage message, InternalClusterNode sender, @Nullable Long correlationId) {
        long startTimeNanos = this.longHandlingLoggingEnabled ? System.nanoTime() : 0L;
        this.targetHandler.onReceived(message, sender, correlationId);
        if (this.longHandlingLoggingEnabled && TrackableNetworkMessageHandler.isNetworkThread()) {
            TrackableNetworkMessageHandler.maybeLogLongProcessing(message, startTimeNanos);
        }
    }

    private static boolean isNetworkThread() {
        return Thread.currentThread() instanceof IgniteMessageServiceThread;
    }

    private static void maybeLogLongProcessing(NetworkMessage message, long startTimeNanos) {
        long durationMillis = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTimeNanos);
        if (durationMillis > 5L) {
            LOG.warn("Message handling has been too long [duration={}ms, message={}]", durationMillis, LOG.isDebugEnabled() && IgniteToStringBuilder.includeSensitive() ? message : message.toStringForLightLogging());
        }
    }
}

