/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.metastorage.dsl;

import org.apache.ignite.internal.metastorage.dsl.Iif;
import org.apache.ignite.internal.metastorage.dsl.IifImpl;
import org.apache.ignite.internal.metastorage.dsl.MetaStorageMessagesTypeInfos;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.network.serialization.MessageWriter;

class IifSerializer
implements MessageSerializer<Iif> {
    public static final IifSerializer INSTANCE = new IifSerializer();

    private IifSerializer() {
    }

    @Override
    public boolean writeMessage(Iif msg, MessageWriter writer) throws MessageMappingException {
        IifImpl message = (IifImpl)msg;
        writer.setMessageTypeInfo(MetaStorageMessagesTypeInfos.iif());
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(message.groupType(), message.messageType(), (byte)3)) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                boolean written = writer.writeMessage("andThen", message.andThen());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                boolean written = writer.writeMessage("condition", message.condition());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 2: {
                boolean written = writer.writeMessage("orElse", message.orElse());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }
}

