/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.continuousquery;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Flow;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiFunction;
import org.apache.ignite.internal.continuousquery.ContinuousQueryEventWatermark;
import org.apache.ignite.internal.continuousquery.ContinuousQueryMetricSink;
import org.apache.ignite.internal.continuousquery.ContinuousQueryRequest;
import org.apache.ignite.internal.continuousquery.ContinuousQueryRequestSender;
import org.apache.ignite.internal.continuousquery.ContinuousQueryScanResultStatus;
import org.apache.ignite.internal.continuousquery.ContinuousQueryScanResultWithSchema;
import org.apache.ignite.internal.continuousquery.ContinuousQueryUtils;
import org.apache.ignite.internal.continuousquery.RowUpdateInfo;
import org.apache.ignite.internal.continuousquery.TableRowEventBatchImpl;
import org.apache.ignite.internal.continuousquery.TableRowEventImpl;
import org.apache.ignite.internal.continuousquery.Versionable;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.lang.IgniteExceptionMapperUtil;
import org.apache.ignite.internal.lang.IgniteStringFormatter;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.table.partition.HashPartition;
import org.apache.ignite.internal.tx.InternalTransactionBase;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.internal.util.ExceptionUtils;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.lang.IgniteException;
import org.apache.ignite.lang.MarshallerException;
import org.apache.ignite.lang.TableNotFoundException;
import org.apache.ignite.lang.util.IgniteNameUtils;
import org.apache.ignite.table.ContinuousQueryOptions;
import org.apache.ignite.table.ContinuousQueryPhysicalTimeWatermark;
import org.apache.ignite.table.ContinuousQueryTransactionWatermark;
import org.apache.ignite.table.ContinuousQueryWatermark;
import org.apache.ignite.table.QualifiedName;
import org.apache.ignite.table.TableRowEventBatch;
import org.apache.ignite.table.partition.Partition;
import org.apache.ignite.tx.Transaction;
import org.jetbrains.annotations.Nullable;

public class ContinuousQuery<RowT, SchemaT extends Versionable, EntryT> {
    private final IgniteLogger log = Loggers.forClass(ContinuousQuery.class);
    private final Flow.Subscriber<TableRowEventBatch<EntryT>> subscriber;
    private final ContinuousQueryOptions options;
    private final QualifiedName tableName;
    private final byte eventTypes;
    private final String[] columnNames;
    private final BiFunction<RowT, SchemaT, EntryT> mapper;
    private final ContinuousQueryRequestSender<RowT, SchemaT> requestSender;
    private final AtomicLong requested = new AtomicLong(0L);
    private final AtomicBoolean cancelled = new AtomicBoolean(false);
    private final int[] partitionSet;
    private final CompletableFuture<ContinuousQueryScanResultWithSchema<RowT, SchemaT>>[] futs;
    private final UUID[] lowerBoundRowIds;
    private final long[] lowerBoundTimestamps;
    private final ContinuousQueryScanResultStatus[] statuses;
    private final Executor delayedExecutor;
    private final ContinuousQueryMetricSink metrics;

    public ContinuousQuery(Flow.Subscriber<TableRowEventBatch<EntryT>> subscriber, @Nullable ContinuousQueryOptions options, BiFunction<RowT, SchemaT, EntryT> mapper, ContinuousQueryRequestSender<RowT, SchemaT> requestSender, ContinuousQueryMetricSink metrics, int partitions, QualifiedName tableName, @Nullable HybridTimestamp observableTimestamp) {
        assert (subscriber != null) : "Subscriber != null";
        assert (mapper != null) : "Mapper != null";
        assert (requestSender != null) : "Request sender != null";
        this.subscriber = subscriber;
        this.options = options == null ? ContinuousQueryOptions.DEFAULT : options;
        this.tableName = tableName;
        this.eventTypes = ContinuousQueryUtils.encodeEventTypes(this.options.eventTypes());
        this.mapper = mapper;
        this.requestSender = requestSender;
        this.metrics = metrics;
        this.partitionSet = ContinuousQuery.initPartitionSet(partitions, this.options.partitions());
        this.columnNames = ContinuousQuery.parsedColumnNames(this.options.columnNames());
        this.futs = new CompletableFuture[this.partitionSet.length];
        this.lowerBoundRowIds = new UUID[partitions];
        this.lowerBoundTimestamps = new long[partitions];
        this.statuses = new ContinuousQueryScanResultStatus[this.partitionSet.length];
        Arrays.fill((Object[])this.statuses, (Object)ContinuousQueryScanResultStatus.OK);
        ContinuousQueryWatermark watermark = this.options.watermark();
        if (watermark instanceof ContinuousQueryEventWatermark) {
            ContinuousQueryEventWatermark wm = (ContinuousQueryEventWatermark)watermark;
            Objects.requireNonNull(wm.rowIds());
            Objects.requireNonNull(wm.timestamps());
            if (wm.rowIds().length != partitions) {
                throw new IllegalArgumentException("Partition count mismatch in rowIds: expected=" + partitions + ", actual=" + wm.rowIds().length);
            }
            if (wm.timestamps().length != partitions) {
                throw new IllegalArgumentException("Partition count mismatch in timestamps: expected=" + partitions + ", actual=" + wm.timestamps().length);
            }
            for (int partId : this.partitionSet) {
                UUID rowId = wm.rowIds()[partId];
                long ts = wm.timestamps()[partId];
                if (rowId == null) {
                    throw new IllegalArgumentException("Continuous query watermark is incomplete, partition " + partId + " is missing. Make sure to use the same set of partitions in ContinuousQueryOptions.partitions to resume the query.");
                }
                this.lowerBoundRowIds[partId] = rowId;
                this.lowerBoundTimestamps[partId] = ts;
            }
        } else {
            UUID lowestRowId = new UUID(0L, 0L);
            long startHybridTs = ContinuousQuery.getStartHybridTs(observableTimestamp, watermark);
            for (int partId : this.partitionSet) {
                this.lowerBoundRowIds[partId] = lowestRowId;
                this.lowerBoundTimestamps[partId] = startHybridTs;
            }
        }
        this.delayedExecutor = CompletableFuture.delayedExecutor(this.options.pollIntervalMs(), TimeUnit.MILLISECONDS, this.options.executor());
    }

    public void run() {
        this.subscriber.onSubscribe(new Flow.Subscription(){

            @Override
            public void request(long l) {
                ContinuousQuery.this.requested.addAndGet(l);
            }

            @Override
            public void cancel() {
                ContinuousQuery.this.cancelled.set(true);
            }
        });
        this.options.executor().execute(() -> this.iterate(-1));
    }

    private void iterate(int resumePartIndex) {
        if (this.cancelled.get()) {
            this.subscriber.onComplete();
            return;
        }
        try {
            if (this.requested.get() == 0L) {
                this.delayedExecutor.execute(() -> this.iterate(resumePartIndex));
                return;
            }
            if (resumePartIndex < 0) {
                for (int partIndex = 0; partIndex < this.partitionSet.length; ++partIndex) {
                    int partId = this.partitionSet[partIndex];
                    if (this.statuses[partIndex] == ContinuousQueryScanResultStatus.OK) {
                        ContinuousQueryRequest req = new ContinuousQueryRequest(partId, this.lowerBoundTimestamps[partId], this.lowerBoundRowIds[partId], this.options.pageSize(), this.eventTypes, this.columnNames, this.options.skipOldEntries());
                        this.futs[partIndex] = this.requestSender.sendContinuousQueryRequest(req);
                        this.metrics.continuousQueryRequestsSentAdd(1L);
                        continue;
                    }
                    this.futs[partIndex] = CompletableFutures.nullCompletedFuture();
                    this.log.debug("Continuous query scan for table {} partition {} was skipped.", this.tableName.toCanonicalForm(), partId);
                }
            }
            CompletableFuture.allOf(this.futs).whenCompleteAsync((v, e) -> {
                if (e != null) {
                    this.subscriber.onError(IgniteExceptionMapperUtil.mapToPublicException(ExceptionUtils.unwrapCause(e)));
                    return;
                }
                try {
                    this.iterateInner(resumePartIndex);
                }
                catch (Throwable t) {
                    this.subscriber.onError(IgniteExceptionMapperUtil.mapToPublicException(t));
                }
            }, this.options.executor());
        }
        catch (Throwable t) {
            this.subscriber.onError(IgniteExceptionMapperUtil.mapToPublicException(t));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void iterateInner(int resumePartIndex) throws Exception {
        if (this.cancelled.get()) {
            this.subscriber.onComplete();
            return;
        }
        int startPartIndex = Math.max(resumePartIndex, 0);
        boolean probablyHasMore = false;
        ArrayList batchRows = new ArrayList();
        for (int partIndex = startPartIndex; partIndex < this.partitionSet.length; ++partIndex) {
            int partId = this.partitionSet[partIndex];
            CompletableFuture<ContinuousQueryScanResultWithSchema<RowT, SchemaT>> fut = this.futs[partIndex];
            assert (fut.isDone()) : "fut.isDone()";
            ContinuousQueryScanResultWithSchema<RowT, SchemaT> cqRes = fut.join();
            if (cqRes == null) continue;
            if (!cqRes.result().rows().isEmpty()) {
                List<RowUpdateInfo<RowT>> rows = cqRes.result().rows();
                batchRows.clear();
                int schemaVersion = ((Versionable)cqRes.schema()).version();
                this.metrics.continuousQueryEventsReceivedAdd(rows.size());
                try (TableRowEventBatchImpl batch = new TableRowEventBatchImpl(batchRows, rows, this.lowerBoundRowIds, this.lowerBoundTimestamps, partId, schemaVersion);){
                    for (int rowIdx = 0; rowIdx < rows.size(); ++rowIdx) {
                        if (this.cancelled.get()) {
                            this.subscriber.onComplete();
                            return;
                        }
                        RowUpdateInfo<RowT> row = rows.get(rowIdx);
                        EntryT entry = this.map(row.row(), (Versionable)cqRes.schema());
                        EntryT oldEntry = this.map(row.oldRow(), (Versionable)cqRes.schema());
                        this.lowerBoundTimestamps[partId] = row.timestamp().longValue();
                        this.lowerBoundRowIds[partId] = row.rowUuid();
                        batchRows.add(new TableRowEventImpl<EntryT>(entry, oldEntry, batch, rowIdx, row.timestamp().longValue(), row.eventType()));
                    }
                    this.subscriber.onNext(batch);
                }
                finally {
                    RowUpdateInfo<RowT> lastRow = rows.get(rows.size() - 1);
                    this.lowerBoundTimestamps[partId] = lastRow.timestamp().longValue();
                    this.lowerBoundRowIds[partId] = lastRow.rowUuid();
                }
                if (this.requested.decrementAndGet() <= 0L && partIndex < this.partitionSet.length - 1) {
                    this.iterate(partIndex + 1);
                    return;
                }
                probablyHasMore = probablyHasMore || rows.size() == this.options.pageSize();
            } else if (cqRes.result().safeTime() > this.lowerBoundTimestamps[partId]) {
                this.lowerBoundTimestamps[partId] = cqRes.result().safeTime();
                this.lowerBoundRowIds[partId] = new UUID(0L, 0L);
                if (this.options.enableEmptyBatches()) {
                    try (TableRowEventBatchImpl batch = new TableRowEventBatchImpl(List.of(), List.of(), this.lowerBoundRowIds, this.lowerBoundTimestamps, partId, null);){
                        this.subscriber.onNext(batch);
                    }
                }
            }
            if (cqRes.result().status() == ContinuousQueryScanResultStatus.OK) continue;
            this.statuses[partIndex] = cqRes.result().status();
        }
        if (this.allPartitionsCompleted()) {
            this.completeSubscription();
            return;
        }
        if (probablyHasMore && this.requested.get() > 0L) {
            this.iterate(-1);
        } else {
            this.delayedExecutor.execute(() -> this.iterate(-1));
        }
    }

    private boolean allPartitionsCompleted() {
        for (ContinuousQueryScanResultStatus status : this.statuses) {
            if (status != ContinuousQueryScanResultStatus.OK) continue;
            return false;
        }
        return true;
    }

    private void completeSubscription() {
        EnumSet<ContinuousQueryScanResultStatus> reasons = EnumSet.copyOf(Arrays.asList(this.statuses));
        assert (!reasons.isEmpty());
        if (reasons.size() == 1) {
            ContinuousQueryScanResultStatus singularReason = (ContinuousQueryScanResultStatus)((Object)reasons.iterator().next());
            if (singularReason == ContinuousQueryScanResultStatus.END_OF_LOG_REACHED_TABLE_DROPPED) {
                String msg = IgniteStringFormatter.format("Continuous query terminated because table {} was concurrently dropped", this.tableName.toCanonicalForm());
                this.subscriber.onError(new TableNotFoundException(UUID.randomUUID(), ErrorGroups.Table.TABLE_NOT_FOUND_ERR, msg, null));
            } else {
                String msg = "Continuous query terminated because of " + singularReason;
                this.subscriber.onError(new IgniteException(UUID.randomUUID(), ErrorGroups.Common.INTERNAL_ERR, msg));
            }
        } else {
            String errMsg = IgniteStringFormatter.format("Continuous query terminated because of multiple reasons ({}). Check details in the logs", reasons);
            this.subscriber.onError(new IgniteException(UUID.randomUUID(), ErrorGroups.Common.INTERNAL_ERR, errMsg));
            StringBuilder sb = new StringBuilder("Continuous query for table {} has been terminated because partitions scan were unsuccessful:");
            for (int i = 0; i < this.partitionSet.length; ++i) {
                sb.append("part_").append(this.partitionSet[i]).append(" - ").append((Object)this.statuses[i]).append("; ");
            }
            this.log.error(sb.toString(), this.tableName.toCanonicalForm());
        }
    }

    @Nullable
    private EntryT map(@Nullable RowT row, SchemaT schema) {
        try {
            return row == null ? null : (EntryT)this.mapper.apply(row, schema);
        }
        catch (Throwable t) {
            throw t instanceof MarshallerException ? (MarshallerException)t : new MarshallerException(t);
        }
    }

    private static String @Nullable [] parsedColumnNames(@Nullable Set<String> names) {
        if (names == null) {
            return null;
        }
        String[] res = new String[names.size()];
        int idx = 0;
        for (String name : names) {
            res[idx++] = IgniteNameUtils.parseIdentifier(name);
        }
        return res;
    }

    private static int[] initPartitionSet(int partitions, @Nullable Set<Partition> optsPartitions) {
        if (optsPartitions == null) {
            int[] fullPartitionSet = new int[partitions];
            for (int i = 0; i < partitions; ++i) {
                fullPartitionSet[i] = i;
            }
            return fullPartitionSet;
        }
        if (optsPartitions.size() > partitions) {
            throw new IllegalArgumentException("Partition set cannot contain more partitions than the table has: tablePartitions=" + partitions + ", ContinuousQueryOptions.partitions().size()=" + optsPartitions.size());
        }
        int[] partitionSet = new int[optsPartitions.size()];
        int idx = 0;
        for (Partition partition : optsPartitions) {
            int partId = ContinuousQuery.getPartitionId(partition);
            if (partId < 0 || partId >= partitions) {
                throw new IllegalArgumentException("Invalid partition id: " + partId + ". Must be in range [0, " + (partitions - 1) + "]");
            }
            partitionSet[idx++] = partId;
        }
        return partitionSet;
    }

    private static int getPartitionId(Partition partition) {
        if (partition == null) {
            throw new IllegalArgumentException("Partition in ContinuousQueryOptions.partitions cannot be null");
        }
        if (!(partition instanceof HashPartition)) {
            throw new IllegalArgumentException("Unsupported partition type: " + partition.getClass());
        }
        return (int)partition.id();
    }

    private static long getStartHybridTs(@Nullable HybridTimestamp observableTimestamp, @Nullable ContinuousQueryWatermark watermark) {
        if (watermark instanceof ContinuousQueryPhysicalTimeWatermark) {
            long epochMilli = ((ContinuousQueryPhysicalTimeWatermark)watermark).startTime().toEpochMilli();
            return HybridTimestamp.physicalToLong(epochMilli);
        }
        if (watermark instanceof ContinuousQueryTransactionWatermark) {
            ContinuousQueryTransactionWatermark txWm = (ContinuousQueryTransactionWatermark)watermark;
            Transaction tx = txWm.transaction();
            assert (tx != null) : "tx != null";
            if (!(tx instanceof InternalTransactionBase)) {
                throw new IllegalArgumentException("Unexpected transaction type: " + tx.getClass());
            }
            InternalTransactionBase internalTx = (InternalTransactionBase)((Object)tx);
            HybridTimestamp readTs = internalTx.readTimestamp();
            if (readTs == null) {
                throw new IllegalStateException("Unexpected transaction without read timestamp: " + tx);
            }
            return txWm.isAfter() ? readTs.longValue() + 1L : readTs.longValue();
        }
        if (watermark != null) {
            throw new IllegalArgumentException("Unsupported watermark type: " + watermark.getClass());
        }
        if (observableTimestamp != null && observableTimestamp.longValue() != 0L) {
            return observableTimestamp.longValue() + 1L;
        }
        return HybridTimestamp.physicalToLong(System.currentTimeMillis());
    }
}

