/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.dr.binary;

import org.apache.ignite.internal.util.GridUnsafe;

public final class BinaryPrimitives {
    public static Object readBoolean(byte[] arr, int off) {
        return BinaryPrimitives.readByte(arr, off) == 1;
    }

    public static byte readByte(byte[] arr, int off) {
        return GridUnsafe.getByte(arr, GridUnsafe.BYTE_ARR_OFF + (long)off);
    }

    public static short readShort(byte[] arr, int off) {
        return GridUnsafe.getShort(arr, GridUnsafe.BYTE_ARR_OFF + (long)off);
    }

    public static int readInt(byte[] arr, int off) {
        return GridUnsafe.getInt(arr, GridUnsafe.BYTE_ARR_OFF + (long)off);
    }

    public static long readLong(byte[] arr, int off) {
        return GridUnsafe.getLong(arr, GridUnsafe.BYTE_ARR_OFF + (long)off);
    }

    public static Object readFloat(byte[] arr, int off) {
        return Float.valueOf(GridUnsafe.getFloat(arr, GridUnsafe.BYTE_ARR_OFF + (long)off));
    }

    public static Object readDouble(byte[] arr, int off) {
        return GridUnsafe.getDouble(arr, GridUnsafe.BYTE_ARR_OFF + (long)off);
    }

    public static Object readChar(byte[] arr, int off) {
        return Character.valueOf(GridUnsafe.getChar(arr, GridUnsafe.BYTE_ARR_OFF + (long)off));
    }

    public static byte[] readByteArray(byte[] arr, int off, int len) {
        byte[] arr0 = new byte[len];
        System.arraycopy(arr, off, arr0, 0, len);
        return arr0;
    }

    private BinaryPrimitives() {
    }
}

