/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import org.apache.ignite.internal.util.AsyncCursor;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.lang.CursorClosedException;

public class AsyncWrapper<T>
implements AsyncCursor<T> {
    private final CompletableFuture<Iterator<T>> cursorFut;
    private final CompletableFuture<Void> cancelFut = new CompletableFuture();
    private final Executor exec;
    private final Object lock = new Object();
    private CompletableFuture<AsyncCursor.BatchedResult<T>> requestChainTail = CompletableFutures.nullCompletedFuture();
    private volatile boolean cancelled = false;
    private volatile boolean firstRequest = true;

    public AsyncWrapper(Iterator<T> source) {
        this(CompletableFuture.completedFuture(source), Runnable::run);
    }

    public AsyncWrapper(CompletableFuture<Iterator<T>> initFut, Executor exec) {
        this.cursorFut = initFut;
        this.exec = exec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<AsyncCursor.BatchedResult<T>> requestNextAsync(int rows) {
        CompletableFuture<AsyncCursor.BatchedResult<T>> prev;
        CompletableFuture next = new CompletableFuture();
        Object object = this.lock;
        synchronized (object) {
            if (this.cancelled) {
                next.completeExceptionally(new CursorClosedException());
                return next;
            }
            prev = this.requestChainTail;
            this.requestChainTail = next;
        }
        ((CompletableFuture)((CompletableFuture)prev.thenCompose(tmp -> this.cursorFut)).thenAcceptAsync(cursor -> {
            int remains = rows;
            if (!cursor.hasNext() && !this.firstRequest) {
                next.completeExceptionally(new NoSuchElementException());
                return;
            }
            ArrayList batch = new ArrayList(rows);
            this.firstRequest = false;
            while (remains-- > 0 && cursor.hasNext()) {
                batch.add(cursor.next());
            }
            next.complete(new AsyncCursor.BatchedResult(batch, cursor.hasNext()));
        }, this.exec)).exceptionally(t -> {
            next.completeExceptionally((Throwable)t);
            return null;
        });
        return next;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Void> closeAsync() {
        if (!this.cancelled) {
            Object object = this.lock;
            synchronized (object) {
                if (!this.cancelled) {
                    if (!this.requestChainTail.isDone()) {
                        this.requestChainTail.completeExceptionally(new CursorClosedException());
                    }
                    this.cursorFut.whenCompleteAsync((cursor, executionError) -> {
                        if (cursor instanceof AutoCloseable) {
                            try {
                                ((AutoCloseable)((Object)cursor)).close();
                                this.cancelFut.complete(null);
                            }
                            catch (Exception e) {
                                this.cancelFut.completeExceptionally(e);
                            }
                        } else {
                            this.cancelFut.complete(null);
                        }
                    }, this.exec);
                    this.cancelled = true;
                }
            }
        }
        return this.cancelFut.thenApply(Function.identity());
    }
}

