/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network.recovery.message;

import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.BitSet;
import java.util.Objects;
import org.apache.ignite.internal.network.message.ClusterNodeMessage;
import org.apache.ignite.internal.network.recovery.message.HandshakeStartResponseMessageV2;
import org.apache.ignite.internal.network.recovery.message.HandshakeStartResponseMessageV2Builder;
import org.apache.ignite.internal.network.recovery.message.HandshakeStartResponseMessageV2Serializer;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.network.serialization.marshal.UserObjectMarshaller;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;

public class HandshakeStartResponseMessageV2Impl
implements HandshakeStartResponseMessageV2,
Cloneable {
    public static final short GROUP_TYPE = 1;
    public static final short TYPE = 52;
    @IgniteToStringInclude
    private final short connectionId;
    @IgniteToStringInclude
    private final BitSet featureSet;
    @IgniteToStringInclude
    private final ClusterNodeMessage initiatorNode;
    @IgniteToStringInclude
    private final long receivedCount;

    private HandshakeStartResponseMessageV2Impl(short connectionId, BitSet featureSet, ClusterNodeMessage initiatorNode, long receivedCount) {
        this.connectionId = connectionId;
        this.featureSet = featureSet;
        this.initiatorNode = initiatorNode;
        this.receivedCount = receivedCount;
    }

    @Override
    public short connectionId() {
        return this.connectionId;
    }

    @Override
    public BitSet featureSet() {
        return this.featureSet;
    }

    @Override
    public ClusterNodeMessage initiatorNode() {
        return this.initiatorNode;
    }

    @Override
    public long receivedCount() {
        return this.receivedCount;
    }

    public MessageSerializer serializer() {
        return HandshakeStartResponseMessageV2Serializer.INSTANCE;
    }

    @Override
    public short groupType() {
        return 1;
    }

    public String toString() {
        return S.toString(HandshakeStartResponseMessageV2Impl.class, this);
    }

    @Override
    public short messageType() {
        return 52;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        HandshakeStartResponseMessageV2Impl otherMessage = (HandshakeStartResponseMessageV2Impl)other;
        return Objects.equals(this.featureSet, otherMessage.featureSet) && Objects.equals(this.initiatorNode, otherMessage.initiatorNode) && this.connectionId == otherMessage.connectionId && this.receivedCount == otherMessage.receivedCount;
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.connectionId, this.receivedCount, this.featureSet, this.initiatorNode);
        return result;
    }

    @Override
    public HandshakeStartResponseMessageV2Impl clone() {
        try {
            return (HandshakeStartResponseMessageV2Impl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static HandshakeStartResponseMessageV2Builder builder() {
        return new Builder();
    }

    @Override
    public void prepareMarshal(IntSet usedDescriptors, Object marshallerObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.initiatorNode != null) {
            this.initiatorNode.prepareMarshal(usedDescriptors, marshaller);
        }
    }

    @Override
    public void unmarshal(Object marshallerObj, Object descriptorsObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.initiatorNode != null) {
            this.initiatorNode.unmarshal(marshaller, descriptorsObj);
        }
    }

    private static class Builder
    implements HandshakeStartResponseMessageV2Builder {
        private short connectionId;
        private BitSet featureSet;
        private ClusterNodeMessage initiatorNode;
        private long receivedCount;

        private Builder() {
        }

        @Override
        public HandshakeStartResponseMessageV2Builder connectionId(short connectionId) {
            this.connectionId = connectionId;
            return this;
        }

        @Override
        public HandshakeStartResponseMessageV2Builder featureSet(BitSet featureSet) {
            Objects.requireNonNull(featureSet, "featureSet is not marked @Nullable");
            this.featureSet = featureSet;
            return this;
        }

        @Override
        public HandshakeStartResponseMessageV2Builder initiatorNode(ClusterNodeMessage initiatorNode) {
            Objects.requireNonNull(initiatorNode, "initiatorNode is not marked @Nullable");
            this.initiatorNode = initiatorNode;
            return this;
        }

        @Override
        public HandshakeStartResponseMessageV2Builder receivedCount(long receivedCount) {
            this.receivedCount = receivedCount;
            return this;
        }

        @Override
        public short connectionId() {
            return this.connectionId;
        }

        @Override
        public BitSet featureSet() {
            return this.featureSet;
        }

        @Override
        public ClusterNodeMessage initiatorNode() {
            return this.initiatorNode;
        }

        @Override
        public long receivedCount() {
            return this.receivedCount;
        }

        @Override
        public HandshakeStartResponseMessageV2 build() {
            return new HandshakeStartResponseMessageV2Impl(this.connectionId, Objects.requireNonNull(this.featureSet, "featureSet is not marked @Nullable"), Objects.requireNonNull(this.initiatorNode, "initiatorNode is not marked @Nullable"), this.receivedCount);
        }

        @Override
        public HandshakeStartResponseMessageV2 buildDeserialized() {
            return new HandshakeStartResponseMessageV2Impl(this.connectionId, this.featureSet, this.initiatorNode, this.receivedCount);
        }
    }
}

