/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.failure.handlers;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.internal.failure.FailureContext;
import org.apache.ignite.internal.failure.NodeStopper;
import org.apache.ignite.internal.failure.handlers.AbstractFailureHandler;
import org.apache.ignite.internal.failure.handlers.configuration.StopNodeOrHaltFailureHandlerView;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.thread.LogUncaughtExceptionHandler;
import org.apache.ignite.internal.tostring.IgniteToStringExclude;
import org.apache.ignite.internal.tostring.S;

public class StopNodeOrHaltFailureHandler
extends AbstractFailureHandler {
    private static final IgniteLogger LOG = Loggers.forClass(StopNodeOrHaltFailureHandler.class);
    private static final int KILL_EXIT_CODE = 130;
    @IgniteToStringExclude
    private final NodeStopper nodeStopper;
    private final boolean tryStop;
    private final long timeout;

    public StopNodeOrHaltFailureHandler(NodeStopper nodeStopper, boolean tryStop, long timeout) {
        this.nodeStopper = nodeStopper;
        this.tryStop = tryStop;
        this.timeout = timeout;
    }

    public StopNodeOrHaltFailureHandler(NodeStopper nodeStopper, StopNodeOrHaltFailureHandlerView view) {
        this.nodeStopper = nodeStopper;
        this.tryStop = view.tryStop();
        this.timeout = view.timeoutMillis();
    }

    @Override
    protected boolean handle(FailureContext failureCtx) {
        if (this.tryStop) {
            CountDownLatch latch = new CountDownLatch(1);
            Thread stopperThread = new Thread(() -> {
                this.nodeStopper.stopNode();
                latch.countDown();
            }, "node-stopper");
            stopperThread.setUncaughtExceptionHandler(new LogUncaughtExceptionHandler(LOG));
            stopperThread.start();
            Thread haltOnStopTimeoutThread = new Thread(() -> {
                try {
                    if (!latch.await(this.timeout, TimeUnit.MILLISECONDS)) {
                        Runtime.getRuntime().halt(130);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }, "jvm-halt-on-stop-timeout");
            haltOnStopTimeoutThread.setUncaughtExceptionHandler(new LogUncaughtExceptionHandler(LOG));
            haltOnStopTimeoutThread.start();
        } else {
            Runtime.getRuntime().halt(130);
        }
        return true;
    }

    public long timeout() {
        return this.timeout;
    }

    public boolean tryStop() {
        return this.tryStop;
    }

    @Override
    public String toString() {
        return S.toString(StopNodeOrHaltFailureHandler.class, this, super.toString());
    }
}

