/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.configuration.asm;

import com.facebook.presto.bytecode.Access;
import com.facebook.presto.bytecode.BytecodeBlock;
import com.facebook.presto.bytecode.ClassDefinition;
import com.facebook.presto.bytecode.FieldDefinition;
import com.facebook.presto.bytecode.MethodDefinition;
import com.facebook.presto.bytecode.Parameter;
import com.facebook.presto.bytecode.ParameterizedType;
import com.facebook.presto.bytecode.Variable;
import com.facebook.presto.bytecode.expression.BytecodeExpression;
import com.facebook.presto.bytecode.expression.BytecodeExpressions;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.ignite.configuration.ConfigurationProperty;
import org.apache.ignite.configuration.ConfigurationTree;
import org.apache.ignite.configuration.ConfigurationValue;
import org.apache.ignite.configuration.ConfigurationWrongPolymorphicTypeIdException;
import org.apache.ignite.configuration.NamedConfigurationTree;
import org.apache.ignite.configuration.RootKey;
import org.apache.ignite.internal.configuration.ConfigurationNode;
import org.apache.ignite.internal.configuration.ConfigurationTreeWrapper;
import org.apache.ignite.internal.configuration.DynamicConfiguration;
import org.apache.ignite.internal.configuration.DynamicConfigurationChanger;
import org.apache.ignite.internal.configuration.DynamicProperty;
import org.apache.ignite.internal.configuration.NamedListConfiguration;
import org.apache.ignite.internal.configuration.asm.AbstractAsmGenerator;
import org.apache.ignite.internal.configuration.asm.ConfigurationAsmGenerator;
import org.apache.ignite.internal.configuration.asm.DirectProxyAsmGenerator;
import org.apache.ignite.internal.configuration.asm.SchemaClassesInfo;
import org.apache.ignite.internal.configuration.asm.StringSwitchBuilder;
import org.apache.ignite.internal.configuration.util.ConfigurationUtil;
import org.apache.ignite.internal.util.ArrayUtils;
import org.apache.ignite.internal.util.CollectionUtils;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Type;

class ConfigurationImplAsmGenerator
extends AbstractAsmGenerator {
    private static final Constructor<?> DYNAMIC_CONFIGURATION_CTOR;
    private static final Method DYNAMIC_CONFIGURATION_ADD_MTD;
    private static final Method REFRESH_VALUE_MTD;
    private static final Method ADD_MEMBER_MTD;
    private static final Method REMOVE_MEMBER_MTD;
    private static final Method SPECIFIC_CONFIG_TREE_MTD;
    private static final String EXTENSION_CONFIG_TYPES_FIELD_NAME = "_extensionConfigTypes";
    private ClassDefinition cfgImplClassDef;

    ConfigurationImplAsmGenerator(ConfigurationAsmGenerator cgen, Class<?> schemaClass, Set<Class<?>> extensions, Set<Class<?>> polymorphicExtensions, List<Field> schemaFields, Collection<Field> publicExtensionFields, Collection<Field> internalExtensionFields, Collection<Field> polymorphicFields, @Nullable Field internalIdField) {
        super(cgen, schemaClass, extensions, polymorphicExtensions, schemaFields, publicExtensionFields, internalExtensionFields, polymorphicFields, internalIdField);
    }

    @Override
    public List<ClassDefinition> generate() {
        assert (this.cfgImplClassDef == null);
        ArrayList<ClassDefinition> classDefs = new ArrayList<ClassDefinition>();
        classDefs.add(this.createCfgImplClass());
        for (Class polymorphicExtension : this.polymorphicExtensions) {
            Collection polymorphicFields = this.polymorphicFields.stream().filter(f -> f.getDeclaringClass() == polymorphicExtension).collect(Collectors.toList());
            classDefs.add(this.createPolymorphicExtensionCfgImplClass(polymorphicExtension, polymorphicFields));
        }
        return classDefs;
    }

    private ClassDefinition createCfgImplClass() {
        SchemaClassesInfo schemaClassInfo = this.cgen.schemaInfo(this.schemaClass);
        this.cfgImplClassDef = new ClassDefinition(EnumSet.of(Access.PUBLIC, Access.FINAL), ConfigurationAsmGenerator.internalName(schemaClassInfo.cfgImplClassName), ParameterizedType.type(DynamicConfiguration.class), this.cgen.configClassInterfaces(this.schemaClass, this.extensions));
        HashMap<String, FieldDefinition> fieldDefs = new HashMap<String, FieldDefinition>();
        FieldDefinition polymorphicTypeIdFieldDef = null;
        for (Field schemaField : CollectionUtils.concat(new Collection[]{this.schemaFields, this.publicExtensionFields, this.internalExtensionFields, this.polymorphicFields})) {
            String fieldName = ConfigurationAsmGenerator.fieldName(schemaField);
            FieldDefinition fieldDef = this.addConfigurationImplField(schemaField, fieldName);
            fieldDefs.put(fieldName, fieldDef);
            if (!ConfigurationUtil.isPolymorphicId(schemaField)) continue;
            polymorphicTypeIdFieldDef = fieldDef;
        }
        if (this.internalIdField != null) {
            String fieldName = this.internalIdField.getName();
            FieldDefinition fieldDef = this.addConfigurationImplField(this.internalIdField, fieldName);
            fieldDefs.put(fieldName, fieldDef);
        }
        FieldDefinition extensionConfigTypesFieldDef = null;
        if (!this.extensions.isEmpty()) {
            extensionConfigTypesFieldDef = this.cfgImplClassDef.declareField(EnumSet.of(Access.PRIVATE, Access.FINAL), EXTENSION_CONFIG_TYPES_FIELD_NAME, Class[].class);
        }
        this.addConfigurationImplConstructor(fieldDefs, extensionConfigTypesFieldDef);
        this.addDirectProxyMethod(schemaClassInfo);
        if (this.internalIdField != null) {
            this.addConfigurationImplGetMethod(this.cfgImplClassDef, this.internalIdField, (FieldDefinition)fieldDefs.get(this.internalIdField.getName()));
        }
        for (Field schemaField : CollectionUtils.concat(new Collection[]{this.schemaFields, this.publicExtensionFields, this.internalExtensionFields})) {
            this.addConfigurationImplGetMethod(this.cfgImplClassDef, schemaField, (FieldDefinition)fieldDefs.get(ConfigurationAsmGenerator.fieldName(schemaField)));
        }
        this.addCfgImplConfigTypeMethod(ParameterizedType.typeFromJavaClassName(schemaClassInfo.cfgClassName));
        if (extensionConfigTypesFieldDef != null) {
            ConfigurationImplAsmGenerator.addCfgImplInternalConfigTypesMethod(this.cfgImplClassDef, extensionConfigTypesFieldDef);
        }
        if (!this.polymorphicExtensions.isEmpty()) {
            this.addCfgSpecificConfigTreeMethod(polymorphicTypeIdFieldDef);
            this.addCfgRemoveMembersMethod(fieldDefs, polymorphicTypeIdFieldDef);
            this.addCfgAddMembersMethod(fieldDefs, polymorphicTypeIdFieldDef);
            this.addCfgImplPolymorphicInstanceConfigTypeMethod(polymorphicTypeIdFieldDef);
        }
        return this.cfgImplClassDef;
    }

    private FieldDefinition addConfigurationImplField(Field schemaField, String fieldName) {
        ParameterizedType fieldType = ConfigurationUtil.isConfigValue(schemaField) ? ParameterizedType.typeFromJavaClassName(this.cgen.schemaInfo(schemaField.getType()).cfgImplClassName) : (ConfigurationUtil.isNamedConfigValue(schemaField) ? ParameterizedType.type(NamedListConfiguration.class) : ParameterizedType.type(DynamicProperty.class));
        return this.cfgImplClassDef.declareField(EnumSet.of(Access.PUBLIC), fieldName, fieldType);
    }

    private void addConfigurationImplConstructor(Map<String, FieldDefinition> fieldDefs, @Nullable FieldDefinition extensionConfigTypesFieldDef) {
        MethodDefinition ctor = this.cfgImplClassDef.declareConstructor(EnumSet.of(Access.PUBLIC), Parameter.arg("prefix", List.class), Parameter.arg("key", String.class), Parameter.arg("rootKey", RootKey.class), Parameter.arg("changer", DynamicConfigurationChanger.class), Parameter.arg("listenOnly", Boolean.TYPE));
        Variable rootKeyVar = ctor.getScope().getVariable("rootKey");
        Variable changerVar = ctor.getScope().getVariable("changer");
        Variable listenOnlyVar = ctor.getScope().getVariable("listenOnly");
        SchemaClassesInfo schemaClassInfo = this.cgen.schemaInfo(this.schemaClass);
        Variable thisVar = ctor.getThis();
        BytecodeBlock ctorBody = ctor.getBody().append(thisVar).append(ctor.getScope().getVariable("prefix")).append(ctor.getScope().getVariable("key")).append(rootKeyVar).append(changerVar).append(listenOnlyVar).invokeConstructor(DYNAMIC_CONFIGURATION_CTOR);
        BytecodeExpression thisKeysVar = thisVar.getField("keys", List.class);
        List internalIdFieldAsList = this.internalIdField == null ? Collections.emptyList() : List.of(this.internalIdField);
        int newIdx = 0;
        for (Field schemaField : CollectionUtils.concat(new Collection[]{this.schemaFields, this.publicExtensionFields, this.internalExtensionFields, this.polymorphicFields, internalIdFieldAsList})) {
            BytecodeExpression newValue;
            String publicName = ConfigurationAsmGenerator.publicName(schemaField);
            if (ConfigurationUtil.isValue(schemaField) || ConfigurationUtil.isPolymorphicId(schemaField) || ConfigurationUtil.isInjectedName(schemaField) || ConfigurationUtil.isInternalId(schemaField)) {
                newValue = BytecodeExpressions.newInstance(DynamicProperty.class, thisKeysVar, BytecodeExpressions.constantString(ConfigurationUtil.isInjectedName(schemaField) ? "<injected_name>" : (ConfigurationUtil.isInternalId(schemaField) ? "<internal_id>" : publicName)), rootKeyVar, changerVar, listenOnlyVar, BytecodeExpressions.constantBoolean(ConfigurationUtil.isReadOnly(schemaField)));
            } else {
                SchemaClassesInfo fieldInfo = this.cgen.schemaInfo(schemaField.getType());
                ParameterizedType cfgImplParameterizedType = ParameterizedType.typeFromJavaClassName(fieldInfo.cfgImplClassName);
                if (ConfigurationUtil.isConfigValue(schemaField)) {
                    newValue = BytecodeExpressions.newInstance(cfgImplParameterizedType, thisKeysVar, BytecodeExpressions.constantString(publicName), rootKeyVar, changerVar, listenOnlyVar);
                } else {
                    MethodDefinition newMtd = this.cfgImplClassDef.declareMethod(EnumSet.of(Access.PRIVATE, Access.STATIC, Access.SYNTHETIC), "$new$" + newIdx++, ParameterizedType.typeFromJavaClassName(fieldInfo.cfgClassName), Parameter.arg("rootKey", RootKey.class), Parameter.arg("changer", DynamicConfigurationChanger.class), Parameter.arg("listenOnly", Boolean.TYPE), Parameter.arg("prefix", List.class), Parameter.arg("key", String.class));
                    newValue = BytecodeExpressions.newInstance(NamedListConfiguration.class, thisKeysVar, BytecodeExpressions.constantString(publicName), rootKeyVar, changerVar, listenOnlyVar, BytecodeExpressions.invokeDynamic(LAMBDA_METAFACTORY, Arrays.asList(Type.getMethodType(Type.getType(Object.class), Type.getType(Object.class), Type.getType(Object.class)), new Handle(6, ConfigurationAsmGenerator.internalName(schemaClassInfo.cfgImplClassName), newMtd.getName(), newMtd.getMethodDescriptor(), false), Type.getMethodType(ParameterizedType.typeFromJavaClassName(fieldInfo.cfgClassName).getAsmType(), Type.getType(List.class), Type.getType(String.class))), "apply", BiFunction.class, rootKeyVar, changerVar, listenOnlyVar), DirectProxyAsmGenerator.newDirectProxyLambda(fieldInfo), BytecodeExpressions.newInstance(cfgImplParameterizedType, thisKeysVar, BytecodeExpressions.constantString("any"), rootKeyVar, changerVar, BytecodeExpressions.constantBoolean(true)).cast(ConfigurationProperty.class));
                    newMtd.getBody().append(BytecodeExpressions.newInstance(cfgImplParameterizedType, newMtd.getScope().getVariable("prefix"), newMtd.getScope().getVariable("key"), newMtd.getScope().getVariable("rootKey"), newMtd.getScope().getVariable("changer"), newMtd.getScope().getVariable("listenOnly"))).retObject();
                }
            }
            FieldDefinition fieldDef = fieldDefs.get(ConfigurationAsmGenerator.fieldName(schemaField));
            ctorBody.append(thisVar.setField(fieldDef, newValue));
            if (ConfigurationUtil.isPolymorphicConfigInstance(schemaField.getDeclaringClass()) || ConfigurationUtil.isInternalId(schemaField)) continue;
            ctorBody.append(thisVar.invoke(DYNAMIC_CONFIGURATION_ADD_MTD, thisVar.getField(fieldDef)));
        }
        if (extensionConfigTypesFieldDef != null) {
            assert (!this.extensions.isEmpty()) : this.cfgImplClassDef;
            Variable tmpVar = ctor.getScope().createTempVariable(Class[].class);
            BytecodeBlock initExtensionConfigTypesField = new BytecodeBlock();
            initExtensionConfigTypesField.append(tmpVar.set(BytecodeExpressions.newArray(ParameterizedType.type(Class[].class), this.extensions.size())));
            int i = 0;
            for (Class extension : this.extensions) {
                initExtensionConfigTypesField.append(BytecodeExpressions.set(tmpVar, BytecodeExpressions.constantInt(i++), BytecodeExpressions.constantClass(ParameterizedType.typeFromJavaClassName(SchemaClassesInfo.configurationClassName(extension)))));
            }
            initExtensionConfigTypesField.append(ConfigurationAsmGenerator.setThisFieldCode(ctor, tmpVar, extensionConfigTypesFieldDef));
            ctorBody.append(initExtensionConfigTypesField);
        }
        ctorBody.ret();
    }

    private void addDirectProxyMethod(SchemaClassesInfo schemaClassInfo) {
        MethodDefinition methodDef = this.cfgImplClassDef.declareMethod(EnumSet.of(Access.PUBLIC), "directProxy", ParameterizedType.typeFromJavaClassName(schemaClassInfo.cfgClassName), new Parameter[0]);
        methodDef.getBody().append(BytecodeExpressions.newInstance(ParameterizedType.typeFromJavaClassName(schemaClassInfo.directProxyClassName), methodDef.getThis().invoke("keyPath", List.class, new BytecodeExpression[0]), methodDef.getThis().getField("changer", DynamicConfigurationChanger.class)));
        methodDef.getBody().retObject();
    }

    private void addConfigurationImplGetMethod(ClassDefinition classDef, Field schemaField, FieldDefinition ... fieldDefs) {
        ParameterizedType returnType;
        assert (!ArrayUtils.nullOrEmpty(fieldDefs));
        Class<?> schemaFieldType = schemaField.getType();
        String fieldName = schemaField.getName();
        SchemaClassesInfo schemaClassInfo = this.cgen.schemaInfo(schemaFieldType);
        if (ConfigurationUtil.isConfigValue(schemaField)) {
            returnType = ParameterizedType.typeFromJavaClassName(schemaClassInfo.cfgClassName);
        } else if (ConfigurationUtil.isNamedConfigValue(schemaField)) {
            returnType = ParameterizedType.type(NamedConfigurationTree.class);
        } else {
            assert (ConfigurationUtil.isValue(schemaField) || ConfigurationUtil.isPolymorphicId(schemaField) || ConfigurationUtil.isInjectedName(schemaField) || ConfigurationUtil.isInternalId(schemaField)) : schemaField;
            returnType = ParameterizedType.type(ConfigurationValue.class);
        }
        MethodDefinition viewMtd = classDef.declareMethod(EnumSet.of(Access.PUBLIC), fieldName, returnType, new Parameter[0]);
        BytecodeBlock body = viewMtd.getBody().append(ConfigurationAsmGenerator.getThisFieldCode(viewMtd, fieldDefs));
        if (ConfigurationUtil.isPolymorphicConfig(schemaFieldType) && ConfigurationUtil.isConfigValue(schemaField)) {
            body.invokeVirtual(SPECIFIC_CONFIG_TREE_MTD);
        }
        body.retObject();
    }

    private void addCfgImplConfigTypeMethod(ParameterizedType clazz) {
        this.cfgImplClassDef.declareMethod(EnumSet.of(Access.PUBLIC), "configType", ParameterizedType.type(Class.class), new Parameter[0]).getBody().append(BytecodeExpressions.constantClass(clazz)).retObject();
    }

    private static void addCfgImplInternalConfigTypesMethod(ClassDefinition classDef, FieldDefinition extensionConfigTypesDef) {
        MethodDefinition extensionConfigTypesMtd = classDef.declareMethod(EnumSet.of(Access.PUBLIC), "extensionConfigTypes", ParameterizedType.type(Class[].class), new Parameter[0]);
        extensionConfigTypesMtd.getBody().append(ConfigurationAsmGenerator.getThisFieldCode(extensionConfigTypesMtd, extensionConfigTypesDef)).retObject();
    }

    private void addCfgImplPolymorphicInstanceConfigTypeMethod(FieldDefinition polymorphicTypeIdFieldDef) {
        MethodDefinition polymorphicInstanceConfigTypeMtd = this.cfgImplClassDef.declareMethod(EnumSet.of(Access.PUBLIC), "polymorphicInstanceConfigType", ParameterizedType.type(Class.class), new Parameter[0]);
        Variable tmpStrVar = polymorphicInstanceConfigTypeMtd.getScope().createTempVariable(String.class);
        StringSwitchBuilder switchBuilder = new StringSwitchBuilder(polymorphicInstanceConfigTypeMtd.getScope()).expression(tmpStrVar).defaultCase(ConfigurationAsmGenerator.throwException(ConfigurationWrongPolymorphicTypeIdException.class, tmpStrVar));
        for (Class polymorphicExtension : this.polymorphicExtensions) {
            switchBuilder.addCase(ConfigurationUtil.polymorphicInstanceId(polymorphicExtension), BytecodeExpressions.constantClass(ParameterizedType.typeFromJavaClassName(SchemaClassesInfo.configurationClassName(polymorphicExtension))).ret());
        }
        ParameterizedType nodeType = ParameterizedType.typeFromJavaClassName(SchemaClassesInfo.nodeClassName(this.schemaClass));
        Variable tmpObjVar = polymorphicInstanceConfigTypeMtd.getScope().createTempVariable(Object.class);
        Variable thisVar = polymorphicInstanceConfigTypeMtd.getThis();
        polymorphicInstanceConfigTypeMtd.getBody().append(tmpObjVar.set(thisVar.invoke(REFRESH_VALUE_MTD, new BytecodeExpression[0]))).append(tmpStrVar.set(tmpObjVar.cast(nodeType).getField(polymorphicTypeIdFieldDef.getName(), String.class))).append(switchBuilder.build()).ret();
    }

    private ClassDefinition createPolymorphicExtensionCfgImplClass(Class<?> polymorphicExtension, Collection<Field> polymorphicFields) {
        SchemaClassesInfo schemaClassInfo = this.cgen.schemaInfo(this.schemaClass);
        SchemaClassesInfo polymorphicExtensionClassInfo = this.cgen.schemaInfo(polymorphicExtension);
        ClassDefinition classDef = new ClassDefinition(EnumSet.of(Access.PUBLIC, Access.FINAL), ConfigurationAsmGenerator.internalName(polymorphicExtensionClassInfo.cfgImplClassName), ParameterizedType.type(ConfigurationTreeWrapper.class), this.cgen.configClassInterfaces(polymorphicExtension, Set.of()));
        FieldDefinition parentCfgImplFieldDef = classDef.declareField(EnumSet.of(Access.PRIVATE, Access.FINAL), "this$0", ParameterizedType.typeFromJavaClassName(schemaClassInfo.cfgImplClassName));
        MethodDefinition constructorMtd = classDef.declareConstructor(EnumSet.of(Access.PUBLIC), Parameter.arg("delegate", ParameterizedType.typeFromJavaClassName(schemaClassInfo.cfgImplClassName)));
        Variable delegateVar = constructorMtd.getScope().getVariable("delegate");
        constructorMtd.getBody().append(constructorMtd.getThis()).append(delegateVar).invokeConstructor(ConfigurationTreeWrapper.class, ConfigurationTree.class).append(constructorMtd.getThis().setField(parentCfgImplFieldDef, (BytecodeExpression)delegateVar)).ret();
        Map fieldDefs = this.cfgImplClassDef.getFields().stream().collect(Collectors.toMap(FieldDefinition::getName, Function.identity()));
        if (this.internalIdField != null) {
            this.addConfigurationImplGetMethod(classDef, this.internalIdField, parentCfgImplFieldDef, (FieldDefinition)fieldDefs.get(this.internalIdField.getName()));
        }
        for (Field schemaField : CollectionUtils.concat(new Collection[]{this.schemaFields, polymorphicFields})) {
            this.addConfigurationImplGetMethod(classDef, schemaField, parentCfgImplFieldDef, (FieldDefinition)fieldDefs.get(ConfigurationAsmGenerator.fieldName(schemaField)));
        }
        return classDef;
    }

    private void addCfgSpecificConfigTreeMethod(FieldDefinition polymorphicTypeIdFieldDef) {
        MethodDefinition specificConfigMtd = this.cfgImplClassDef.declareMethod(EnumSet.of(Access.PUBLIC), SPECIFIC_CONFIG_TREE_MTD.getName(), ParameterizedType.type(ConfigurationTree.class), new Parameter[0]);
        Variable tmpStrVar = specificConfigMtd.getScope().createTempVariable(String.class);
        StringSwitchBuilder switchBuilder = new StringSwitchBuilder(specificConfigMtd.getScope()).expression(tmpStrVar).defaultCase(ConfigurationAsmGenerator.throwException(ConfigurationWrongPolymorphicTypeIdException.class, tmpStrVar));
        for (Class polymorphicExtension : this.polymorphicExtensions) {
            switchBuilder.addCase(ConfigurationUtil.polymorphicInstanceId(polymorphicExtension), BytecodeExpressions.newInstance(ParameterizedType.typeFromJavaClassName(this.cgen.schemaInfo(polymorphicExtension).cfgImplClassName), specificConfigMtd.getThis()).ret());
        }
        ParameterizedType nodeType = ParameterizedType.typeFromJavaClassName(this.cgen.schemaInfo(this.schemaClass).nodeClassName);
        Variable tmpObjVar = specificConfigMtd.getScope().createTempVariable(Object.class);
        specificConfigMtd.getBody().append(tmpObjVar.set(specificConfigMtd.getThis().invoke(REFRESH_VALUE_MTD, new BytecodeExpression[0]))).append(tmpStrVar.set(tmpObjVar.cast(nodeType).getField(polymorphicTypeIdFieldDef.getName(), String.class))).append(switchBuilder.build()).ret();
    }

    private void addCfgRemoveMembersMethod(Map<String, FieldDefinition> fieldDefs, FieldDefinition polymorphicTypeIdFieldDef) {
        MethodDefinition removeMembersMtd = this.cfgImplClassDef.declareMethod(EnumSet.of(Access.PUBLIC), "removeMembers", ParameterizedType.type(Void.TYPE), Parameter.arg("oldValue", ParameterizedType.type(Object.class)), Parameter.arg("members", ParameterizedType.type(Map.class)));
        Variable oldValueVar = removeMembersMtd.getScope().getVariable("oldValue");
        Variable membersVar = removeMembersMtd.getScope().getVariable("members");
        Variable tmpStrVar = removeMembersMtd.getScope().createTempVariable(String.class);
        StringSwitchBuilder switchBuilder = new StringSwitchBuilder(removeMembersMtd.getScope()).expression(tmpStrVar).defaultCase(ConfigurationAsmGenerator.throwException(ConfigurationWrongPolymorphicTypeIdException.class, tmpStrVar));
        for (Class polymorphicExtension : this.polymorphicExtensions) {
            Collection removeFields = this.polymorphicFields.stream().filter(f -> !polymorphicExtension.equals(f.getDeclaringClass())).collect(Collectors.toList());
            BytecodeBlock blockCode = new BytecodeBlock();
            for (Field removeField : removeFields) {
                blockCode.append(removeMembersMtd.getThis()).append(membersVar).append(ConfigurationAsmGenerator.getThisFieldCode(removeMembersMtd, fieldDefs.get(ConfigurationAsmGenerator.fieldName(removeField)))).invokeVirtual(REMOVE_MEMBER_MTD);
            }
            switchBuilder.addCase(ConfigurationUtil.polymorphicInstanceId(polymorphicExtension), blockCode);
        }
        ParameterizedType nodeType = ParameterizedType.typeFromJavaClassName(this.cgen.schemaInfo(this.schemaClass).nodeClassName);
        removeMembersMtd.getBody().append(tmpStrVar.set(oldValueVar.cast(nodeType).getField(polymorphicTypeIdFieldDef.getName(), String.class))).append(switchBuilder.build()).ret();
    }

    private void addCfgAddMembersMethod(Map<String, FieldDefinition> fieldDefs, FieldDefinition polymorphicTypeIdFieldDef) {
        MethodDefinition removeMembersMtd = this.cfgImplClassDef.declareMethod(EnumSet.of(Access.PUBLIC), "addMembers", ParameterizedType.type(Void.TYPE), Parameter.arg("newValue", ParameterizedType.type(Object.class)), Parameter.arg("members", ParameterizedType.type(Map.class)));
        Variable newValueVar = removeMembersMtd.getScope().getVariable("newValue");
        Variable membersVar = removeMembersMtd.getScope().getVariable("members");
        Variable tmpStrVar = removeMembersMtd.getScope().createTempVariable(String.class);
        StringSwitchBuilder switchBuilder = new StringSwitchBuilder(removeMembersMtd.getScope()).expression(tmpStrVar).defaultCase(ConfigurationAsmGenerator.throwException(ConfigurationWrongPolymorphicTypeIdException.class, tmpStrVar));
        for (Class polymorphicExtension : this.polymorphicExtensions) {
            Collection addFields = this.polymorphicFields.stream().filter(f -> polymorphicExtension.equals(f.getDeclaringClass())).collect(Collectors.toList());
            BytecodeBlock blockCode = new BytecodeBlock();
            for (Field addField : addFields) {
                blockCode.append(removeMembersMtd.getThis()).append(membersVar).append(ConfigurationAsmGenerator.getThisFieldCode(removeMembersMtd, fieldDefs.get(ConfigurationAsmGenerator.fieldName(addField)))).invokeVirtual(ADD_MEMBER_MTD);
            }
            switchBuilder.addCase(ConfigurationUtil.polymorphicInstanceId(polymorphicExtension), blockCode);
        }
        ParameterizedType nodeType = ParameterizedType.typeFromJavaClassName(this.cgen.schemaInfo(this.schemaClass).nodeClassName);
        removeMembersMtd.getBody().append(tmpStrVar.set(newValueVar.cast(nodeType).getField(polymorphicTypeIdFieldDef.getName(), String.class))).append(switchBuilder.build()).ret();
    }

    static {
        try {
            DYNAMIC_CONFIGURATION_CTOR = DynamicConfiguration.class.getDeclaredConstructor(List.class, String.class, RootKey.class, DynamicConfigurationChanger.class, Boolean.TYPE);
            DYNAMIC_CONFIGURATION_ADD_MTD = DynamicConfiguration.class.getDeclaredMethod("add", ConfigurationProperty.class);
            REFRESH_VALUE_MTD = ConfigurationNode.class.getDeclaredMethod("refreshValue", new Class[0]);
            ADD_MEMBER_MTD = DynamicConfiguration.class.getDeclaredMethod("addMember", Map.class, ConfigurationProperty.class);
            REMOVE_MEMBER_MTD = DynamicConfiguration.class.getDeclaredMethod("removeMember", Map.class, ConfigurationProperty.class);
            SPECIFIC_CONFIG_TREE_MTD = DynamicConfiguration.class.getDeclaredMethod("specificConfigTree", new Class[0]);
        }
        catch (NoSuchMethodException nsme) {
            throw new ExceptionInInitializerError(nsme);
        }
    }
}

