/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.sql;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.apache.ignite.catalog.ColumnSorted;
import org.apache.ignite.catalog.ColumnType;
import org.apache.ignite.catalog.IndexType;
import org.apache.ignite.catalog.annotations.Cache;
import org.apache.ignite.catalog.annotations.Column;
import org.apache.ignite.catalog.annotations.ColumnRef;
import org.apache.ignite.catalog.annotations.Id;
import org.apache.ignite.catalog.annotations.Index;
import org.apache.ignite.catalog.annotations.Table;
import org.apache.ignite.catalog.annotations.Zone;
import org.apache.ignite.internal.catalog.sql.AbstractCatalogQuery;
import org.apache.ignite.internal.catalog.sql.CreateCacheImpl;
import org.apache.ignite.internal.catalog.sql.CreateDataSource;
import org.apache.ignite.internal.catalog.sql.CreateTableImpl;
import org.apache.ignite.internal.catalog.sql.CreateZoneImpl;
import org.apache.ignite.internal.catalog.sql.DataSourceZoneId;
import org.apache.ignite.internal.catalog.sql.QueryContext;
import org.apache.ignite.internal.catalog.sql.QueryUtils;
import org.apache.ignite.internal.util.StringUtils;
import org.apache.ignite.sql.IgniteSql;
import org.apache.ignite.table.QualifiedName;
import org.apache.ignite.table.mapper.Mapper;

class CreateFromAnnotationsImpl
extends AbstractCatalogQuery<DataSourceZoneId> {
    private CreateZoneImpl createZone;
    private String zoneName;
    private CreateDataSource createDataSource;
    private QualifiedName name;
    private IndexType pkType;

    CreateFromAnnotationsImpl(IgniteSql sql) {
        super(sql);
    }

    @Override
    protected DataSourceZoneId result() {
        return new DataSourceZoneId(this.name, this.zoneName);
    }

    CreateFromAnnotationsImpl processKeyValueClassesAsTable(Class<?> keyClass, Class<?> valueClass) {
        if (keyClass.getAnnotation(Table.class) == null && valueClass.getAnnotation(Table.class) == null) {
            throw new IllegalArgumentException("Cannot find @Table annotation neither on " + keyClass.getName() + " nor on " + valueClass.getName() + ". At least one of these classes must be annotated in order to create a query object.");
        }
        this.processTableAnnotations(keyClass, true);
        this.processTableAnnotations(valueClass, false);
        return this;
    }

    CreateFromAnnotationsImpl processKeyValueClassesAsCache(Class<?> keyClass, Class<?> valueClass) {
        if (keyClass.getAnnotation(Cache.class) == null && valueClass.getAnnotation(Cache.class) == null) {
            throw new IllegalArgumentException("Cannot find @Cache annotation neither on " + keyClass.getName() + " nor on " + valueClass.getName() + ". At least one of these classes must be annotated in order to create a query object.");
        }
        this.processCacheAnnotations(keyClass, true);
        this.processCacheAnnotations(valueClass, false);
        return this;
    }

    CreateFromAnnotationsImpl processRecordClass(Class<?> recordCls) {
        if (recordCls.getAnnotation(Table.class) == null) {
            throw new IllegalArgumentException("Cannot find @Table annotation on " + recordCls.getName() + ". This class must be annotated with in order to create a query object.");
        }
        this.processTableAnnotations(recordCls, true);
        return this;
    }

    @Override
    protected void accept(QueryContext ctx) {
        if (this.createZone != null) {
            ctx.visit(this.createZone).formatSeparator();
        }
        if (this.createDataSource != null) {
            ctx.visit(this.createDataSource).formatSeparator();
        }
    }

    private void processTableAnnotations(Class<?> clazz, boolean isKeyClass) {
        Table table;
        if (this.createDataSource == null) {
            this.createDataSource = new CreateTableImpl(this.sql).ifNotExists();
        }
        if ((table = clazz.getAnnotation(Table.class)) != null) {
            this.process(StringUtils.nullOrBlank(table.value()) ? clazz.getSimpleName() : table.value(), table.schemaName(), table.zone(), table.indexes(), table.colocateBy(), table.primaryKeyType());
        }
        CreateFromAnnotationsImpl.processColumns(this.pkType, clazz, isKeyClass, this.createDataSource);
    }

    private void processCacheAnnotations(Class<?> clazz, boolean isKeyClass) {
        Cache cache;
        if (this.createDataSource == null) {
            this.createDataSource = new CreateCacheImpl(this.sql).ifNotExists();
        }
        if ((cache = clazz.getAnnotation(Cache.class)) != null) {
            this.process(StringUtils.nullOrBlank(cache.value()) ? clazz.getSimpleName() : cache.value(), cache.schemaName(), cache.zone(), cache.indexes(), cache.colocateBy(), cache.primaryKeyType());
        }
        CreateFromAnnotationsImpl.processColumns(this.pkType, clazz, isKeyClass, this.createDataSource);
    }

    private void process(String name, String schemaName, Zone zone, Index[] indices, ColumnRef[] colocateBy, IndexType primaryKeyType) {
        QualifiedName qualifiedName;
        this.name = qualifiedName = QualifiedName.of(schemaName, name);
        this.createDataSource.name(qualifiedName);
        this.processZone(zone);
        for (Index ix : indices) {
            List<ColumnSorted> indexColumns = QueryUtils.mapArrayToList(ix.columns(), col -> ColumnSorted.column(col.value(), col.sort()));
            this.createDataSource.addIndex(CreateFromAnnotationsImpl.toIndexName(ix), ix.type(), indexColumns);
        }
        if (colocateBy != null && colocateBy.length > 0) {
            this.createDataSource.colocateBy(QueryUtils.mapArrayToList(colocateBy, ColumnRef::value));
        }
        this.pkType = primaryKeyType;
    }

    private void processZone(Zone zone) {
        if (zone != null && !"Default".equalsIgnoreCase(zone.value())) {
            String zoneName;
            this.createZone = new CreateZoneImpl(this.sql).ifNotExists();
            this.zoneName = zoneName = zone.value();
            this.createDataSource.zone(zoneName);
            this.createZone.name(zoneName);
            this.createZone.storageProfiles(zone.storageProfiles());
            if (zone.partitions() > 0) {
                this.createZone.partitions(zone.partitions());
            }
            if (zone.replicas() > 0) {
                this.createZone.replicas(zone.replicas());
            }
            if (zone.quorumSize() > 0) {
                this.createZone.quorumSize(zone.quorumSize());
            }
            if (!zone.distributionAlgorithm().isEmpty()) {
                this.createZone.distributionAlgorithm(zone.distributionAlgorithm());
            }
            if (zone.dataNodesAutoAdjustScaleUp() > 0) {
                this.createZone.dataNodesAutoAdjustScaleUp(zone.dataNodesAutoAdjustScaleUp());
            }
            if (zone.dataNodesAutoAdjustScaleDown() > 0) {
                this.createZone.dataNodesAutoAdjustScaleDown(zone.dataNodesAutoAdjustScaleDown());
            }
            if (!zone.filter().isEmpty()) {
                this.createZone.filter(zone.filter());
            }
            if (!zone.consistencyMode().isEmpty()) {
                this.createZone.consistencyMode(zone.consistencyMode());
            }
        }
    }

    private void processTable() {
    }

    private void processCache(Cache cache) {
        for (Index ix : cache.indexes()) {
            List<ColumnSorted> indexColumns = QueryUtils.mapArrayToList(ix.columns(), col -> ColumnSorted.column(col.value(), col.sort()));
            String name = CreateFromAnnotationsImpl.toIndexName(ix);
            this.createDataSource.addIndex(name, ix.type(), indexColumns);
        }
        ColumnRef[] colocateBy = cache.colocateBy();
        if (colocateBy != null && colocateBy.length > 0) {
            this.createDataSource.colocateBy(QueryUtils.mapArrayToList(colocateBy, ColumnRef::value));
        }
        this.pkType = cache.primaryKeyType();
    }

    private static String toIndexName(Index ix) {
        if (!ix.value().isEmpty()) {
            return ix.value();
        }
        ArrayList<String> list = new ArrayList<String>();
        list.add("ix");
        for (ColumnRef columnRef : ix.columns()) {
            list.add(columnRef.value());
        }
        return String.join((CharSequence)"_", list);
    }

    static void processColumns(IndexType pkType, Class<?> clazz, boolean isKeyClass, CreateDataSource createDataSource) {
        ArrayList<ColumnSorted> idColumns = new ArrayList<ColumnSorted>();
        if (Mapper.nativelySupported(clazz)) {
            String columnName;
            String string = columnName = isKeyClass ? "id" : "val";
            if (isKeyClass) {
                idColumns.add(ColumnSorted.column(columnName));
            }
            createDataSource.addColumn(columnName, ColumnType.of(clazz));
        } else {
            CreateFromAnnotationsImpl.processColumnsInPojo(clazz, idColumns, createDataSource);
        }
        if (!idColumns.isEmpty()) {
            createDataSource.primaryKey(pkType, idColumns);
        }
    }

    private static void processColumnsInPojo(Class<?> clazz, List<ColumnSorted> idColumns, CreateDataSource createDataSource) {
        for (Field f : clazz.getDeclaredFields()) {
            String columnName;
            if (Modifier.isStatic(f.getModifiers()) || Modifier.isTransient(f.getModifiers())) continue;
            Column column = f.getAnnotation(Column.class);
            if (column == null) {
                columnName = f.getName();
                createDataSource.addColumn(columnName, ColumnType.of(f.getType()));
            } else {
                String string = columnName = column.value().isEmpty() ? f.getName() : column.value();
                if (!column.columnDefinition().isEmpty()) {
                    createDataSource.addColumn(columnName, column.columnDefinition());
                } else {
                    ColumnType<?> type = ColumnType.of(f.getType(), column.length(), column.precision(), column.scale(), column.nullable());
                    createDataSource.addColumn(columnName, type);
                }
            }
            Id id = f.getAnnotation(Id.class);
            if (id == null) continue;
            idColumns.add(ColumnSorted.column(columnName, id.value()));
        }
    }
}

