/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.app;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.internal.configuration.AuthenticationThreadPoolConfiguration;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.manager.ComponentContext;
import org.apache.ignite.internal.manager.IgniteComponent;
import org.apache.ignite.internal.metrics.MetricManager;
import org.apache.ignite.internal.metrics.MetricSource;
import org.apache.ignite.internal.metrics.sources.ThreadPoolMetricSource;
import org.apache.ignite.internal.thread.IgniteThreadFactory;
import org.apache.ignite.internal.thread.ThreadOperation;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.internal.util.IgniteUtils;

public class ThreadPoolsManager
implements IgniteComponent {
    private static final IgniteLogger LOG = Loggers.forClass(ThreadPoolsManager.class);
    private final ScheduledExecutorService tableIoExecutor;
    private final ExecutorService partitionOperationsExecutor;
    private final ScheduledExecutorService commonScheduler;
    private final ExecutorService authenticationExecutor;
    private final ScheduledExecutorService rebalanceScheduler;
    private final MetricManager metricManager;
    private final List<ThreadPoolMetricSource> metricSources;

    public ThreadPoolsManager(String nodeName, AuthenticationThreadPoolConfiguration authentication, MetricManager metricManager) {
        int cpus = Runtime.getRuntime().availableProcessors();
        this.tableIoExecutor = Executors.newScheduledThreadPool(Math.min(cpus * 3, 25), IgniteThreadFactory.create(nodeName, "tableManager-io", LOG, ThreadOperation.STORAGE_READ, ThreadOperation.STORAGE_WRITE));
        int partitionsOperationsThreads = Math.min(cpus * 3, 25);
        this.partitionOperationsExecutor = Executors.newFixedThreadPool(partitionsOperationsThreads, IgniteThreadFactory.create(nodeName, "partition-operations", LOG, ThreadOperation.STORAGE_READ, ThreadOperation.STORAGE_WRITE, ThreadOperation.TX_STATE_STORAGE_ACCESS, ThreadOperation.PROCESS_RAFT_REQ));
        this.commonScheduler = Executors.newSingleThreadScheduledExecutor(IgniteThreadFactory.create(nodeName, "common-scheduler", LOG, new ThreadOperation[0]));
        this.authenticationExecutor = ThreadPoolsManager.createAuthenticationExecutor(nodeName, authentication);
        this.rebalanceScheduler = Executors.newSingleThreadScheduledExecutor(IgniteThreadFactory.create(nodeName, "rebalance-scheduler", LOG, new ThreadOperation[0]));
        this.metricManager = metricManager;
        this.metricSources = new ArrayList<ThreadPoolMetricSource>();
        this.metricSources.add(new ThreadPoolMetricSource("thread.pools.partitions-executor", "The partitions-executor pool handles all the table related operations.", (ThreadPoolExecutor)this.partitionOperationsExecutor));
    }

    private static ExecutorService createAuthenticationExecutor(String nodeName, AuthenticationThreadPoolConfiguration authentication) {
        return new ThreadPoolExecutor(1, (int)((Integer)authentication.threadPoolSize().value()), (long)((Long)authentication.threadKeepAliveTime().value()), TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), IgniteThreadFactory.create(nodeName, "authentication", LOG, new ThreadOperation[0]));
    }

    @Override
    public CompletableFuture<Void> startAsync(ComponentContext componentContext) {
        this.metricSources.forEach(metricSource -> {
            this.metricManager.registerSource((MetricSource)metricSource);
            this.metricManager.enable((MetricSource)metricSource);
        });
        return CompletableFutures.nullCompletedFuture();
    }

    @Override
    public CompletableFuture<Void> stopAsync(ComponentContext componentContext) {
        IgniteUtils.shutdownAndAwaitTermination(this.tableIoExecutor, 10L, TimeUnit.SECONDS);
        IgniteUtils.shutdownAndAwaitTermination(this.partitionOperationsExecutor, 10L, TimeUnit.SECONDS);
        IgniteUtils.shutdownAndAwaitTermination(this.commonScheduler, 10L, TimeUnit.SECONDS);
        IgniteUtils.shutdownAndAwaitTermination(this.authenticationExecutor, 10L, TimeUnit.SECONDS);
        IgniteUtils.shutdownAndAwaitTermination(this.rebalanceScheduler, 10L, TimeUnit.SECONDS);
        return CompletableFutures.nullCompletedFuture();
    }

    public ScheduledExecutorService tableIoExecutor() {
        return this.tableIoExecutor;
    }

    public ExecutorService partitionOperationsExecutor() {
        return this.partitionOperationsExecutor;
    }

    public ScheduledExecutorService commonScheduler() {
        return this.commonScheduler;
    }

    public ExecutorService authenticationExecutor() {
        return this.authenticationExecutor;
    }

    public ScheduledExecutorService rebalanceScheduler() {
        return this.rebalanceScheduler;
    }
}

