/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.dr.optimized;

import java.io.Externalizable;
import java.io.IOException;
import java.io.NotActiveException;
import java.io.ObjectInputStream;
import java.io.ObjectInputValidation;
import java.io.ObjectStreamClass;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.apache.ignite.internal.util.GridUnsafe;
import org.gridgain.internal.dr.optimized.GridUnsafeDataInput;
import org.gridgain.internal.dr.optimized.OptimizedClassDescriptor;
import org.gridgain.internal.dr.optimized.OptimizedContext;
import org.jetbrains.annotations.Nullable;

public class OptimizedObjectInputStream
extends ObjectInputStream {
    private final GridUnsafeDataInput in;
    private final OptimizedContext ctx;
    private final HandleTable handles = new HandleTable(10);
    private Object curObj;
    private OptimizedClassDescriptor.ClassFields curFields;
    private Class<?> curCls;

    OptimizedObjectInputStream(OptimizedContext ctx, GridUnsafeDataInput in) throws IOException {
        this.in = in;
        this.ctx = ctx;
    }

    @Override
    public void close() throws IOException {
        this.reset();
    }

    @Override
    public synchronized void reset() throws IOException {
        this.in.reset();
        this.handles.clear();
        this.curObj = null;
        this.curFields = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    protected Object readObjectOverride() throws IOException, ClassNotFoundException {
        Object oldObj = this.curObj;
        OptimizedClassDescriptor.ClassFields oldFields = this.curFields;
        try {
            Object object = this.readObject0();
            return object;
        }
        finally {
            this.curObj = oldObj;
            this.curFields = oldFields;
        }
    }

    @Nullable
    private Object readObject0() throws ClassNotFoundException, IOException {
        this.curObj = null;
        this.curFields = null;
        byte ref = this.in.readByte();
        switch (ref) {
            case 0: {
                return null;
            }
            case -1: {
                return this.handles.lookup(this.readInt());
            }
            case -2: {
                throw new IllegalStateException("JDK marshaller is not supported.");
            }
            case 1: {
                return this.readByte();
            }
            case 2: {
                return this.readShort();
            }
            case 3: {
                return this.readInt();
            }
            case 4: {
                return this.readLong();
            }
            case 5: {
                return Float.valueOf(this.readFloat());
            }
            case 6: {
                return this.readDouble();
            }
            case 7: {
                return Character.valueOf(this.readChar());
            }
            case 8: {
                return this.readBoolean();
            }
            case 17: {
                return this.readArray(this.readClass());
            }
            case 9: {
                return this.readByteArray();
            }
            case 10: {
                return this.readShortArray();
            }
            case 11: {
                return this.readIntArray();
            }
            case 12: {
                return this.readLongArray();
            }
            case 13: {
                return this.readFloatArray();
            }
            case 14: {
                return this.readDoubleArray();
            }
            case 15: {
                return this.readCharArray();
            }
            case 16: {
                return this.readBooleanArray();
            }
            case 18: {
                return this.readString();
            }
            case 19: {
                return this.readUuid();
            }
            case 27: {
                return this.readDate();
            }
            case 101: 
            case 102: {
                OptimizedClassDescriptor desc;
                int typeId = this.readInt();
                if (typeId == 0) {
                    String className = this.readUTF();
                    desc = this.ctx.classDescriptor(className);
                } else {
                    desc = this.ctx.classDescriptor(typeId);
                }
                this.curCls = desc.describedClass();
                try {
                    return desc.read(this);
                }
                catch (IOException e) {
                    throw new IOException("Failed to deserialize object [typeName=" + desc.describedClass().getName() + "]", e);
                }
            }
        }
        StringBuilder msg = new StringBuilder("Unexpected error occurred during unmarshalling");
        if (this.curCls != null) {
            msg.append(" of an instance of the class: ").append(this.curCls.getName());
        }
        msg.append(". Check that all nodes are running the same version of Ignite and that all nodes have GridOptimizedMarshaller configured with identical optimized classes lists, if any (see setClassNames and setClassNamesPath methods). If your serialized classes implement java.io.Externalizable interface, verify that serialization logic is correct.");
        throw new IOException(msg.toString());
    }

    byte[] readByteArray() throws IOException {
        byte[] arr = this.in.readByteArray(this.in.readInt());
        this.handles.assign(arr);
        return arr;
    }

    short[] readShortArray() throws IOException {
        short[] arr = this.in.readShortArray(this.in.readInt());
        this.handles.assign(arr);
        return arr;
    }

    int[] readIntArray() throws IOException {
        int[] arr = this.in.readIntArray(this.in.readInt());
        this.handles.assign(arr);
        return arr;
    }

    long[] readLongArray() throws IOException {
        long[] arr = this.in.readLongArray(this.in.readInt());
        this.handles.assign(arr);
        return arr;
    }

    float[] readFloatArray() throws IOException {
        float[] arr = this.in.readFloatArray(this.in.readInt());
        this.handles.assign(arr);
        return arr;
    }

    double[] readDoubleArray() throws IOException {
        double[] arr = this.in.readDoubleArray(this.in.readInt());
        this.handles.assign(arr);
        return arr;
    }

    char[] readCharArray() throws IOException {
        char[] arr = this.in.readCharArray(this.in.readInt());
        this.handles.assign(arr);
        return arr;
    }

    boolean[] readBooleanArray() throws IOException {
        boolean[] arr = this.in.readBooleanArray(this.in.readInt());
        this.handles.assign(arr);
        return arr;
    }

    private String readString() throws IOException {
        String str = this.in.readUTF();
        this.handles.assign(str);
        return str;
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.in.readFully(b);
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        this.in.readFully(b, off, len);
    }

    @Override
    public int skipBytes(int n) throws IOException {
        return this.in.skipBytes(n);
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.in.readBoolean();
    }

    @Override
    public byte readByte() throws IOException {
        return this.in.readByte();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return this.in.readUnsignedByte();
    }

    @Override
    public short readShort() throws IOException {
        return this.in.readShort();
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return this.in.readUnsignedShort();
    }

    @Override
    public char readChar() throws IOException {
        return this.in.readChar();
    }

    @Override
    public int readInt() throws IOException {
        return this.in.readInt();
    }

    @Override
    public long readLong() throws IOException {
        return this.in.readLong();
    }

    @Override
    public float readFloat() throws IOException {
        return this.in.readFloat();
    }

    @Override
    public double readDouble() throws IOException {
        return this.in.readDouble();
    }

    @Override
    public int read() throws IOException {
        return this.in.readByte();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.in.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.in.read(b, off, len);
    }

    @Override
    public String readLine() throws IOException {
        return this.in.readLine();
    }

    @Override
    public String readUTF() throws IOException {
        return this.in.readUTF();
    }

    @Override
    public Object readUnshared() throws IOException, ClassNotFoundException {
        return this.readObject();
    }

    @Override
    public void defaultReadObject() throws IOException, ClassNotFoundException {
        if (this.curObj == null) {
            throw new NotActiveException("Not in readObject() call.");
        }
        this.restoreObjectFields(this.curObj, this.curFields);
    }

    @Override
    public ObjectInputStream.GetField readFields() throws IOException, ClassNotFoundException {
        if (this.curObj == null) {
            throw new NotActiveException("Not in readObject() call.");
        }
        return new GetFieldImpl(this);
    }

    @Override
    public void registerValidation(ObjectInputValidation obj, int pri) {
    }

    @Override
    public int available() {
        return -1;
    }

    private Class<?> readClass() throws ClassNotFoundException, IOException {
        OptimizedClassDescriptor desc;
        int typeId = this.readInt();
        OptimizedClassDescriptor optimizedClassDescriptor = desc = typeId == 0 ? this.ctx.classDescriptor(this.readUTF()) : this.ctx.classDescriptor(typeId);
        if (desc == null) {
            throw new ClassNotFoundException("Can't found class for type ID: " + typeId);
        }
        return desc.describedClass();
    }

    <T> T[] readArray(Class<T> compType) throws ClassNotFoundException, IOException {
        int len = this.in.readInt();
        Object[] arr = (Object[])Array.newInstance(compType, len);
        this.handles.assign(arr);
        for (int i = 0; i < len; ++i) {
            arr[i] = this.readObject();
        }
        return arr;
    }

    private UUID readUuid() throws IOException {
        UUID uuid = new UUID(this.readLong(), this.readLong());
        this.handles.assign(uuid);
        return uuid;
    }

    private Date readDate() throws IOException {
        Date date = new Date(this.readLong());
        this.handles.assign(date);
        return date;
    }

    private void restoreObjectFields(Object obj, OptimizedClassDescriptor.ClassFields fieldOffs) throws ClassNotFoundException, IOException {
        block13: for (int i = 0; i < fieldOffs.size(); ++i) {
            OptimizedClassDescriptor.FieldInfo t = fieldOffs.get(i);
            try {
                switch (t.type()) {
                    case BYTE: {
                        byte resByte = this.readByte();
                        if (t.field() == null) continue block13;
                        GridUnsafe.putByteField((Object)obj, (long)t.offset(), (byte)resByte);
                        break;
                    }
                    case SHORT: {
                        short resShort = this.readShort();
                        if (t.field() == null) continue block13;
                        GridUnsafe.putShortField((Object)obj, (long)t.offset(), (short)resShort);
                        break;
                    }
                    case INT: {
                        int resInt = this.readInt();
                        if (t.field() == null) continue block13;
                        GridUnsafe.putIntField((Object)obj, (long)t.offset(), (int)resInt);
                        break;
                    }
                    case LONG: {
                        long resLong = this.readLong();
                        if (t.field() == null) continue block13;
                        GridUnsafe.putLongField((Object)obj, (long)t.offset(), (long)resLong);
                        break;
                    }
                    case FLOAT: {
                        float resFloat = this.readFloat();
                        if (t.field() == null) continue block13;
                        GridUnsafe.putFloatField((Object)obj, (long)t.offset(), (float)resFloat);
                        break;
                    }
                    case DOUBLE: {
                        double resDouble = this.readDouble();
                        if (t.field() == null) continue block13;
                        GridUnsafe.putDoubleField((Object)obj, (long)t.offset(), (double)resDouble);
                        break;
                    }
                    case CHAR: {
                        char resChar = this.readChar();
                        if (t.field() == null) continue block13;
                        GridUnsafe.putCharField((Object)obj, (long)t.offset(), (char)resChar);
                        break;
                    }
                    case BOOLEAN: {
                        boolean resBoolean = this.readBoolean();
                        if (t.field() == null) continue block13;
                        GridUnsafe.putBooleanField((Object)obj, (long)t.offset(), (boolean)resBoolean);
                        break;
                    }
                    case OTHER: {
                        Object resObject = this.readObject();
                        if (t.field() == null) continue block13;
                        GridUnsafe.putObjectField((Object)obj, (long)t.offset(), (Object)resObject);
                        break;
                    }
                    default: {
                        assert (false);
                        continue block13;
                    }
                }
                continue;
            }
            catch (IOException e) {
                throw new IOException("Failed to deserialize field [name=" + t.name() + "]", e);
            }
        }
    }

    Object readExternalizable(Constructor<?> constructor, Method readResolveMtd) throws ClassNotFoundException, IOException {
        Object obj;
        try {
            obj = constructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new IOException(e);
        }
        int handle = this.handles.assign(obj);
        Externalizable extObj = (Externalizable)obj;
        extObj.readExternal(this);
        if (readResolveMtd != null) {
            try {
                obj = readResolveMtd.invoke(obj, new Object[0]);
                this.handles.set(handle, obj);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new IOException(e);
            }
        }
        return obj;
    }

    Object readSerializable(Class<?> cls, List<Method> mtds, Method readResolveMtd, OptimizedClassDescriptor.Fields fields) throws ClassNotFoundException, IOException {
        Object obj;
        try {
            obj = GridUnsafe.allocateInstance(cls);
        }
        catch (InstantiationException e) {
            throw new IOException(e);
        }
        int handle = this.handles.assign(obj);
        for (int i = 0; i < mtds.size(); ++i) {
            Method mtd = mtds.get(i);
            if (mtd != null) {
                this.curObj = obj;
                this.curFields = fields.fields(i);
                try {
                    mtd.invoke(obj, this);
                    continue;
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new IOException(e);
                }
            }
            this.restoreObjectFields(obj, fields.fields(i));
        }
        if (readResolveMtd != null) {
            try {
                obj = readResolveMtd.invoke(obj, new Object[0]);
                this.handles.set(handle, obj);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new IOException(e);
            }
        }
        return obj;
    }

    private static class HandleTable {
        private Object[] entries;
        private int size;

        HandleTable(int initCap) {
            this.entries = new Object[initCap];
        }

        int assign(Object obj) {
            if (this.size >= this.entries.length) {
                this.grow();
            }
            this.entries[this.size] = obj;
            return this.size++;
        }

        void set(int handle, Object obj) {
            this.entries[handle] = obj;
        }

        Object lookup(int handle) {
            return this.entries[handle];
        }

        void clear() {
            Arrays.fill(this.entries, 0, this.size, null);
            this.size = 0;
        }

        private void grow() {
            int newCap = (this.entries.length << 1) + 1;
            Object[] newEntries = new Object[newCap];
            System.arraycopy(this.entries, 0, newEntries, 0, this.size);
            this.entries = newEntries;
        }
    }

    private static class GetFieldImpl
    extends ObjectInputStream.GetField {
        private final OptimizedClassDescriptor.ClassFields fieldInfo;
        private final Object[] objs;

        private GetFieldImpl(OptimizedObjectInputStream in) throws IOException, ClassNotFoundException {
            this.fieldInfo = in.curFields;
            this.objs = new Object[this.fieldInfo.size()];
            for (int i = 0; i < this.fieldInfo.size(); ++i) {
                OptimizedClassDescriptor.FieldInfo t = this.fieldInfo.get(i);
                Object obj = null;
                switch (t.type()) {
                    case BYTE: {
                        obj = in.readByte();
                        break;
                    }
                    case SHORT: {
                        obj = in.readShort();
                        break;
                    }
                    case INT: {
                        obj = in.readInt();
                        break;
                    }
                    case LONG: {
                        obj = in.readLong();
                        break;
                    }
                    case FLOAT: {
                        obj = Float.valueOf(in.readFloat());
                        break;
                    }
                    case DOUBLE: {
                        obj = in.readDouble();
                        break;
                    }
                    case CHAR: {
                        obj = Character.valueOf(in.readChar());
                        break;
                    }
                    case BOOLEAN: {
                        obj = in.readBoolean();
                        break;
                    }
                    case OTHER: {
                        obj = in.readObject();
                        break;
                    }
                    default: {
                        assert (false);
                        break;
                    }
                }
                this.objs[i] = obj;
            }
        }

        @Override
        public ObjectStreamClass getObjectStreamClass() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean defaulted(String name) throws IOException {
            return this.objs[this.fieldInfo.getIndex(name)] == null;
        }

        @Override
        public boolean get(String name, boolean dflt) throws IOException {
            return this.value(name, dflt);
        }

        @Override
        public byte get(String name, byte dflt) throws IOException {
            return this.value(name, dflt);
        }

        @Override
        public char get(String name, char dflt) throws IOException {
            return this.value(name, Character.valueOf(dflt)).charValue();
        }

        @Override
        public short get(String name, short dflt) throws IOException {
            return this.value(name, dflt);
        }

        @Override
        public int get(String name, int dflt) throws IOException {
            return this.value(name, dflt);
        }

        @Override
        public long get(String name, long dflt) throws IOException {
            return this.value(name, dflt);
        }

        @Override
        public float get(String name, float dflt) throws IOException {
            return this.value(name, Float.valueOf(dflt)).floatValue();
        }

        @Override
        public double get(String name, double dflt) throws IOException {
            return this.value(name, dflt);
        }

        @Override
        public Object get(String name, Object dflt) throws IOException {
            return this.value(name, dflt);
        }

        private <T> T value(String name, T dflt) {
            Object result = this.objs[this.fieldInfo.getIndex(name)];
            return (T)(result != null ? result : dflt);
        }
    }
}

