/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.dr.mapping;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.ignite.configuration.NamedListView;
import org.apache.ignite.internal.lang.IgniteStringFormatter;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.table.QualifiedName;
import org.gridgain.dr.configuration.CacheFieldMappingView;
import org.gridgain.dr.configuration.CacheMappingView;
import org.gridgain.dr.configuration.CacheValueFieldMappingView;
import org.gridgain.internal.dr.mapping.CacheMappingException;
import org.jetbrains.annotations.Nullable;

public final class CacheMapping {
    private final String cacheName;
    private final QualifiedName tableName;
    private final Map<String, String> fields;
    private final Map<String, String> keyFields;
    private final Map<String, String> valueFields;
    private final Set<String> ignoreValueFields;

    private CacheMapping(String cacheName, QualifiedName tableName, Map<String, String> fields, Map<String, String> keyFields, Map<String, String> valueFields, Set<String> ignoreValueFields) {
        this.cacheName = cacheName;
        this.tableName = tableName;
        this.fields = fields;
        this.keyFields = keyFields;
        this.valueFields = valueFields;
        this.ignoreValueFields = ignoreValueFields;
    }

    public String cacheName() {
        return this.cacheName;
    }

    public QualifiedName tableName() {
        return this.tableName;
    }

    @Nullable
    public String columnName(String fieldName, boolean key) {
        if (this.hasSeparateMapping()) {
            return key ? this.keyFields.get(fieldName) : this.valueFields.get(fieldName);
        }
        return this.fields.get(fieldName);
    }

    public Set<String> ignoreFields() {
        return this.ignoreValueFields;
    }

    private boolean hasSeparateMapping() {
        return !this.keyFields.isEmpty() || !this.valueFields.isEmpty();
    }

    public String toString() {
        if (this.hasSeparateMapping()) {
            return S.toString(CacheMapping.class, (Object)this, (String)"cacheName", (Object)this.cacheName, (String)"tableName", (Object)this.tableName, (String)"keyFields", this.keyFields, (String)"valueFields", this.valueFields, (String)"ignoreValueFields", this.ignoreValueFields);
        }
        return S.toString(CacheMapping.class, (Object)this, (String)"cacheName", (Object)this.cacheName, (String)"tableName", (Object)this.tableName, (String)"fields", this.fields);
    }

    public static Map<String, CacheMapping> fromConfig(NamedListView<? extends CacheMappingView> cacheMappingList) {
        List cacheNames = cacheMappingList.namedListKeys();
        HashMap caches = IgniteUtils.newHashMap((int)cacheNames.size());
        for (String cacheName : cacheNames) {
            Object fieldMapping;
            CacheMappingView cacheMapping = (CacheMappingView)cacheMappingList.get(cacheName);
            String tableName = cacheMapping.table() != null ? cacheMapping.table() : cacheName;
            Builder builder = new Builder(cacheName).tableName(tableName);
            NamedListView<? extends CacheFieldMappingView> fields = cacheMapping.fields();
            NamedListView<? extends CacheFieldMappingView> keyFields = cacheMapping.keyFields();
            NamedListView<? extends CacheValueFieldMappingView> valueFields = cacheMapping.valueFields();
            List fieldNames = fields.namedListKeys();
            List keyFieldNames = keyFields.namedListKeys();
            List valueFieldNames = valueFields.namedListKeys();
            if (fieldNames.isEmpty() && keyFieldNames.isEmpty() && valueFieldNames.isEmpty()) {
                String message = IgniteStringFormatter.format((String)"Cache '{}'. No field mapping configuration", (Object[])new Object[]{cacheName});
                throw new CacheMappingException(message);
            }
            for (String fieldName : fieldNames) {
                fieldMapping = (CacheFieldMappingView)fields.get(fieldName);
                builder.addField(fieldName, fieldMapping.column());
            }
            for (String fieldName : keyFieldNames) {
                fieldMapping = (CacheFieldMappingView)keyFields.get(fieldName);
                builder.addField(fieldName, true, fieldMapping.column());
            }
            for (String fieldName : valueFieldNames) {
                fieldMapping = (CacheValueFieldMappingView)valueFields.get(fieldName);
                if (fieldMapping.ignore()) {
                    builder.ignoreField(fieldName);
                    continue;
                }
                String column = fieldMapping.column();
                if (column == null) {
                    String message = IgniteStringFormatter.format((String)"Cache '{}'. No column name for field: '{}'", (Object[])new Object[]{cacheName, fieldName});
                    throw new CacheMappingException(message);
                }
                builder.addField(fieldName, false, column);
            }
            caches.put(cacheName, builder.build());
        }
        return caches;
    }

    public static class Builder {
        private final String cacheName;
        private final Map<String, String> fields = new HashMap<String, String>();
        private final Map<String, String> keyFields = new HashMap<String, String>();
        private final Map<String, String> valueFields = new HashMap<String, String>();
        private final Set<String> ignoreFields = new HashSet<String>();
        @Nullable
        private QualifiedName tableName;

        public Builder(String cacheName) {
            this.cacheName = Objects.requireNonNull(cacheName, "cacheName");
        }

        public Builder tableName(String tableName) {
            this.tableName = QualifiedName.parse((String)tableName);
            return this;
        }

        public Builder tableName(QualifiedName tableName) {
            this.tableName = tableName;
            return this;
        }

        public Builder addField(String fieldName, String columnName) {
            Objects.requireNonNull(fieldName, "fieldName");
            Objects.requireNonNull(columnName, "columnName");
            this.fields.put(fieldName, columnName);
            return this;
        }

        public Builder addField(String fieldName, boolean key, String columnName) {
            Objects.requireNonNull(fieldName, "fieldName");
            Objects.requireNonNull(columnName, "columnName");
            if (key) {
                this.keyFields.put(fieldName, columnName);
            } else {
                this.valueFields.put(fieldName, columnName);
            }
            return this;
        }

        public Builder ignoreField(String fieldName) {
            this.ignoreFields.add(fieldName);
            return this;
        }

        public CacheMapping build() {
            if (!(this.fields.isEmpty() || this.keyFields.isEmpty() && this.valueFields.isEmpty())) {
                String message = IgniteStringFormatter.format((String)"Cache: '{}'. Both fields mapping and key / value fields mapping can not specified at the same time", (Object[])new Object[]{this.cacheName});
                throw new CacheMappingException(message);
            }
            if (this.tableName == null) {
                this.tableName = QualifiedName.parse((String)this.cacheName);
            }
            if (!this.fields.isEmpty()) {
                Map<String, String> field2Column = this.createMapping(this.fields);
                return new CacheMapping(this.cacheName, this.tableName, field2Column, Map.of(), Map.of(), Set.of());
            }
            Map<String, String> keyField2Column = this.createMapping(this.keyFields);
            Map<String, String> valueField2Column = this.createMapping(this.valueFields);
            Map column2Key = keyField2Column.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Function.identity()));
            for (Map.Entry<String, String> v : valueField2Column.entrySet()) {
                String valueFieldName = v.getKey();
                String valueColumnName = v.getValue();
                Map.Entry existingColumn = (Map.Entry)column2Key.get(valueColumnName);
                if (existingColumn == null) continue;
                String message = IgniteStringFormatter.format((String)"Cache: '{}'. Can not map key field '{}' and value field '{}' to the same column column '{}'", (Object[])new Object[]{this.cacheName, existingColumn.getKey(), valueFieldName, existingColumn.getValue()});
                throw new CacheMappingException(message);
            }
            return new CacheMapping(this.cacheName, this.tableName, Map.of(), keyField2Column, valueField2Column, this.ignoreFields);
        }

        private Map<String, String> createMapping(Map<String, String> src) {
            HashMap field2Column = IgniteUtils.newHashMap((int)src.size());
            HashMap column2Field = IgniteUtils.newHashMap((int)src.size());
            for (Map.Entry<String, String> e : src.entrySet()) {
                String fieldName = e.getKey();
                String columnName = field2Column.computeIfAbsent(fieldName, k -> (String)e.getValue());
                String existingMapping = column2Field.put(columnName, fieldName);
                if (existingMapping == null) continue;
                String message = IgniteStringFormatter.format((String)"Cache: '{}'. Can not map field '{}' to column '{}', mapping to this column from field '{}' already exists", (Object[])new Object[]{this.cacheName, fieldName, columnName, existingMapping});
                throw new CacheMappingException(message);
            }
            return field2Column;
        }
    }
}

