/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.rocksdb.flush;

import java.util.concurrent.CompletableFuture;
import org.apache.ignite.internal.components.LogSyncer;
import org.apache.ignite.internal.failure.FailureContext;
import org.apache.ignite.internal.failure.FailureProcessor;
import org.apache.ignite.internal.rocksdb.LoggingRocksDbFlushListener;
import org.apache.ignite.internal.rocksdb.flush.RocksDbFlusher;
import org.apache.ignite.internal.util.CompletableFutures;
import org.rocksdb.FlushJobInfo;
import org.rocksdb.RocksDB;

class RocksDbFlushListener
extends LoggingRocksDbFlushListener {
    private final RocksDbFlusher flusher;
    private final LogSyncer logSyncer;
    private final FailureProcessor failureProcessor;
    private volatile CompletableFuture<?> lastFlushProcessed = CompletableFutures.nullCompletedFuture();

    RocksDbFlushListener(String name, String nodeName, RocksDbFlusher flusher, LogSyncer logSyncer, FailureProcessor failureProcessor) {
        super(name, nodeName);
        this.flusher = flusher;
        this.logSyncer = logSyncer;
        this.failureProcessor = failureProcessor;
    }

    @Override
    protected void onFlushBeginCallback(RocksDB db, FlushJobInfo flushJobInfo) {
        this.lastFlushProcessed.join();
        try {
            this.logSyncer.sync();
        }
        catch (Exception e) {
            this.failureProcessor.process(new FailureContext(e, "Couldn't sync RocksDB WAL on flush begin"));
        }
    }

    @Override
    protected void onFlushCompletedCallback(RocksDB db, FlushJobInfo flushJobInfo) {
        this.lastFlushProcessed = this.flusher.onFlushCompleted();
    }

    @Override
    public void onFlushCompleted(RocksDB db, FlushJobInfo flushJobInfo) {
        super.onFlushCompleted(db, flushJobInfo);
        this.lastFlushProcessed.whenCompleteAsync((o, throwable) -> this.flusher.completeFutures(flushJobInfo.getLargestSeqno()), this.flusher.threadPool);
    }
}

