/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.restart;

import java.util.concurrent.CompletableFuture;
import org.apache.ignite.Ignite;
import org.apache.ignite.cache.Cache;
import org.apache.ignite.catalog.IgniteCatalog;
import org.apache.ignite.catalog.definitions.CacheDefinition;
import org.apache.ignite.catalog.definitions.TableDefinition;
import org.apache.ignite.catalog.definitions.ZoneDefinition;
import org.apache.ignite.internal.restart.IgniteAttachmentLock;
import org.apache.ignite.internal.restart.RestartProofTable;
import org.apache.ignite.internal.wrapper.Wrapper;
import org.apache.ignite.internal.wrapper.Wrappers;
import org.apache.ignite.table.QualifiedName;
import org.apache.ignite.table.Table;

class RestartProofIgniteCatalog
implements IgniteCatalog,
Wrapper {
    private final IgniteAttachmentLock attachmentLock;

    RestartProofIgniteCatalog(IgniteAttachmentLock attachmentLock) {
        this.attachmentLock = attachmentLock;
    }

    @Override
    public CompletableFuture<Table> createTableAsync(Class<?> recordClass) {
        return this.attachmentLock.attachedAsync(ignite -> ignite.catalog().createTableAsync(recordClass).thenApply(table -> this.wrapTable((Table)table, (Ignite)ignite)));
    }

    @Override
    public CompletableFuture<Table> createTableAsync(Class<?> keyClass, Class<?> valueClass) {
        return this.attachmentLock.attachedAsync(ignite -> ignite.catalog().createTableAsync(keyClass, valueClass).thenApply(table -> this.wrapTable((Table)table, (Ignite)ignite)));
    }

    @Override
    public CompletableFuture<Table> createTableAsync(TableDefinition definition) {
        return this.attachmentLock.attachedAsync(ignite -> ignite.catalog().createTableAsync(definition).thenApply(table -> this.wrapTable((Table)table, (Ignite)ignite)));
    }

    @Override
    public Table createTable(Class<?> recordClass) {
        return this.attachmentLock.attached(ignite -> {
            Table table = ignite.catalog().createTable(recordClass);
            return this.wrapTable(table, (Ignite)ignite);
        });
    }

    @Override
    public Table createTable(Class<?> keyClass, Class<?> valueClass) {
        return this.attachmentLock.attached(ignite -> {
            Table table = ignite.catalog().createTable(keyClass, valueClass);
            return this.wrapTable(table, (Ignite)ignite);
        });
    }

    @Override
    public Table createTable(TableDefinition definition) {
        return this.attachmentLock.attached(ignite -> {
            Table table = ignite.catalog().createTable(definition);
            return this.wrapTable(table, (Ignite)ignite);
        });
    }

    @Override
    public CompletableFuture<TableDefinition> tableDefinitionAsync(QualifiedName tableName) {
        return this.attachmentLock.attachedAsync(ignite -> ignite.catalog().tableDefinitionAsync(tableName));
    }

    @Override
    public TableDefinition tableDefinition(QualifiedName tableName) {
        return this.attachmentLock.attached(ignite -> ignite.catalog().tableDefinition(tableName));
    }

    private Table wrapTable(Table table, Ignite ignite) {
        return new RestartProofTable(this.attachmentLock, ignite, RestartProofTable.tableId(table));
    }

    @Override
    public CompletableFuture<Void> createZoneAsync(ZoneDefinition definition) {
        return this.attachmentLock.attachedAsync(ignite -> ignite.catalog().createZoneAsync(definition));
    }

    @Override
    public void createZone(ZoneDefinition definition) {
        this.attachmentLock.consumeAttached(ignite -> ignite.catalog().createZone(definition));
    }

    @Override
    public CompletableFuture<ZoneDefinition> zoneDefinitionAsync(String zoneName) {
        return this.attachmentLock.attachedAsync(ignite -> ignite.catalog().zoneDefinitionAsync(zoneName));
    }

    @Override
    public ZoneDefinition zoneDefinition(String zoneName) {
        return this.attachmentLock.attached(ignite -> ignite.catalog().zoneDefinition(zoneName));
    }

    @Override
    public CompletableFuture<Void> dropTableAsync(TableDefinition definition) {
        return this.attachmentLock.attachedAsync(ignite -> ignite.catalog().dropTableAsync(definition));
    }

    @Override
    public CompletableFuture<Void> dropTableAsync(QualifiedName name) {
        return this.attachmentLock.attachedAsync(ignite -> ignite.catalog().dropTableAsync(name));
    }

    @Override
    public void dropTable(TableDefinition definition) {
        this.attachmentLock.consumeAttached(ignite -> ignite.catalog().dropTable(definition));
    }

    @Override
    public void dropTable(QualifiedName name) {
        this.attachmentLock.consumeAttached(ignite -> ignite.catalog().dropTable(name));
    }

    @Override
    public CompletableFuture<Void> dropZoneAsync(ZoneDefinition definition) {
        return this.attachmentLock.attachedAsync(ignite -> ignite.catalog().dropZoneAsync(definition));
    }

    @Override
    public CompletableFuture<Void> dropZoneAsync(String name) {
        return this.attachmentLock.attachedAsync(ignite -> ignite.catalog().dropZoneAsync(name));
    }

    @Override
    public void dropZone(ZoneDefinition definition) {
        this.attachmentLock.consumeAttached(ignite -> ignite.catalog().dropZone(definition));
    }

    @Override
    public void dropZone(String name) {
        this.attachmentLock.consumeAttached(ignite -> ignite.catalog().dropZone(name));
    }

    @Override
    public Cache createCache(Class<?> keyClass, Class<?> valueClass) {
        return this.attachmentLock.attached(ignite -> ignite.catalog().createCache(keyClass, valueClass));
    }

    @Override
    public Cache createCache(CacheDefinition definition) {
        return this.attachmentLock.attached(ignite -> ignite.catalog().createCache(definition));
    }

    @Override
    public CompletableFuture<Cache> createCacheAsync(Class<?> keyClass, Class<?> valueClass) {
        return this.attachmentLock.attachedAsync(ignite -> ignite.catalog().createCacheAsync(keyClass, valueClass));
    }

    @Override
    public CompletableFuture<Cache> createCacheAsync(CacheDefinition definition) {
        return this.attachmentLock.attachedAsync(ignite -> ignite.catalog().createCacheAsync(definition));
    }

    @Override
    public CacheDefinition cacheDefinition(QualifiedName name) {
        return this.attachmentLock.attached(ignite -> ignite.catalog().cacheDefinition(name));
    }

    @Override
    public CompletableFuture<CacheDefinition> cacheDefinitionAsync(QualifiedName name) {
        return this.attachmentLock.attachedAsync(ignite -> ignite.catalog().cacheDefinitionAsync(name));
    }

    @Override
    public void dropCache(CacheDefinition definition) {
        this.attachmentLock.consumeAttached(ignite -> ignite.catalog().dropCache(definition));
    }

    @Override
    public void dropCache(QualifiedName name) {
        this.attachmentLock.consumeAttached(ignite -> ignite.catalog().dropCache(name));
    }

    @Override
    public CompletableFuture<Void> dropCacheAsync(CacheDefinition definition) {
        return this.attachmentLock.attachedAsync(ignite -> ignite.catalog().dropCacheAsync(definition));
    }

    @Override
    public CompletableFuture<Void> dropCacheAsync(QualifiedName name) {
        return this.attachmentLock.attachedAsync(ignite -> ignite.catalog().dropCacheAsync(name));
    }

    @Override
    public <T> T unwrap(Class<T> classToUnwrap) {
        return (T)this.attachmentLock.attached(ignite -> Wrappers.unwrap(ignite.catalog(), classToUnwrap));
    }
}

