/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.replicator;

import java.util.regex.Pattern;
import org.apache.ignite.internal.replicator.PartitionGroupId;

public class ZonePartitionId
implements PartitionGroupId {
    public static final ZonePartitionId NOT_EXISTING = new ZonePartitionId(Integer.MAX_VALUE, Integer.MAX_VALUE);
    private static final Pattern DELIMITER_PATTERN = Pattern.compile("_part_");
    private final int zoneId;
    private final int partId;

    public ZonePartitionId(int zoneId, int partId) {
        this.zoneId = zoneId;
        this.partId = partId;
    }

    public int zoneId() {
        return this.zoneId;
    }

    @Override
    public int objectId() {
        return this.zoneId;
    }

    @Override
    public int partitionId() {
        return this.partId;
    }

    public static ZonePartitionId fromString(String str) {
        String[] parts = DELIMITER_PATTERN.split(str);
        return new ZonePartitionId(Integer.parseInt(parts[0]), Integer.parseInt(parts[1]));
    }

    public String toString() {
        return this.zoneId + "_part_" + this.partId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ZonePartitionId that = (ZonePartitionId)o;
        return this.zoneId == that.zoneId && this.partId == that.partId;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.zoneId;
        result = 31 * result + this.partId;
        return result;
    }

    public boolean isAbsent() {
        return ZonePartitionId.isAbsent(this.zoneId);
    }

    public static boolean isAbsent(int zoneId) {
        return zoneId == NOT_EXISTING.zoneId();
    }
}

