/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network.serialization.marshal;

import java.io.Externalizable;
import java.io.IOException;
import org.apache.ignite.internal.network.serialization.ClassDescriptor;
import org.apache.ignite.internal.network.serialization.marshal.DefaultFieldsReaderWriter;
import org.apache.ignite.internal.network.serialization.marshal.InstantiationException;
import org.apache.ignite.internal.network.serialization.marshal.MarshallingContext;
import org.apache.ignite.internal.network.serialization.marshal.NoArgConstructorInstantiation;
import org.apache.ignite.internal.network.serialization.marshal.SchemaMismatchException;
import org.apache.ignite.internal.network.serialization.marshal.SchemaMismatchHandlers;
import org.apache.ignite.internal.network.serialization.marshal.TypedValueReader;
import org.apache.ignite.internal.network.serialization.marshal.TypedValueWriter;
import org.apache.ignite.internal.network.serialization.marshal.UnmarshalException;
import org.apache.ignite.internal.network.serialization.marshal.UnmarshallingContext;
import org.apache.ignite.internal.network.serialization.marshal.UosObjectInputStream;
import org.apache.ignite.internal.network.serialization.marshal.UosObjectOutputStream;
import org.apache.ignite.internal.util.io.IgniteDataInput;
import org.apache.ignite.internal.util.io.IgniteDataOutput;
import org.apache.ignite.internal.util.io.IgniteUnsafeDataInput;

class ExternalizableMarshaller {
    private final TypedValueReader valueReader;
    private final TypedValueReader unsharedReader;
    private final TypedValueWriter valueWriter;
    private final TypedValueWriter unsharedWriter;
    private final DefaultFieldsReaderWriter defaultFieldsReaderWriter;
    private final SchemaMismatchHandlers schemaMismatchHandlers;
    private final NoArgConstructorInstantiation instantiation = new NoArgConstructorInstantiation();

    ExternalizableMarshaller(TypedValueWriter typedValueWriter, TypedValueWriter unsharedWriter, TypedValueReader valueReader, TypedValueReader unsharedReader, DefaultFieldsReaderWriter defaultFieldsReaderWriter, SchemaMismatchHandlers schemaMismatchHandlers) {
        this.valueWriter = typedValueWriter;
        this.unsharedWriter = unsharedWriter;
        this.valueReader = valueReader;
        this.unsharedReader = unsharedReader;
        this.defaultFieldsReaderWriter = defaultFieldsReaderWriter;
        this.schemaMismatchHandlers = schemaMismatchHandlers;
    }

    void writeExternalizable(Externalizable externalizable, ClassDescriptor descriptor, IgniteDataOutput output, MarshallingContext context) throws IOException {
        this.externalizeTo(externalizable, output, context);
        context.addUsedDescriptor(descriptor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void externalizeTo(Externalizable externalizable, IgniteDataOutput output, MarshallingContext context) throws IOException {
        UosObjectOutputStream oos = context.objectOutputStream(output, this.valueWriter, this.unsharedWriter, this.defaultFieldsReaderWriter);
        UosObjectOutputStream.UosPutField oldPut = oos.replaceCurrentPutFieldWithNull();
        context.endWritingWithWriteObject();
        try {
            this.writeWithLength(externalizable, oos);
        }
        finally {
            oos.restoreCurrentPutFieldTo(oldPut);
        }
    }

    private void writeWithLength(Externalizable externalizable, UosObjectOutputStream oos) throws IOException {
        int offsetBefore = oos.memoryBufferOffset();
        this.writeLengthPlaceholder(oos);
        externalizable.writeExternal(oos);
        oos.flush();
        int externalDataLength = oos.memoryBufferOffset() - offsetBefore - 4;
        oos.writeIntAtOffset(offsetBefore, externalDataLength);
    }

    private void writeLengthPlaceholder(UosObjectOutputStream oos) throws IOException {
        oos.writeInt(0);
    }

    Object preInstantiateExternalizable(ClassDescriptor descriptor) throws UnmarshalException {
        try {
            return this.instantiation.newInstance(descriptor.localClass());
        }
        catch (InstantiationException e) {
            throw new UnmarshalException("Cannot instantiate " + descriptor.className(), (Throwable)e);
        }
    }

    void fillFromRemotelyExternalizable(IgniteDataInput input, Object object, UnmarshallingContext context) throws UnmarshalException, IOException {
        if (object instanceof Externalizable) {
            this.fillExternalizableFrom(input, (Externalizable)object, context);
        } else {
            this.fireExternalizableIgnored(object, input, context);
        }
    }

    private <T extends Externalizable> void fillExternalizableFrom(IgniteDataInput input, T object, UnmarshallingContext context) throws IOException, UnmarshalException {
        UosObjectInputStream ois = context.objectInputStream(input, this.valueReader, this.unsharedReader, this.defaultFieldsReaderWriter);
        UosObjectInputStream.UosGetField oldGet = ois.replaceCurrentGetFieldWithNull();
        context.endReadingWithReadObject();
        try {
            this.readWithLength(object, ois);
        }
        catch (ClassNotFoundException e) {
            throw new UnmarshalException("Cannot unmarshal due to a missing class", (Throwable)e);
        }
        finally {
            ois.restoreCurrentGetFieldTo(oldGet);
        }
    }

    private <T extends Externalizable> void readWithLength(T object, UosObjectInputStream ois) throws IOException, ClassNotFoundException {
        this.skipExternalDataLength(ois);
        object.readExternal(ois);
    }

    private void skipExternalDataLength(UosObjectInputStream ois) throws IOException {
        ois.readInt();
    }

    private void fireExternalizableIgnored(Object object, IgniteDataInput input, UnmarshallingContext context) throws SchemaMismatchException, IOException {
        int externalDataLength = input.readInt();
        byte[] externalDataBytes = input.readByteArray(externalDataLength);
        IgniteUnsafeDataInput externalDataInput = new IgniteUnsafeDataInput(externalDataBytes);
        try (UosObjectInputStream oos = new UosObjectInputStream(externalDataInput, this.valueReader, this.unsharedReader, this.defaultFieldsReaderWriter, context);){
            this.schemaMismatchHandlers.onExternalizableIgnored(object, oos);
        }
    }
}

