/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network.serialization;

import java.lang.reflect.Field;
import java.util.Objects;
import org.apache.ignite.internal.network.serialization.FieldAccessor;
import org.apache.ignite.internal.util.GridUnsafe;

class UnsafeFieldAccessor
implements FieldAccessor {
    private final Field field;
    private final Class<?> fieldType;
    private final long fieldOffset;

    UnsafeFieldAccessor(Field field) {
        Objects.requireNonNull(field, "field is null");
        this.field = field;
        this.fieldType = field.getType();
        this.fieldOffset = GridUnsafe.objectFieldOffset(field);
    }

    @Override
    public Object getObject(Object target) {
        assert (!this.fieldType.isPrimitive()) : this.field.getDeclaringClass() + "#" + this.field.getName() + " is primitive!";
        return GridUnsafe.getObjectField(target, this.fieldOffset);
    }

    @Override
    public void setObject(Object target, Object fieldValue) {
        assert (!this.fieldType.isPrimitive()) : this.field.getDeclaringClass() + "#" + this.field.getName() + " is primitive!";
        GridUnsafe.putObjectField(target, this.fieldOffset, fieldValue);
    }

    @Override
    public byte getByte(Object target) {
        assert (this.fieldType == Byte.TYPE) : this.field.getDeclaringClass() + "#" + this.field.getName() + " is not byte";
        return GridUnsafe.getByteField(target, this.fieldOffset);
    }

    @Override
    public void setByte(Object target, byte fieldValue) {
        assert (this.fieldType == Byte.TYPE) : this.field.getDeclaringClass() + "#" + this.field.getName() + " is not byte";
        GridUnsafe.putByteField(target, this.fieldOffset, fieldValue);
    }

    @Override
    public short getShort(Object target) {
        assert (this.fieldType == Short.TYPE) : this.field.getDeclaringClass() + "#" + this.field.getName() + " is not short";
        return GridUnsafe.getShortField(target, this.fieldOffset);
    }

    @Override
    public void setShort(Object target, short fieldValue) {
        assert (this.fieldType == Short.TYPE) : this.field.getDeclaringClass() + "#" + this.field.getName() + " is not short";
        GridUnsafe.putShortField(target, this.fieldOffset, fieldValue);
    }

    @Override
    public int getInt(Object target) {
        assert (this.fieldType == Integer.TYPE) : this.field.getDeclaringClass() + "#" + this.field.getName() + " is not int";
        return GridUnsafe.getIntField(target, this.fieldOffset);
    }

    @Override
    public void setInt(Object target, int fieldValue) {
        assert (this.fieldType == Integer.TYPE) : this.field.getDeclaringClass() + "#" + this.field.getName() + " is not int";
        GridUnsafe.putIntField(target, this.fieldOffset, fieldValue);
    }

    @Override
    public long getLong(Object target) {
        assert (this.fieldType == Long.TYPE) : this.field.getDeclaringClass() + "#" + this.field.getName() + " is not long";
        return GridUnsafe.getLongField(target, this.fieldOffset);
    }

    @Override
    public void setLong(Object target, long fieldValue) {
        assert (this.fieldType == Long.TYPE) : this.field.getDeclaringClass() + "#" + this.field.getName() + " is not long";
        GridUnsafe.putLongField(target, this.fieldOffset, fieldValue);
    }

    @Override
    public float getFloat(Object target) {
        assert (this.fieldType == Float.TYPE) : this.field.getDeclaringClass() + "#" + this.field.getName() + " is not float";
        return GridUnsafe.getFloatField(target, this.fieldOffset);
    }

    @Override
    public void setFloat(Object target, float fieldValue) {
        assert (this.fieldType == Float.TYPE) : this.field.getDeclaringClass() + "#" + this.field.getName() + " is not float";
        GridUnsafe.putFloatField(target, this.fieldOffset, fieldValue);
    }

    @Override
    public double getDouble(Object target) {
        assert (this.fieldType == Double.TYPE) : this.field.getDeclaringClass() + "#" + this.field.getName() + " is not double";
        return GridUnsafe.getDoubleField(target, this.fieldOffset);
    }

    @Override
    public void setDouble(Object target, double fieldValue) {
        assert (this.fieldType == Double.TYPE) : this.field.getDeclaringClass() + "#" + this.field.getName() + " is not double";
        GridUnsafe.putDoubleField(target, this.fieldOffset, fieldValue);
    }

    @Override
    public char getChar(Object target) {
        assert (this.fieldType == Character.TYPE) : this.field.getDeclaringClass() + "#" + this.field.getName() + " is not char";
        return GridUnsafe.getCharField(target, this.fieldOffset);
    }

    @Override
    public void setChar(Object target, char fieldValue) {
        assert (this.fieldType == Character.TYPE) : this.field.getDeclaringClass() + "#" + this.field.getName() + " is not char";
        GridUnsafe.putCharField(target, this.fieldOffset, fieldValue);
    }

    @Override
    public boolean getBoolean(Object target) {
        assert (this.fieldType == Boolean.TYPE) : this.field.getDeclaringClass() + "#" + this.field.getName() + " is not boolean";
        return GridUnsafe.getBooleanField(target, this.fieldOffset);
    }

    @Override
    public void setBoolean(Object target, boolean fieldValue) {
        assert (this.fieldType == Boolean.TYPE) : this.field.getDeclaringClass() + "#" + this.field.getName() + " is not boolean";
        GridUnsafe.putBooleanField(target, this.fieldOffset, fieldValue);
    }
}

