/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network.serialization;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.lang.reflect.Proxy;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.internal.lang.IgniteUuid;
import org.apache.ignite.internal.network.serialization.ClassDescriptor;
import org.apache.ignite.internal.network.serialization.Null;
import org.apache.ignite.internal.network.serialization.Serialization;
import org.apache.ignite.internal.network.serialization.SerializationType;

public enum BuiltInType {
    BYTE(0, Byte.TYPE),
    BYTE_BOXED(1, Byte.class),
    SHORT(2, Short.TYPE),
    SHORT_BOXED(3, Short.class),
    INT(4, Integer.TYPE),
    INT_BOXED(5, Integer.class),
    FLOAT(6, Float.TYPE),
    FLOAT_BOXED(7, Float.class),
    LONG(8, Long.TYPE),
    LONG_BOXED(9, Long.class),
    DOUBLE(10, Double.TYPE),
    DOUBLE_BOXED(11, Double.class),
    BOOLEAN(12, Boolean.TYPE),
    BOOLEAN_BOXED(13, Boolean.class),
    CHAR(14, Character.TYPE),
    CHAR_BOXED(15, Character.class),
    BARE_OBJECT(16, Object.class),
    STRING(17, String.class),
    UUID(18, UUID.class),
    IGNITE_UUID(19, IgniteUuid.class),
    DATE(20, Date.class),
    BYTE_ARRAY(21, byte[].class),
    SHORT_ARRAY(22, short[].class),
    INT_ARRAY(23, int[].class),
    FLOAT_ARRAY(24, float[].class),
    LONG_ARRAY(25, long[].class),
    DOUBLE_ARRAY(26, double[].class),
    BOOLEAN_ARRAY(27, boolean[].class),
    CHAR_ARRAY(28, char[].class),
    DECIMAL(29, BigDecimal.class),
    ARRAY_LIST(30, ArrayList.class),
    LINKED_LIST(31, LinkedList.class),
    HASH_SET(32, HashSet.class),
    LINKED_HASH_SET(33, LinkedHashSet.class),
    SINGLETON_LIST(34, Collections.singletonList(null).getClass()),
    HASH_MAP(35, HashMap.class),
    LINKED_HASH_MAP(36, LinkedHashMap.class),
    BIT_SET(37, BitSet.class),
    NULL(38, Null.class),
    REFERENCE(39, ReferencePlaceholder.class),
    CLASS(40, Class.class),
    PROXY(41, Proxy.class),
    STRING_LATIN1(42, StringLatin1Placeholder.class);

    private final int descriptorId;
    private final Class<?> clazz;
    private static final Int2ObjectMap<BuiltInType> descriptorIdToValues;
    private static final Map<Class<?>, BuiltInType> classToValues;

    private BuiltInType(int descriptorId, Class<?> clazz) {
        this.descriptorId = descriptorId;
        this.clazz = clazz;
    }

    public static BuiltInType findByDescriptorId(int descriptorId) {
        BuiltInType type = (BuiltInType)((Object)descriptorIdToValues.get(descriptorId));
        if (type == null) {
            throw new IllegalArgumentException("No build-in with ID " + descriptorId + " is supported");
        }
        return type;
    }

    public int descriptorId() {
        return this.descriptorId;
    }

    public Class<?> clazz() {
        return this.clazz;
    }

    public ClassDescriptor asClassDescriptor() {
        ClassDescriptor componentTypeDescriptor = null;
        if (this.clazz.isArray()) {
            BuiltInType componentType = classToValues.get(this.clazz.getComponentType());
            if (componentType == null) {
                throw new IllegalStateException("Component of a built-in array type is not built-in: " + this.clazz);
            }
            componentTypeDescriptor = componentType.asClassDescriptor();
        }
        return ClassDescriptor.forLocal(this.clazz, this.descriptorId, null, componentTypeDescriptor, Collections.emptyList(), new Serialization(SerializationType.BUILTIN));
    }

    static {
        Cloneable map = new Int2ObjectOpenHashMap<BuiltInType>();
        for (BuiltInType type : BuiltInType.values()) {
            map.put(type.descriptorId, type);
        }
        descriptorIdToValues = Int2ObjectMaps.unmodifiable(map);
        map = new HashMap();
        for (BuiltInType type : BuiltInType.values()) {
            map.put(type.clazz, type);
        }
        classToValues = Map.copyOf(map);
    }

    private static class ReferencePlaceholder {
        private ReferencePlaceholder() {
        }
    }

    private static class StringLatin1Placeholder {
        private StringLatin1Placeholder() {
        }
    }
}

