/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network.recovery.message;

import java.util.Objects;
import org.apache.ignite.internal.network.recovery.message.AcknowledgementMessage;
import org.apache.ignite.internal.network.recovery.message.AcknowledgementMessageBuilder;
import org.apache.ignite.internal.network.recovery.message.AcknowledgementMessageSerializer;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;

public class AcknowledgementMessageImpl
implements AcknowledgementMessage,
Cloneable {
    public static final short GROUP_TYPE = 1;
    public static final short TYPE = 7;
    @IgniteToStringInclude
    private final long receivedMessages;

    private AcknowledgementMessageImpl(long receivedMessages) {
        this.receivedMessages = receivedMessages;
    }

    @Override
    public long receivedMessages() {
        return this.receivedMessages;
    }

    public MessageSerializer serializer() {
        return AcknowledgementMessageSerializer.INSTANCE;
    }

    @Override
    public short groupType() {
        return 1;
    }

    public String toString() {
        return S.toString(AcknowledgementMessageImpl.class, this);
    }

    @Override
    public short messageType() {
        return 7;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        AcknowledgementMessageImpl otherMessage = (AcknowledgementMessageImpl)other;
        return this.receivedMessages == otherMessage.receivedMessages;
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.receivedMessages);
        return result;
    }

    @Override
    public AcknowledgementMessageImpl clone() {
        try {
            return (AcknowledgementMessageImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static AcknowledgementMessageBuilder builder() {
        return new Builder();
    }

    private static class Builder
    implements AcknowledgementMessageBuilder {
        private long receivedMessages;

        private Builder() {
        }

        @Override
        public AcknowledgementMessageBuilder receivedMessages(long receivedMessages) {
            this.receivedMessages = receivedMessages;
            return this;
        }

        @Override
        public long receivedMessages() {
            return this.receivedMessages;
        }

        @Override
        public AcknowledgementMessage build() {
            return new AcknowledgementMessageImpl(this.receivedMessages);
        }

        @Override
        public AcknowledgementMessage buildDeserialized() {
            return new AcknowledgementMessageImpl(this.receivedMessages);
        }
    }
}

