/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.network.NodeFinder;
import org.apache.ignite.internal.util.ArrayUtils;
import org.apache.ignite.network.NetworkAddress;

public class StaticNodeFinder
implements NodeFinder {
    private static final IgniteLogger LOG = Loggers.forClass(StaticNodeFinder.class);
    private final List<NetworkAddress> addresses;

    public StaticNodeFinder(List<NetworkAddress> addresses) {
        this.addresses = addresses;
    }

    @Override
    public Collection<NetworkAddress> findNodes() {
        return this.addresses.parallelStream().flatMap(originalAddress -> Arrays.stream(StaticNodeFinder.resolveAll(originalAddress.host())).map(ip -> new NetworkAddress((String)ip, originalAddress.port()))).collect(Collectors.toList());
    }

    @Override
    public void start() {
    }

    private static String[] resolveAll(String host) {
        InetAddress[] inetAddresses;
        try {
            inetAddresses = InetAddress.getAllByName(host);
        }
        catch (UnknownHostException e) {
            LOG.warn("Cannot resolve {}", host);
            return ArrayUtils.STRING_EMPTY_ARRAY;
        }
        String[] addresses = new String[inetAddresses.length];
        for (int i = 0; i < inetAddresses.length; ++i) {
            InetAddress inetAddress = inetAddresses[i];
            if (inetAddress.isLoopbackAddress()) {
                return new String[]{inetAddress.getHostAddress()};
            }
            addresses[i] = inetAddress.getHostAddress();
        }
        return addresses;
    }
}

