/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.configuration;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.configuration.ConfigurationReadOnlyException;
import org.apache.ignite.configuration.ConfigurationValue;
import org.apache.ignite.configuration.RootKey;
import org.apache.ignite.internal.configuration.ConfigurationNode;
import org.apache.ignite.internal.configuration.DynamicConfigurationChanger;
import org.apache.ignite.internal.configuration.direct.DirectPropertyProxy;
import org.apache.ignite.internal.configuration.direct.DirectValueProxy;
import org.apache.ignite.internal.configuration.direct.KeyPathNode;
import org.apache.ignite.internal.configuration.tree.ConfigurationSource;
import org.apache.ignite.internal.configuration.tree.ConstructableTreeNode;
import org.apache.ignite.internal.configuration.tree.InnerNode;
import org.apache.ignite.internal.configuration.util.ConfigurationUtil;
import org.apache.ignite.internal.tostring.S;

public class DynamicProperty<T extends Serializable>
extends ConfigurationNode<T>
implements ConfigurationValue<T> {
    private final boolean readOnly;
    private final boolean injectedNameField;
    private final boolean internalIdField;

    public DynamicProperty(List<String> prefix, String key, RootKey<?, ?, ?> rootKey, DynamicConfigurationChanger changer, boolean listenOnly, boolean readOnly) {
        super("<injected_name>".equals(key) || "<internal_id>".equals(key) ? prefix : ConfigurationUtil.appendKey(prefix, key), key, rootKey, changer, listenOnly);
        this.readOnly = readOnly;
        this.injectedNameField = "<injected_name>".equals(key);
        this.internalIdField = "<internal_id>".equals(key);
    }

    @Override
    public T value() {
        if (this.injectedNameField) {
            return (T)((InnerNode)this.refreshValue()).getInjectedNameFieldValue();
        }
        if (this.internalIdField) {
            return (T)((InnerNode)this.refreshValue()).internalId();
        }
        return (T)((Serializable)this.refreshValue());
    }

    @Override
    public CompletableFuture<Void> update(T newValue) {
        Objects.requireNonNull(newValue, "Configuration value cannot be null.");
        if (this.listenOnly) {
            throw this.listenOnlyException();
        }
        if (this.readOnly) {
            throw new ConfigurationReadOnlyException("Read only mode: " + this.keys);
        }
        assert (this.keys instanceof RandomAccess);
        assert (!this.keys.isEmpty());
        ConfigurationSource src = new ConfigurationSource(){
            private int level = 0;
            final /* synthetic */ Serializable val$newValue;
            {
                this.val$newValue = serializable;
            }

            @Override
            public void descend(ConstructableTreeNode node) {
                assert (this.level < DynamicProperty.this.keys.size());
                node.construct((String)DynamicProperty.this.keys.get(this.level++), this, true);
            }

            @Override
            public <T> T unwrap(Class<T> clazz) {
                assert (this.level == DynamicProperty.this.keys.size());
                assert (clazz.isInstance(this.val$newValue));
                return clazz.cast(this.val$newValue);
            }

            @Override
            public void reset() {
                this.level = 0;
            }
        };
        return this.changer.change(src);
    }

    @Override
    public String key() {
        return this.key;
    }

    @Override
    public DirectPropertyProxy<T> directProxy() {
        if (this.injectedNameField || this.internalIdField) {
            return new DirectValueProxy(ConfigurationUtil.appendKey(this.keyPath(), new KeyPathNode(this.key)), this.changer);
        }
        return new DirectValueProxy(this.keyPath(), this.changer);
    }

    public String toString() {
        return S.toString(DynamicProperty.class, this, "key", (Object)this.key, "value", this.value());
    }
}

