/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.configuration;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.apache.ignite.configuration.ConfigurationProperty;
import org.apache.ignite.configuration.ConfigurationTree;
import org.apache.ignite.configuration.RootKey;
import org.apache.ignite.internal.configuration.ConfigurationNode;
import org.apache.ignite.internal.configuration.DynamicConfigurationChanger;
import org.apache.ignite.internal.configuration.tree.ConfigurationSource;
import org.apache.ignite.internal.configuration.tree.ConstructableTreeNode;
import org.apache.ignite.internal.configuration.tree.InnerNode;
import org.apache.ignite.internal.configuration.util.ConfigurationUtil;
import org.jetbrains.annotations.Nullable;

public abstract class DynamicConfiguration<VIEWT, CHANGET extends VIEWT>
extends ConfigurationNode<VIEWT>
implements ConfigurationTree<VIEWT, CHANGET> {
    protected volatile Map<String, ConfigurationProperty<?>> members = new LinkedHashMap();

    public DynamicConfiguration(List<String> prefix, String key, RootKey<?, ?, ?> rootKey, DynamicConfigurationChanger changer, boolean listenOnly) {
        super(ConfigurationUtil.appendKey(prefix, key), key, rootKey, changer, listenOnly);
    }

    protected final <P extends ConfigurationProperty<?>> void add(P member) {
        this.addMember(this.members, member);
    }

    @Override
    public final CompletableFuture<Void> change(final Consumer<CHANGET> change) {
        Objects.requireNonNull(change, "Configuration consumer cannot be null.");
        if (this.listenOnly) {
            throw this.listenOnlyException();
        }
        assert (this.keys instanceof RandomAccess);
        ConfigurationSource src = new ConfigurationSource(){
            private int level = 0;

            @Override
            public void descend(ConstructableTreeNode node) {
                if (this.level == DynamicConfiguration.this.keys.size()) {
                    if (node instanceof InnerNode) {
                        change.accept(((InnerNode)node).specificNode());
                    } else {
                        change.accept(node);
                    }
                } else {
                    node.construct((String)DynamicConfiguration.this.keys.get(this.level++), this, true);
                }
            }

            @Override
            public void reset() {
                this.level = 0;
            }
        };
        return this.changer.change(src);
    }

    @Override
    public final String key() {
        return this.key;
    }

    @Override
    public VIEWT value() {
        return (VIEWT)((InnerNode)this.refreshValue()).specificNode();
    }

    @Override
    protected void beforeRefreshValue(VIEWT newValue, @Nullable VIEWT oldValue) {
        if (oldValue == null || ((InnerNode)oldValue).schemaType() != ((InnerNode)newValue).schemaType()) {
            LinkedHashMap newMembers = new LinkedHashMap(this.members);
            if (oldValue != null) {
                this.removeMembers(oldValue, newMembers);
            }
            this.addMembers(newValue, newMembers);
            this.members = newMembers;
        }
    }

    public Map<String, ConfigurationProperty<?>> members() {
        if (!this.listenOnly) {
            this.refreshValue();
        }
        return Collections.unmodifiableMap(this.members);
    }

    public Map<String, ConfigurationProperty<?>> touchMembers() {
        return this.members();
    }

    public abstract Class<?> configType();

    public Class<?> @Nullable [] extensionConfigTypes() {
        return null;
    }

    @Nullable
    public Class<?> polymorphicInstanceConfigType() {
        return null;
    }

    public ConfigurationTree<VIEWT, CHANGET> specificConfigTree() {
        return this;
    }

    protected void removeMembers(VIEWT oldValue, Map<String, ConfigurationProperty<?>> members) {
    }

    protected void addMembers(VIEWT newValue, Map<String, ConfigurationProperty<?>> members) {
    }

    protected <P extends ConfigurationProperty<?>> void addMember(Map<String, ConfigurationProperty<?>> members, P member) {
        members.put(member.key(), member);
    }

    protected <P extends ConfigurationProperty<?>> void removeMember(Map<String, ConfigurationProperty<?>> members, P member) {
        members.remove(member.key());
    }
}

