/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.bytecode;

import com.facebook.presto.bytecode.BytecodeUtils;
import com.facebook.presto.bytecode.ParameterizedType;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class AnnotationDefinition {
    private static final Set<Class<?>> ALLOWED_TYPES = Set.of(Byte.class, Character.class, Double.class, Float.class, Integer.class, Long.class, Short.class, Void.class, String.class, Class.class, ParameterizedType.class, AnnotationDefinition.class, Enum.class);
    private final ParameterizedType type;
    private final Map<String, Object> values = new LinkedHashMap<String, Object>();

    public AnnotationDefinition(Class<?> type) {
        this.type = ParameterizedType.type(type);
    }

    public AnnotationDefinition(ParameterizedType type) {
        this.type = type;
    }

    public AnnotationDefinition setValue(String name, Byte value) {
        return this.setValueInternal(name, value);
    }

    public AnnotationDefinition setValue(String name, Boolean value) {
        return this.setValueInternal(name, value);
    }

    public AnnotationDefinition setValue(String name, Character value) {
        return this.setValueInternal(name, value);
    }

    public AnnotationDefinition setValue(String name, Short value) {
        return this.setValueInternal(name, value);
    }

    public AnnotationDefinition setValue(String name, Integer value) {
        return this.setValueInternal(name, value);
    }

    public AnnotationDefinition setValue(String name, Long value) {
        return this.setValueInternal(name, value);
    }

    public AnnotationDefinition setValue(String name, Float value) {
        return this.setValueInternal(name, value);
    }

    public AnnotationDefinition setValue(String name, Double value) {
        return this.setValueInternal(name, value);
    }

    public AnnotationDefinition setValue(String name, String value) {
        return this.setValueInternal(name, value);
    }

    public AnnotationDefinition setValue(String name, Class<?> value) {
        return this.setValueInternal(name, value);
    }

    public AnnotationDefinition setValue(String name, ParameterizedType value) {
        return this.setValueInternal(name, value);
    }

    public AnnotationDefinition setValue(String name, AnnotationDefinition value) {
        return this.setValueInternal(name, value);
    }

    public AnnotationDefinition setValue(String name, Enum<?> value) {
        return this.setValueInternal(name, value);
    }

    public AnnotationDefinition setValue(String name, List<?> value) {
        return this.setValueInternal(name, value);
    }

    private AnnotationDefinition setValueInternal(String name, Object value) {
        Objects.requireNonNull(name, "name is null");
        Objects.requireNonNull(value, "value is null");
        AnnotationDefinition.isValidType(value);
        this.values.put(name, value);
        return this;
    }

    public ParameterizedType getType() {
        return this.type;
    }

    public Map<String, Object> getValues() {
        return Collections.unmodifiableMap(this.values);
    }

    private static void isValidType(Object value) {
        if (value instanceof List) {
            for (Object v : (List)value) {
                BytecodeUtils.checkArgument(ALLOWED_TYPES.contains(v.getClass()), "List contains invalid type %s", v.getClass());
                if (!(v instanceof List)) continue;
                AnnotationDefinition.isValidType(value);
            }
        } else {
            BytecodeUtils.checkArgument(ALLOWED_TYPES.contains(value.getClass()), "Invalid value type %s", value.getClass());
        }
    }

    public void visitClassAnnotation(ClassVisitor visitor) {
        AnnotationVisitor annotationVisitor = visitor.visitAnnotation(this.type.getType(), true);
        this.visit(annotationVisitor);
        annotationVisitor.visitEnd();
    }

    public void visitFieldAnnotation(FieldVisitor visitor) {
        AnnotationVisitor annotationVisitor = visitor.visitAnnotation(this.type.getType(), true);
        this.visit(annotationVisitor);
        annotationVisitor.visitEnd();
    }

    public void visitMethodAnnotation(MethodVisitor visitor) {
        AnnotationVisitor annotationVisitor = visitor.visitAnnotation(this.type.getType(), true);
        this.visit(annotationVisitor);
        annotationVisitor.visitEnd();
    }

    public void visitParameterAnnotation(int parameterIndex, MethodVisitor visitor) {
        AnnotationVisitor annotationVisitor = visitor.visitParameterAnnotation(parameterIndex, this.type.getType(), true);
        this.visit(annotationVisitor);
        annotationVisitor.visitEnd();
    }

    private void visit(AnnotationVisitor visitor) {
        for (Map.Entry<String, Object> entry : this.values.entrySet()) {
            String name = entry.getKey();
            Object value = entry.getValue();
            AnnotationDefinition.visit(visitor, name, value);
        }
    }

    private static void visit(AnnotationVisitor visitor, String name, Object value) {
        if (value instanceof AnnotationDefinition) {
            AnnotationDefinition annotation = (AnnotationDefinition)value;
            AnnotationVisitor annotationVisitor = visitor.visitAnnotation(name, annotation.type.getType());
            annotation.visit(annotationVisitor);
        } else if (value instanceof Enum) {
            Enum enumConstant = (Enum)value;
            visitor.visitEnum(name, ParameterizedType.type(enumConstant.getDeclaringClass()).getClassName(), enumConstant.name());
        } else if (value instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)value;
            visitor.visit(name, Type.getType(parameterizedType.getType()));
        } else if (value instanceof Class) {
            Class clazz = (Class)value;
            visitor.visit(name, Type.getType(clazz));
        } else if (value instanceof List) {
            AnnotationVisitor arrayVisitor = visitor.visitArray(name);
            for (Object element : (List)value) {
                AnnotationDefinition.visit(arrayVisitor, null, element);
            }
            arrayVisitor.visitEnd();
        } else {
            visitor.visit(name, value);
        }
    }
}

