/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.dr.optimized;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import org.gridgain.internal.dr.optimized.OptimizedFieldType;

final class OptimizedMarshallerUtils {
    static boolean isLambda(Class<?> objectClass) {
        return !objectClass.isPrimitive() && !objectClass.isArray() && objectClass.isSynthetic() && !objectClass.isAnonymousClass() && !objectClass.isLocalClass() && OptimizedMarshallerUtils.classCannotBeLoadedByName(objectClass);
    }

    private static boolean classCannotBeLoadedByName(Class<?> objectClass) {
        try {
            Class.forName(objectClass.getName());
            return false;
        }
        catch (ClassNotFoundException e) {
            return true;
        }
    }

    static short computeSerialVersionUid(Class cls, List<Field> fields) throws IOException {
        MessageDigest md;
        if (Serializable.class.isAssignableFrom(cls) && !Enum.class.isAssignableFrom(cls)) {
            try {
                int mod;
                Field field = cls.getDeclaredField("serialVersionUID");
                if (field.getType() == Long.TYPE && Modifier.isStatic(mod = field.getModifiers()) && Modifier.isFinal(mod)) {
                    field.setAccessible(true);
                    return (short)field.getLong(null);
                }
            }
            catch (NoSuchFieldException field) {
            }
            catch (IllegalAccessException e) {
                throw new IOException(e);
            }
        }
        try {
            md = MessageDigest.getInstance("SHA");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException("Failed to get digest for SHA.", e);
        }
        md.update(cls.getName().getBytes(StandardCharsets.UTF_8));
        for (int i = 0; i < fields.size(); ++i) {
            Field f = fields.get(i);
            md.update(f.getName().getBytes(StandardCharsets.UTF_8));
            md.update(f.getType().getName().getBytes(StandardCharsets.UTF_8));
        }
        byte[] hashBytes = md.digest();
        long hash = 0L;
        for (int i = Math.min(hashBytes.length, 8) - 1; i >= 0; --i) {
            hash = hash << 8 | (long)(hashBytes[i] & 0xFF);
        }
        return (short)hash;
    }

    static OptimizedFieldType fieldType(Class<?> cls) {
        OptimizedFieldType type = cls == Byte.TYPE ? OptimizedFieldType.BYTE : (cls == Short.TYPE ? OptimizedFieldType.SHORT : (cls == Integer.TYPE ? OptimizedFieldType.INT : (cls == Long.TYPE ? OptimizedFieldType.LONG : (cls == Float.TYPE ? OptimizedFieldType.FLOAT : (cls == Double.TYPE ? OptimizedFieldType.DOUBLE : (cls == Character.TYPE ? OptimizedFieldType.CHAR : (cls == Boolean.TYPE ? OptimizedFieldType.BOOLEAN : OptimizedFieldType.OTHER)))))));
        return type;
    }

    private OptimizedMarshallerUtils() {
    }
}

