/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.dr.binary;

import it.unimi.dsi.fastutil.ints.IntList;
import java.util.Arrays;
import java.util.List;
import org.apache.ignite.internal.tostring.S;

public class BinarySchema {
    public static final int ORDER_NOT_FOUND = -1;
    private static final int MAP_MIN_SIZE = 32;
    private static final int MAP_EMPTY = 0;
    private final int schemaId;
    private int[] ids;
    private int[] idToOrderData;
    private int idToOrderMask;

    public BinarySchema(int schemaId, IntList fieldIds) {
        assert (fieldIds != null);
        this.schemaId = schemaId;
        this.initialize((List<Integer>)fieldIds);
    }

    public int schemaId() {
        return this.schemaId;
    }

    public int[] fieldIds() {
        return this.ids;
    }

    public int fieldId(int order) {
        return order < this.ids.length ? this.ids[order] : 0;
    }

    public int orderById(int id) {
        if (this.idToOrderData == null) {
            return -1;
        }
        int idx = (id & this.idToOrderMask) << 1;
        int curId = this.idToOrderData[idx];
        if (id == curId) {
            return this.idToOrderData[idx + 1];
        }
        if (curId == 0) {
            return -1;
        }
        for (int i = 2; i < this.idToOrderData.length; i += 2) {
            int newIdx = (idx + i) % this.idToOrderData.length;
            assert (newIdx < this.idToOrderData.length - 1);
            curId = this.idToOrderData[newIdx];
            if (id == curId) {
                return this.idToOrderData[newIdx + 1];
            }
            if (curId != 0) continue;
            return -1;
        }
        return -1;
    }

    public int hashCode() {
        return this.schemaId;
    }

    public boolean equals(Object o) {
        return o instanceof BinarySchema && this.schemaId == ((BinarySchema)o).schemaId;
    }

    public String toString() {
        return S.toString(BinarySchema.class, (Object)this, (String)"ids", (Object)Arrays.toString(this.ids), (String)"idToOrderData", (Object)Arrays.toString(this.idToOrderData));
    }

    private static ParseResult parse(int[] vals, int size) {
        int mask = BinarySchema.maskForPowerOfTwo(size);
        int totalSize = size * 2;
        int[] data = new int[totalSize];
        int collisions = 0;
        for (int order = 0; order < vals.length; ++order) {
            int id = vals[order];
            assert (id != 0);
            int idIdx = (id & mask) << 1;
            if (data[idIdx] == 0) {
                data[idIdx] = id;
                data[idIdx + 1] = order;
                continue;
            }
            ++collisions;
            boolean placeFound = false;
            for (int i = 2; i < totalSize; i += 2) {
                int newIdIdx = (idIdx + i) % totalSize;
                if (data[newIdIdx] != 0) continue;
                data[newIdIdx] = id;
                data[newIdIdx + 1] = order;
                placeFound = true;
                break;
            }
            assert (placeFound) : "Should always have a place for entry!";
        }
        return new ParseResult(data, collisions);
    }

    private static int nextPowerOfTwo(int val) {
        int res;
        for (res = 1; res < val; res <<= 1) {
        }
        if (res < 0) {
            throw new IllegalArgumentException("Value is too big to find positive pow2: " + val);
        }
        return res;
    }

    private static int maskForPowerOfTwo(int val) {
        int mask = 0;
        for (int comparand = 1; comparand < val; comparand <<= 1) {
            mask |= comparand;
        }
        return mask;
    }

    private void initialize(List<Integer> fieldIds) {
        this.ids = new int[fieldIds.size()];
        for (int i = 0; i < fieldIds.size(); ++i) {
            this.ids[i] = fieldIds.get(i);
        }
        this.initializeMap(this.ids);
    }

    private void initializeMap(int[] vals) {
        ParseResult finalRes;
        int size = Math.max(BinarySchema.nextPowerOfTwo(vals.length) << 2, 32);
        assert (size > 0);
        ParseResult res1 = BinarySchema.parse(vals, size);
        if (res1.collisions == 0) {
            finalRes = res1;
        } else {
            ParseResult res2 = BinarySchema.parse(vals, size * 2);
            finalRes = res2.collisions == 0 ? res2 : BinarySchema.parse(vals, size * 4);
        }
        this.idToOrderData = finalRes.data;
        this.idToOrderMask = BinarySchema.maskForPowerOfTwo(this.idToOrderData.length / 2);
    }

    private static class ParseResult {
        private final int[] data;
        private final int collisions;

        private ParseResult(int[] data, int collisions) {
            this.data = data;
            this.collisions = collisions;
        }
    }
}

