/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.dr;

import org.apache.ignite.table.Tuple;
import org.gridgain.internal.dr.DrUtils;
import org.gridgain.internal.dr.common.GridCacheVersion;
import org.jetbrains.annotations.Nullable;

public class DrUpdate {
    public static final String DEFAULT_KEY_FIELD_NAME = "_key";
    public static final String DEFAULT_VALUE_FIELD_NAME = "_val";
    private final Tuple key;
    private final byte[] rawKeyBytes;
    private final Tuple value;
    private final GridCacheVersion version;

    static DrUpdate row(Tuple key, byte[] rawKeyBytes, Tuple val, GridCacheVersion version) {
        byte[] versionBytes = DrUtils.marshalVersion(version);
        val.set("DrVersion", (Object)versionBytes);
        return new DrUpdate(key, rawKeyBytes, version, val);
    }

    static DrUpdate tombstone(Tuple key, byte[] rawKeyBytes, GridCacheVersion ver) {
        return new DrUpdate(key, rawKeyBytes, ver, null);
    }

    private DrUpdate(Tuple key, byte[] rawKeyBytes, GridCacheVersion version, @Nullable Tuple value) {
        this.key = key;
        this.rawKeyBytes = rawKeyBytes;
        this.value = value;
        this.version = version;
    }

    public Tuple key() {
        return this.key;
    }

    byte[] keyBytes() {
        return this.rawKeyBytes;
    }

    @Nullable
    public Tuple value() {
        return this.value;
    }

    public GridCacheVersion version() {
        return this.version;
    }

    boolean isTombstone() {
        return this.value == null;
    }
}

