/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import io.micrometer.context.ContextSnapshot;
import java.util.Objects;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscription;
import reactor.core.CorePublisher;
import reactor.core.CoreSubscriber;
import reactor.core.Scannable;
import reactor.core.publisher.ContextPropagation;
import reactor.core.publisher.InnerConsumer;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Operators;
import reactor.core.publisher.OptimizableOperator;
import reactor.core.publisher.SourceProducer;
import reactor.util.annotation.Nullable;
import reactor.util.context.Context;

final class MonoSource<I>
extends Mono<I>
implements Scannable,
SourceProducer<I>,
OptimizableOperator<I, I> {
    final Publisher<? extends I> source;
    @Nullable
    final OptimizableOperator<?, I> optimizableOperator;

    MonoSource(Publisher<? extends I> source) {
        OptimizableOperator optimSource;
        this.source = Objects.requireNonNull(source);
        this.optimizableOperator = source instanceof OptimizableOperator ? (optimSource = (OptimizableOperator)source) : null;
    }

    @Override
    public void subscribe(CoreSubscriber<? super I> actual) {
        if (ContextPropagation.shouldPropagateContextToThreadLocals()) {
            this.source.subscribe(new MonoSourceRestoringThreadLocalsSubscriber<I>(actual));
        } else {
            this.source.subscribe(actual);
        }
    }

    @Override
    public CoreSubscriber<? super I> subscribeOrReturn(CoreSubscriber<? super I> actual) {
        return actual;
    }

    @Override
    public final CorePublisher<? extends I> source() {
        return this;
    }

    @Override
    public final OptimizableOperator<?, ? extends I> nextOptimizableSource() {
        return this.optimizableOperator;
    }

    @Override
    @Nullable
    public Object scanUnsafe(Scannable.Attr key) {
        if (key == Scannable.Attr.PARENT) {
            return this.source;
        }
        if (key == Scannable.Attr.RUN_STYLE) {
            return Scannable.from(this.source).scanUnsafe(key);
        }
        return null;
    }

    static final class MonoSourceRestoringThreadLocalsSubscriber<T>
    implements InnerConsumer<T> {
        final CoreSubscriber<? super T> actual;
        Subscription s;
        boolean done;

        MonoSourceRestoringThreadLocalsSubscriber(CoreSubscriber<? super T> actual) {
            this.actual = actual;
        }

        @Override
        @Nullable
        public Object scanUnsafe(Scannable.Attr key) {
            if (key == Scannable.Attr.PARENT) {
                return this.s;
            }
            if (key == Scannable.Attr.RUN_STYLE) {
                return Scannable.Attr.RunStyle.SYNC;
            }
            if (key == Scannable.Attr.ACTUAL) {
                return this.actual;
            }
            return null;
        }

        @Override
        public Context currentContext() {
            return this.actual.currentContext();
        }

        @Override
        public void onSubscribe(Subscription s) {
            try (ContextSnapshot.Scope ignored = ContextPropagation.setThreadLocals(this.actual.currentContext());){
                this.actual.onSubscribe(s);
            }
        }

        @Override
        public void onNext(T t) {
            this.done = true;
            try (ContextSnapshot.Scope ignored = ContextPropagation.setThreadLocals(this.actual.currentContext());){
                this.actual.onNext(t);
                this.actual.onComplete();
            }
        }

        @Override
        public void onError(Throwable t) {
            try (ContextSnapshot.Scope ignored = ContextPropagation.setThreadLocals(this.actual.currentContext());){
                if (this.done) {
                    Operators.onErrorDropped(t, this.actual.currentContext());
                    return;
                }
                this.done = true;
                this.actual.onError(t);
            }
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            try (ContextSnapshot.Scope ignored = ContextPropagation.setThreadLocals(this.actual.currentContext());){
                this.actual.onComplete();
            }
        }
    }
}

