/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.table.nearcache;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Flow;
import java.util.function.Supplier;
import org.apache.ignite.internal.continuousquery.TableRowEventBatchImpl;
import org.apache.ignite.table.ContinuousQueryWatermark;
import org.apache.ignite.table.TableRowEvent;
import org.apache.ignite.table.TableRowEventBatch;

public class NearCacheSchemaVersionAwareSubscriber<T>
implements Flow.Subscriber<TableRowEventBatch<T>> {
    private final Flow.Subscriber<TableRowEventBatch<T>> subscriber;
    private final Supplier<CompletableFuture<Integer>> latestSchemaVersionSupplier;

    public NearCacheSchemaVersionAwareSubscriber(Flow.Subscriber<TableRowEventBatch<T>> subscriber, Supplier<CompletableFuture<Integer>> latestSchemaVersionSupplier) {
        this.subscriber = subscriber;
        this.latestSchemaVersionSupplier = latestSchemaVersionSupplier;
    }

    @Override
    public void onSubscribe(Flow.Subscription subscription) {
        this.subscriber.onSubscribe(subscription);
    }

    @Override
    public void onNext(final TableRowEventBatch<T> item) {
        if (item.rows().isEmpty()) {
            this.subscriber.onNext(item);
        } else {
            this.latestSchemaVersionSupplier.get().thenAccept(latestSchemaVersion -> {
                Integer batchSchemaVersion = ((TableRowEventBatchImpl)item).schemaVersion();
                if (Objects.equals(batchSchemaVersion, latestSchemaVersion)) {
                    this.subscriber.onNext(item);
                } else {
                    this.subscriber.onNext(new TableRowEventBatch<T>(){

                        @Override
                        public List<TableRowEvent<T>> rows() {
                            return Collections.emptyList();
                        }

                        @Override
                        public ContinuousQueryWatermark watermark() {
                            return item.watermark();
                        }
                    });
                }
            });
        }
    }

    @Override
    public void onError(Throwable throwable) {
        this.subscriber.onError(throwable);
    }

    @Override
    public void onComplete() {
        this.subscriber.onComplete();
    }
}

