/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.table.nearcache;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Flow;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.ignite.internal.lang.IgniteStringFormatter;
import org.apache.ignite.internal.marshaller.ValidationUtils;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.ViewUtils;
import org.apache.ignite.lang.AsyncCursor;
import org.apache.ignite.lang.Cursor;
import org.apache.ignite.lang.NullableValue;
import org.apache.ignite.lang.UnexpectedNullValueException;
import org.apache.ignite.table.ContinuousQueryOptions;
import org.apache.ignite.table.DataStreamerItem;
import org.apache.ignite.table.DataStreamerOptions;
import org.apache.ignite.table.DataStreamerReceiverDescriptor;
import org.apache.ignite.table.KeyValueView;
import org.apache.ignite.table.TableRowEventBatch;
import org.apache.ignite.table.Tuple;
import org.apache.ignite.table.criteria.Criteria;
import org.apache.ignite.table.criteria.CriteriaQueryOptions;
import org.apache.ignite.tx.Transaction;
import org.gridgain.internal.table.nearcache.NearCache;
import org.gridgain.internal.table.nearcache.NearCacheKey;
import org.gridgain.internal.table.nearcache.NearCacheValue;
import org.jetbrains.annotations.Nullable;

public class NearCacheKeyValueView<K, V, T>
implements KeyValueView<K, V> {
    private final KeyValueView<K, V> delegate;
    private final NearCache<K, V, T> nearCache;
    private final Consumer<String> nullableOperatationValidator;

    public NearCacheKeyValueView(KeyValueView<K, V> delegate, NearCache<K, V, T> nearCache) {
        assert (delegate != null);
        assert (nearCache != null);
        this.delegate = delegate;
        this.nearCache = nearCache;
        Class valueType = nearCache.valueType();
        this.nullableOperatationValidator = valueType == Tuple.class ? opName -> {} : opName -> ValidationUtils.validateNullableOperation(valueType, opName);
    }

    @Override
    public V get(@Nullable Transaction tx, K key) {
        Objects.requireNonNull(key, "key");
        NearCacheKeyValueView.checkNoExplicitTransaction(tx);
        return ViewUtils.sync(this.doGet(key, "getNullable"));
    }

    @Override
    public CompletableFuture<V> getAsync(@Nullable Transaction tx, K key) {
        Objects.requireNonNull(key, "key");
        NearCacheKeyValueView.checkNoExplicitTransaction(tx);
        return this.doGet(key, "getNullableAsync");
    }

    private CompletableFuture<V> doGet(K key, String altMethod) {
        return this.nearCache.getAsync(key).thenApply(nearCacheValue -> {
            if (!nearCacheValue.exists()) {
                return null;
            }
            Object value = nearCacheValue.value();
            if (value == null) {
                throw new UnexpectedNullValueException(IgniteStringFormatter.format("Got unexpected null value: use `{}` sibling method instead.", altMethod));
            }
            return value;
        });
    }

    @Override
    @Nullable
    public NullableValue<V> getNullable(@Nullable Transaction tx, K key) {
        Objects.requireNonNull(key, "key");
        NearCacheKeyValueView.checkNoExplicitTransaction(tx);
        this.nullableOperatationValidator.accept("getNullable");
        return ViewUtils.sync(this.doGetNullable(key));
    }

    @Override
    public CompletableFuture<NullableValue<V>> getNullableAsync(@Nullable Transaction tx, K key) {
        Objects.requireNonNull(key, "key");
        NearCacheKeyValueView.checkNoExplicitTransaction(tx);
        this.nullableOperatationValidator.accept("getNullableAsync");
        return this.doGetNullable(key);
    }

    private CompletableFuture<NullableValue<V>> doGetNullable(K key) {
        return this.nearCache.getAsync(key).thenApply(NearCacheValue::nullableValue);
    }

    @Override
    public V getOrDefault(@Nullable Transaction tx, K key, V defaultValue) {
        return ViewUtils.sync(this.getOrDefaultAsync(tx, key, defaultValue));
    }

    @Override
    public CompletableFuture<V> getOrDefaultAsync(@Nullable Transaction tx, K key, @Nullable V defaultValue) {
        Objects.requireNonNull(key, "key");
        NearCacheKeyValueView.checkNoExplicitTransaction(tx);
        return this.nearCache.getAsync(key).thenApply(v -> v.value() == null ? defaultValue : v.value());
    }

    @Override
    public Map<K, V> getAll(@Nullable Transaction tx, Collection<K> keys) {
        return ViewUtils.sync(this.getAllAsync(tx, keys));
    }

    @Override
    public CompletableFuture<Map<K, V>> getAllAsync(@Nullable Transaction tx, Collection<K> keys) {
        ViewUtils.checkKeysForNulls(keys);
        NearCacheKeyValueView.checkNoExplicitTransaction(tx);
        return this.nearCache.getAllAsync(keys).thenApply(result -> {
            HashMap ret = new HashMap(result.size());
            for (Map.Entry entry : result.entrySet()) {
                NearCacheValue nearCacheVal = (NearCacheValue)entry.getValue();
                if (!nearCacheVal.exists()) continue;
                ret.put(((NearCacheKey)entry.getKey()).key(), nearCacheVal.value());
            }
            return ret;
        });
    }

    @Override
    public boolean contains(@Nullable Transaction tx, K key) {
        return ViewUtils.sync(this.containsAsync(tx, key));
    }

    @Override
    public CompletableFuture<Boolean> containsAsync(@Nullable Transaction tx, K key) {
        Objects.requireNonNull(key, "key");
        NearCacheKeyValueView.checkNoExplicitTransaction(tx);
        return this.nearCache.getAsync(key).thenApply(NearCacheValue::exists);
    }

    @Override
    public boolean containsAll(@Nullable Transaction tx, Collection<K> keys) {
        return ViewUtils.sync(this.containsAllAsync(tx, keys));
    }

    @Override
    public CompletableFuture<Boolean> containsAllAsync(@Nullable Transaction tx, Collection<K> keys) {
        ViewUtils.checkKeysForNulls(keys);
        NearCacheKeyValueView.checkNoExplicitTransaction(tx);
        if (keys.isEmpty()) {
            return CompletableFutures.trueCompletedFuture();
        }
        return this.nearCache.getAllAsync(keys).thenApply(result -> {
            for (Map.Entry entry : result.entrySet()) {
                NearCacheValue nearCacheVal = (NearCacheValue)entry.getValue();
                if (nearCacheVal.exists()) continue;
                return false;
            }
            return true;
        });
    }

    @Override
    public void put(@Nullable Transaction tx, K key, @Nullable V val) {
        Objects.requireNonNull(key, "key");
        NearCacheKeyValueView.checkNoExplicitTransaction(tx);
        this.withInvalidationSync(key, () -> this.delegate.put(null, key, val));
    }

    @Override
    public CompletableFuture<Void> putAsync(@Nullable Transaction tx, K key, @Nullable V val) {
        Objects.requireNonNull(key, "key");
        NearCacheKeyValueView.checkNoExplicitTransaction(tx);
        return this.withInvalidation(key, () -> this.delegate.putAsync(null, key, val));
    }

    @Override
    public void putAll(@Nullable Transaction tx, Map<K, V> pairs) {
        ViewUtils.sync(this.putAllAsync(tx, pairs));
    }

    @Override
    public CompletableFuture<Void> putAllAsync(@Nullable Transaction tx, Map<K, V> pairs) {
        Objects.requireNonNull(pairs, "pairs");
        NearCacheKeyValueView.checkNoExplicitTransaction(tx);
        return this.withInvalidation((Collection<K>)pairs.keySet(), () -> this.delegate.putAllAsync(null, pairs));
    }

    @Override
    @Nullable
    public V getAndPut(@Nullable Transaction tx, K key, @Nullable V val) {
        Objects.requireNonNull(key, "key");
        NearCacheKeyValueView.checkNoExplicitTransaction(tx);
        return (V)this.withInvalidationSync(key, () -> this.delegate.getAndPut(null, key, val));
    }

    @Override
    public CompletableFuture<V> getAndPutAsync(@Nullable Transaction tx, K key, @Nullable V val) {
        Objects.requireNonNull(key, "key");
        NearCacheKeyValueView.checkNoExplicitTransaction(tx);
        return this.withInvalidation(key, () -> this.delegate.getAndPutAsync(null, key, val));
    }

    @Override
    public NullableValue<V> getNullableAndPut(@Nullable Transaction tx, K key, @Nullable V val) {
        Objects.requireNonNull(key, "key");
        this.nullableOperatationValidator.accept("getNullableAndPut");
        return ViewUtils.sync(this.getNullableAndPutAsync(tx, key, val));
    }

    @Override
    public CompletableFuture<NullableValue<V>> getNullableAndPutAsync(@Nullable Transaction tx, K key, @Nullable V val) {
        Objects.requireNonNull(key, "key");
        NearCacheKeyValueView.checkNoExplicitTransaction(tx);
        this.nullableOperatationValidator.accept("getNullableAndPutAsync");
        return this.withInvalidation(key, () -> this.delegate.getNullableAndPutAsync(null, key, val));
    }

    @Override
    public boolean putIfAbsent(@Nullable Transaction tx, K key, @Nullable V val) {
        return ViewUtils.sync(this.putIfAbsentAsync(tx, key, val));
    }

    @Override
    public CompletableFuture<Boolean> putIfAbsentAsync(@Nullable Transaction tx, K key, @Nullable V val) {
        Objects.requireNonNull(key, "key");
        NearCacheKeyValueView.checkNoExplicitTransaction(tx);
        return this.withInvalidation(key, () -> this.delegate.putIfAbsentAsync(null, key, val));
    }

    @Override
    public boolean remove(@Nullable Transaction tx, K key) {
        return ViewUtils.sync(this.removeAsync(tx, key));
    }

    @Override
    public boolean remove(@Nullable Transaction tx, K key, V val) {
        return ViewUtils.sync(this.removeAsync(tx, key, val));
    }

    @Override
    public CompletableFuture<Boolean> removeAsync(@Nullable Transaction tx, K key) {
        Objects.requireNonNull(key, "key");
        NearCacheKeyValueView.checkNoExplicitTransaction(tx);
        return this.withInvalidation(key, () -> this.delegate.removeAsync(null, key));
    }

    @Override
    public CompletableFuture<Boolean> removeAsync(@Nullable Transaction tx, K key, V val) {
        Objects.requireNonNull(key, "key");
        NearCacheKeyValueView.checkNoExplicitTransaction(tx);
        return this.withInvalidation(key, () -> this.delegate.removeAsync(null, key, val));
    }

    @Override
    public void removeAll(@Nullable Transaction tx) {
        ViewUtils.sync(this.removeAllAsync(tx));
    }

    @Override
    public Collection<K> removeAll(@Nullable Transaction tx, Collection<K> keys) {
        return ViewUtils.sync(this.removeAllAsync(tx, keys));
    }

    @Override
    public CompletableFuture<Collection<K>> removeAllAsync(@Nullable Transaction tx, Collection<K> keys) {
        Objects.requireNonNull(keys, "keys");
        NearCacheKeyValueView.checkNoExplicitTransaction(tx);
        return this.withInvalidation(keys, () -> this.delegate.removeAllAsync(null, keys));
    }

    @Override
    public CompletableFuture<Void> removeAllAsync(@Nullable Transaction tx) {
        NearCacheKeyValueView.checkNoExplicitTransaction(tx);
        this.nearCache.invalidateAll();
        return this.delegate.removeAllAsync(null);
    }

    @Override
    @Nullable
    public V getAndRemove(@Nullable Transaction tx, K key) {
        Objects.requireNonNull(key, "key");
        NearCacheKeyValueView.checkNoExplicitTransaction(tx);
        return (V)this.withInvalidationSync(key, () -> this.delegate.getAndRemove(null, key));
    }

    @Override
    public CompletableFuture<V> getAndRemoveAsync(@Nullable Transaction tx, K key) {
        Objects.requireNonNull(key, "key");
        NearCacheKeyValueView.checkNoExplicitTransaction(tx);
        return this.withInvalidation(key, () -> this.delegate.getAndRemoveAsync(null, key));
    }

    @Override
    public NullableValue<V> getNullableAndRemove(@Nullable Transaction tx, K key) {
        Objects.requireNonNull(key, "key");
        NearCacheKeyValueView.checkNoExplicitTransaction(tx);
        this.nullableOperatationValidator.accept("getNullableAndRemove");
        return this.withInvalidationSync(key, () -> this.delegate.getNullableAndRemove(null, key));
    }

    @Override
    public CompletableFuture<NullableValue<V>> getNullableAndRemoveAsync(@Nullable Transaction tx, K key) {
        Objects.requireNonNull(key, "key");
        NearCacheKeyValueView.checkNoExplicitTransaction(tx);
        this.nullableOperatationValidator.accept("getNullableAndRemoveAsync");
        return this.withInvalidation(key, () -> this.delegate.getNullableAndRemoveAsync(null, key));
    }

    @Override
    public boolean replace(@Nullable Transaction tx, K key, @Nullable V val) {
        Objects.requireNonNull(key, "key");
        NearCacheKeyValueView.checkNoExplicitTransaction(tx);
        return this.withInvalidationSync(key, () -> this.delegate.replace(null, key, val));
    }

    @Override
    public boolean replace(@Nullable Transaction tx, K key, @Nullable V oldValue, @Nullable V newValue) {
        Objects.requireNonNull(key, "key");
        NearCacheKeyValueView.checkNoExplicitTransaction(tx);
        return this.withInvalidationSync(key, () -> this.delegate.replace(null, key, oldValue, newValue));
    }

    @Override
    public CompletableFuture<Boolean> replaceAsync(@Nullable Transaction tx, K key, @Nullable V val) {
        Objects.requireNonNull(key, "key");
        NearCacheKeyValueView.checkNoExplicitTransaction(tx);
        return this.withInvalidation(key, () -> this.delegate.replaceAsync(null, key, val));
    }

    @Override
    public CompletableFuture<Boolean> replaceAsync(@Nullable Transaction tx, K key, @Nullable V oldVal, @Nullable V newVal) {
        Objects.requireNonNull(key, "key");
        NearCacheKeyValueView.checkNoExplicitTransaction(tx);
        return this.withInvalidation(key, () -> this.delegate.replaceAsync(null, key, oldVal, newVal));
    }

    @Override
    @Nullable
    public V getAndReplace(@Nullable Transaction tx, K key, @Nullable V val) {
        Objects.requireNonNull(key, "key");
        NearCacheKeyValueView.checkNoExplicitTransaction(tx);
        return (V)this.withInvalidationSync(key, () -> this.delegate.getAndReplace(null, key, val));
    }

    @Override
    public CompletableFuture<V> getAndReplaceAsync(@Nullable Transaction tx, K key, @Nullable V val) {
        Objects.requireNonNull(key, "key");
        NearCacheKeyValueView.checkNoExplicitTransaction(tx);
        return this.withInvalidation(key, () -> this.delegate.getAndReplaceAsync(null, key, val));
    }

    @Override
    public NullableValue<V> getNullableAndReplace(@Nullable Transaction tx, K key, @Nullable V val) {
        Objects.requireNonNull(key, "key");
        NearCacheKeyValueView.checkNoExplicitTransaction(tx);
        this.nullableOperatationValidator.accept("getNullableAndReplace");
        return this.withInvalidationSync(key, () -> this.delegate.getNullableAndReplace(null, key, val));
    }

    @Override
    public CompletableFuture<NullableValue<V>> getNullableAndReplaceAsync(@Nullable Transaction tx, K key, @Nullable V val) {
        Objects.requireNonNull(key, "key");
        NearCacheKeyValueView.checkNoExplicitTransaction(tx);
        this.nullableOperatationValidator.accept("getNullableAndReplaceAsync");
        return this.withInvalidation(key, () -> this.delegate.getNullableAndReplaceAsync(null, key, val));
    }

    @Override
    public void queryContinuously(Flow.Subscriber<TableRowEventBatch<Map.Entry<K, V>>> subscriber, @Nullable ContinuousQueryOptions options) {
        throw new UnsupportedOperationException("Continuous Query with Near Cache is not supported.");
    }

    @Override
    public CompletableFuture<Void> streamData(Flow.Publisher<DataStreamerItem<Map.Entry<K, V>>> publisher, @Nullable DataStreamerOptions options) {
        throw new UnsupportedOperationException("Data Streamer with Near Cache is not supported.");
    }

    @Override
    public <E, P, A, R> CompletableFuture<Void> streamData(Flow.Publisher<E> publisher, DataStreamerReceiverDescriptor<P, A, R> receiver, Function<E, Map.Entry<K, V>> keyFunc, Function<E, P> payloadFunc, @Nullable A receiverArg, @Nullable Flow.Subscriber<R> resultSubscriber, @Nullable DataStreamerOptions options) {
        throw new UnsupportedOperationException("Data Streamer with Near Cache is not supported.");
    }

    @Override
    public Cursor<Map.Entry<K, V>> query(@Nullable Transaction tx, @Nullable Criteria criteria, @Nullable String indexName, @Nullable CriteriaQueryOptions opts) {
        throw new UnsupportedOperationException("Criteria Query with Near Cache is not supported.");
    }

    @Override
    public CompletableFuture<AsyncCursor<Map.Entry<K, V>>> queryAsync(@Nullable Transaction tx, @Nullable Criteria criteria, @Nullable String indexName, @Nullable CriteriaQueryOptions opts) {
        throw new UnsupportedOperationException("Criteria Query with Near Cache is not supported.");
    }

    private static void checkNoExplicitTransaction(@Nullable Transaction tx) {
        if (tx != null) {
            throw new UnsupportedOperationException("Explicit transactions are not supported on views with Near Cache.");
        }
    }

    private <R> void withInvalidationSync(K key, Runnable delegate) {
        this.withInvalidationSync(key, () -> {
            delegate.run();
            return null;
        });
    }

    private <R> R withInvalidationSync(K key, Supplier<R> delegate) {
        CompletableFuture<Void> invalidationFuture = this.nearCache.invalidateAsync(key);
        R value = delegate.get();
        invalidationFuture.join();
        return value;
    }

    private <R> CompletableFuture<R> withInvalidation(K key, Supplier<CompletableFuture<R>> delegate) {
        CompletableFuture valueFuture = delegate.get();
        return CompletableFuture.allOf(this.nearCache.invalidateAsync(key), valueFuture).thenCompose(ignored -> valueFuture);
    }

    private <R> CompletableFuture<R> withInvalidation(Collection<K> keys, Supplier<CompletableFuture<R>> delegate) {
        CompletableFuture valueFuture = delegate.get();
        return CompletableFuture.allOf(this.nearCache.invalidateAllAsync(keys), valueFuture).thenCompose(ignored -> valueFuture);
    }

    @Override
    public void close() throws Exception {
        IgniteUtils.closeAll(this.nearCache, this.delegate);
    }
}

