/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.license;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigObject;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.gridgain.internal.license.Edition;
import org.gridgain.internal.license.LicenseFeature;
import org.gridgain.internal.license.LicenseField;
import org.jetbrains.annotations.Nullable;

public class HoconLicenseField<T>
implements LicenseField<T> {
    private static final DateTimeFormatter LICENSE_DATE_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private static final Map<String, LicenseFeature> FEATURE_BY_NAME = Stream.of(LicenseFeature.values()).collect(Collectors.toMap(Enum::name, Function.identity()));
    public static final HoconLicenseField<String> ID = new HoconLicenseField<String>("id", Config::getString);
    public static final HoconLicenseField<Edition> EDITION = new HoconLicenseField<Edition>("edition", (cfg, path) -> cfg.getEnum(Edition.class, (String)path));
    public static final HoconLicenseField<ConfigObject> INFOS = new HoconLicenseField<ConfigObject>("infos", Config::getObject);
    public static final HoconLicenseField<ConfigObject> LIMITS = new HoconLicenseField<ConfigObject>("limits", Config::getObject);
    public static final HoconLicenseField<String> RELEASE_TYPE = new HoconLicenseField<String>("releaseType", Config::getString);
    public static final HoconLicenseField<Set<LicenseFeature>> FEATURES = new HoconLicenseField<Set>("features", HoconLicenseField::readFeatures);
    public static final HoconLicenseField<LocalDate> START_DATE = new HoconLicenseField<LocalDate>("limits.startDate", HoconLicenseField::readDate);
    public static final HoconLicenseField<LocalDate> EXPIRE_DATE = new HoconLicenseField<LocalDate>("limits.expireDate", HoconLicenseField::readDate);
    public static final HoconLicenseField<Integer> MAX_CORES = new HoconLicenseField<Integer>("limits.maxCores", Config::getInt);
    public static final HoconLicenseField<Integer> MAX_NODES = new HoconLicenseField<Integer>("limits.maxNodes", Config::getInt);
    public static final HoconLicenseField<Integer> MAX_HOSTS = new HoconLicenseField<Integer>("limits.maxComputers", Config::getInt);
    public static final HoconLicenseField<Long> MAX_HEAP_SIZE = new HoconLicenseField<Long>("limits.maxHeapSize", Config::getLong);
    public static final HoconLicenseField<Long> MAX_OFFHEAP_SIZE = new HoconLicenseField<Long>("limits.maxOffHeapSize", Config::getLong);
    public static final HoconLicenseField<Long> MAX_RAM_SIZE = new HoconLicenseField<Long>("limits.maxHostRamSize", Config::getLong);
    public static final HoconLicenseField<Long> MAX_DISK_SIZE = new HoconLicenseField<Long>("limits.maxOnDiskDataSize", Config::getLong);
    private final String path;
    private final BiFunction<Config, String, T> fieldReader;

    private HoconLicenseField(String path, BiFunction<Config, String, T> fieldReader) {
        this.path = path;
        this.fieldReader = fieldReader;
    }

    @Override
    @Nullable
    public T readFrom(Object object) {
        Config hoconObject = (Config)object;
        if (!hoconObject.hasPath(this.path)) {
            return null;
        }
        return this.fieldReader.apply(hoconObject, this.path);
    }

    private static Set<LicenseFeature> readFeatures(Config hoconObject, String path) {
        return hoconObject.getStringList(path).stream().map(FEATURE_BY_NAME::get).filter(Objects::nonNull).collect(Collectors.toUnmodifiableSet());
    }

    @Nullable
    private static LocalDate readDate(Config hoconObject, String path) {
        try {
            return LocalDate.parse(hoconObject.getString(path), LICENSE_DATE_FORMAT);
        }
        catch (Exception ignored) {
            return null;
        }
    }
}

